/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.pades;

import com.itextpdf.signatures.validation.report.pades.AbstractPadesLevelRequirements;
import com.itextpdf.signatures.validation.report.pades.PAdESLevel;
import java.util.HashMap;
import java.util.Map;

class DocumentTimestampRequirements
extends AbstractPadesLevelRequirements {
    public static final String SUBFILTER_NOT_ETSI_RFC3161 = "Timestamp SubFilter entry value is not ETSI.RFC3161";
    private static final Map<PAdESLevel, AbstractPadesLevelRequirements.LevelChecks> CHECKS = new HashMap<PAdESLevel, AbstractPadesLevelRequirements.LevelChecks>();
    private static final Map<PAdESLevel, AbstractPadesLevelRequirements.LevelChecks> DSS_COVERED_TS_CHECKS = new HashMap<PAdESLevel, AbstractPadesLevelRequirements.LevelChecks>();
    private final boolean coveredByDss;

    public DocumentTimestampRequirements(String name, boolean coveredByDss) {
        super(name);
        this.coveredByDss = coveredByDss;
    }

    @Override
    protected Map<PAdESLevel, AbstractPadesLevelRequirements.LevelChecks> getChecks() {
        if (this.coveredByDss) {
            return DSS_COVERED_TS_CHECKS;
        }
        return CHECKS;
    }

    static {
        AbstractPadesLevelRequirements.LevelChecks bbChecks = new AbstractPadesLevelRequirements.LevelChecks();
        CHECKS.put(PAdESLevel.B_B, bbChecks);
        AbstractPadesLevelRequirements.LevelChecks btChecks = new AbstractPadesLevelRequirements.LevelChecks();
        CHECKS.put(PAdESLevel.B_T, btChecks);
        AbstractPadesLevelRequirements.LevelChecks bltChecks = new AbstractPadesLevelRequirements.LevelChecks();
        CHECKS.put(PAdESLevel.B_LT, bltChecks);
        AbstractPadesLevelRequirements.LevelChecks bltaChecks = new AbstractPadesLevelRequirements.LevelChecks();
        CHECKS.put(PAdESLevel.B_LTA, bltaChecks);
        bltaChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> r.timestampDictionaryEntrySubFilterValueEtsiRfc3161, SUBFILTER_NOT_ETSI_RFC3161));
        AbstractPadesLevelRequirements.LevelChecks dssBbChecks = new AbstractPadesLevelRequirements.LevelChecks();
        dssBbChecks.shalls.addAll(bbChecks.shalls);
        dssBbChecks.shoulds.addAll(bbChecks.shoulds);
        DSS_COVERED_TS_CHECKS.put(PAdESLevel.B_B, dssBbChecks);
        AbstractPadesLevelRequirements.LevelChecks dssBtChecks = new AbstractPadesLevelRequirements.LevelChecks();
        dssBtChecks.shalls.addAll(btChecks.shalls);
        dssBtChecks.shoulds.addAll(btChecks.shoulds);
        DSS_COVERED_TS_CHECKS.put(PAdESLevel.B_T, dssBtChecks);
        AbstractPadesLevelRequirements.LevelChecks dssBltChecks = new AbstractPadesLevelRequirements.LevelChecks();
        dssBltChecks.shalls.addAll(bltChecks.shalls);
        dssBltChecks.shoulds.addAll(bltChecks.shoulds);
        DSS_COVERED_TS_CHECKS.put(PAdESLevel.B_LT, dssBltChecks);
        dssBltChecks.shalls.add(DocumentTimestampRequirements.createRevocationDssUsageCheck());
        bltChecks.shalls.add(DocumentTimestampRequirements.createCertificateExternalRetrievalCheck());
        dssBltChecks.shoulds.add(DocumentTimestampRequirements.createCertificatesDssUsageCheck());
        AbstractPadesLevelRequirements.LevelChecks dssBltaChecks = new AbstractPadesLevelRequirements.LevelChecks();
        dssBltaChecks.shalls.addAll(bltaChecks.shalls);
        dssBltaChecks.shoulds.addAll(bltaChecks.shoulds);
        dssBltaChecks.shalls.add(DocumentTimestampRequirements.createRevocationDssPoECoverage());
        DSS_COVERED_TS_CHECKS.put(PAdESLevel.B_LTA, dssBltaChecks);
    }
}

