/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.pades;

import com.itextpdf.signatures.validation.report.pades.PAdESLevel;
import com.itextpdf.signatures.validation.report.pades.PAdESLevelReport;
import java.util.HashMap;
import java.util.Map;

public class DocumentPAdESLevelReport {
    private final Map<String, PAdESLevelReport> signatureReports = new HashMap<String, PAdESLevelReport>();

    public void addPAdESReport(PAdESLevelReport report) {
        this.signatureReports.put(report.getSignatureName(), report);
    }

    public PAdESLevel getDocumentLevel() {
        if (this.signatureReports.isEmpty()) {
            return PAdESLevel.NONE;
        }
        PAdESLevel result = PAdESLevel.B_LTA;
        for (PAdESLevelReport rep : this.signatureReports.values()) {
            if (rep.getLevel().compareTo(result) >= 0) continue;
            result = rep.getLevel();
        }
        return result;
    }

    public PAdESLevelReport getSignatureReport(String signatureName) {
        return this.signatureReports.get(signatureName);
    }

    public Map<String, PAdESLevelReport> getSignatureReports() {
        return this.signatureReports;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(70);
        sb.append("Document highest PAdES level: ").append((Object)this.getDocumentLevel()).append('\n');
        for (PAdESLevelReport report : this.signatureReports.values()) {
            sb.append(report).append('\n');
        }
        return sb.toString();
    }
}

