/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl.criteria;

import com.itextpdf.signatures.validation.lotl.criteria.Criteria;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class CriteriaList
implements Criteria {
    private final List<Criteria> criterias = new ArrayList<Criteria>();
    private final String assertValue;

    public CriteriaList(String assertValue) {
        this.assertValue = assertValue;
    }

    public String getAssertValue() {
        return this.assertValue;
    }

    public void addCriteria(Criteria criteria) {
        this.criterias.add(criteria);
    }

    public List<Criteria> getCriteriaList() {
        return new ArrayList<Criteria>(this.criterias);
    }

    @Override
    public boolean checkCriteria(X509Certificate certificate) {
        switch (this.assertValue) {
            case "all": {
                for (Criteria criteria : this.criterias) {
                    if (criteria.checkCriteria(certificate)) continue;
                    return false;
                }
                return true;
            }
            case "atLeastOne": {
                for (Criteria criteria : this.criterias) {
                    if (!criteria.checkCriteria(certificate)) continue;
                    return true;
                }
                return false;
            }
            case "none": {
                for (Criteria criteria : this.criterias) {
                    if (!criteria.checkCriteria(certificate)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

