/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl.criteria;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.signatures.validation.lotl.criteria.Criteria;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CertSubjectDNAttributeCriteria
implements Criteria {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final List<String> requiredAttributeIds = new ArrayList<String>();

    public void addRequiredAttributeId(String requiredAttributeId) {
        this.requiredAttributeIds.add(requiredAttributeId);
    }

    public List<String> getRequiredAttributeIds() {
        return new ArrayList<String>(this.requiredAttributeIds);
    }

    @Override
    public boolean checkCriteria(X509Certificate certificate) {
        try {
            List subjectAttributes = Arrays.stream(FACTORY.createJcaX509CertificateHolder(certificate).getSubjectAttributeTypes()).map(asn1Attribute -> asn1Attribute.getId()).collect(Collectors.toList());
            for (String requiredAttributeId : this.requiredAttributeIds) {
                if (subjectAttributes.contains(requiredAttributeId)) continue;
                return false;
            }
            return true;
        }
        catch (CertificateEncodingException ignored) {
            return false;
        }
    }
}

