/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.validation.lotl.CountrySpecificLotl;
import com.itextpdf.signatures.validation.lotl.LotlFetchingProperties;
import com.itextpdf.signatures.validation.lotl.xml.IDefaultXmlHandler;
import com.itextpdf.signatures.validation.lotl.xml.XmlSaxProcessor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class XmlCountryRetriever {
    public List<CountrySpecificLotl> getAllCountriesLotlFilesLocation(InputStream data, LotlFetchingProperties lotlFetchingProperties) {
        TSLLocationExtractor tslLocationExtractor = new TSLLocationExtractor();
        new XmlSaxProcessor().process(data, tslLocationExtractor);
        List<CountrySpecificLotl> countrySpecificLotls = tslLocationExtractor.tslLocations;
        return countrySpecificLotls.stream().filter(countrySpecificLotl -> lotlFetchingProperties.shouldProcessCountry(countrySpecificLotl.getSchemeTerritory())).collect(Collectors.toList());
    }

    private static final class TSLLocationExtractor
    implements IDefaultXmlHandler {
        private static final Set<String> INFORMATION_TAGS = new HashSet<String>();
        private static final String MIME_TYPE_ETSI_TSL = "application/vnd.etsi.tsl+xml";
        final List<CountrySpecificLotl> tslLocations = new ArrayList<CountrySpecificLotl>();
        private String schemeTerritory;
        private String tslLocation;
        private String mimeType;
        private StringBuilder information;

        TSLLocationExtractor() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, HashMap<String, String> attributes) {
            if (INFORMATION_TAGS.contains(localName)) {
                this.information = new StringBuilder();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            switch (localName) {
                case "OtherTSLPointer": {
                    CountrySpecificLotl data = new CountrySpecificLotl(this.schemeTerritory, this.tslLocation, this.mimeType);
                    if (TSLLocationExtractor.isXmlLink(data)) {
                        this.tslLocations.add(data);
                    }
                    this.resetState();
                    break;
                }
                case "SchemeTerritory": {
                    this.schemeTerritory = this.information.toString();
                    break;
                }
                case "TSLLocation": {
                    this.tslLocation = this.information.toString();
                    break;
                }
                case "MimeType": {
                    this.mimeType = this.information.toString();
                    break;
                }
            }
            this.information = null;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length).trim();
            if (value.isEmpty()) {
                return;
            }
            if (this.information != null) {
                this.information.append(ch, start, length);
            }
        }

        private void resetState() {
            this.schemeTerritory = null;
            this.tslLocation = null;
            this.mimeType = null;
        }

        private static boolean isXmlLink(CountrySpecificLotl data) {
            return MIME_TYPE_ETSI_TSL.equals(data.getMimeType());
        }

        static {
            INFORMATION_TAGS.add("SchemeTerritory");
            INFORMATION_TAGS.add("TSLLocation");
            INFORMATION_TAGS.add("MimeType");
        }
    }
}

