/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.validation.lotl.AbstractXmlCertificateHandler;
import com.itextpdf.signatures.validation.lotl.AdditionalServiceInformationExtension;
import com.itextpdf.signatures.validation.lotl.CountryServiceContext;
import com.itextpdf.signatures.validation.lotl.QualifierExtension;
import com.itextpdf.signatures.validation.lotl.ServiceChronologicalInfo;
import com.itextpdf.signatures.validation.lotl.criteria.CertSubjectDNAttributeCriteria;
import com.itextpdf.signatures.validation.lotl.criteria.CriteriaList;
import com.itextpdf.signatures.validation.lotl.criteria.ExtendedKeyUsageCriteria;
import com.itextpdf.signatures.validation.lotl.criteria.KeyUsageCriteria;
import com.itextpdf.signatures.validation.lotl.criteria.PolicySetCriteria;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

class XmlCountryCertificateHandler
extends AbstractXmlCertificateHandler {
    private static final Set<String> INFORMATION_TAGS = new HashSet<String>();
    private final Set<String> serviceTypes;
    private StringBuilder information;
    private CountryServiceContext currentServiceContext = null;
    private ServiceChronologicalInfo currentServiceChronologicalInfo = null;
    private AdditionalServiceInformationExtension currentServiceExtension = null;
    private QualifierExtension currentQualifierExtension = null;
    private final LinkedList<CriteriaList> criteriaListQueue = new LinkedList();
    private PolicySetCriteria currentPolicySetCriteria = null;
    private CertSubjectDNAttributeCriteria currentCertSubjectDNAttributeCriteria = null;
    private ExtendedKeyUsageCriteria currentExtendedKeyUsageCriteria = null;
    private KeyUsageCriteria currentKeyUsageCriteria = null;
    private String currentKeyUsageBitName = null;

    XmlCountryCertificateHandler(Set<String> serviceTypes) {
        this.serviceTypes = new HashSet<String>(serviceTypes);
    }

    @Override
    public void startElement(String uri, String localName, String qName, HashMap<String, String> attributes) {
        if (INFORMATION_TAGS.contains(localName)) {
            this.information = new StringBuilder();
        }
        if ("TSPService".equals(localName)) {
            this.startProvider();
        } else if ("ServiceHistoryInstance".equals(localName) || "ServiceInformation".equals(localName)) {
            this.currentServiceChronologicalInfo = new ServiceChronologicalInfo();
        } else if ("AdditionalServiceInformation".equals(localName)) {
            this.currentServiceExtension = new AdditionalServiceInformationExtension();
        } else if ("QualificationElement".equals(localName)) {
            this.currentQualifierExtension = new QualifierExtension();
        } else if ("Qualifier".equals(localName)) {
            this.currentQualifierExtension.addQualifier(attributes.get("uri"));
        } else if ("CriteriaList".equals(localName)) {
            CriteriaList criteriaList = new CriteriaList(attributes.get("assert"));
            if (this.criteriaListQueue.isEmpty()) {
                this.currentQualifierExtension.setCriteriaList(criteriaList);
            } else {
                this.criteriaListQueue.peekLast().addCriteria(criteriaList);
            }
            this.criteriaListQueue.add(criteriaList);
        } else if ("PolicySet".equals(localName)) {
            this.currentPolicySetCriteria = new PolicySetCriteria();
        } else if ("CertSubjectDNAttribute".equals(localName)) {
            this.currentCertSubjectDNAttributeCriteria = new CertSubjectDNAttributeCriteria();
        } else if ("ExtendedKeyUsage".equals(localName)) {
            this.currentExtendedKeyUsageCriteria = new ExtendedKeyUsageCriteria();
        } else if ("KeyUsage".equals(localName)) {
            this.currentKeyUsageCriteria = new KeyUsageCriteria();
        } else if ("KeyUsageBit".equals(localName)) {
            this.currentKeyUsageBitName = attributes.get("name");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (localName) {
            case "TSPService": {
                this.endProvider();
                break;
            }
            case "X509Certificate": {
                this.addCertificateToContext(this.information.toString());
                this.information = null;
                break;
            }
            case "ServiceStatus": {
                if (this.currentServiceChronologicalInfo != null) {
                    this.currentServiceChronologicalInfo.setServiceStatus(this.information.toString());
                }
                this.information = null;
                break;
            }
            case "ServiceTypeIdentifier": {
                if (this.currentServiceContext != null) {
                    if (this.serviceTypes.isEmpty() || this.serviceTypes.contains(this.information.toString())) {
                        this.currentServiceContext.setServiceType(this.information.toString());
                    } else {
                        this.currentServiceContext = null;
                    }
                }
                this.information = null;
                break;
            }
            case "StatusStartingTime": {
                if (this.currentServiceChronologicalInfo != null) {
                    this.currentServiceChronologicalInfo.setServiceStatusStartingTime(this.information.toString());
                }
                this.information = null;
                break;
            }
            case "ServiceInformation": 
            case "ServiceHistoryInstance": {
                if (this.currentServiceContext != null) {
                    this.currentServiceContext.addServiceChronologicalInfo(this.currentServiceChronologicalInfo);
                }
                this.currentServiceChronologicalInfo = null;
                break;
            }
            case "URI": {
                if (this.currentServiceExtension == null) break;
                this.currentServiceExtension.setUri(this.information.toString());
                break;
            }
            case "AdditionalServiceInformation": {
                if (this.currentServiceChronologicalInfo != null) {
                    this.currentServiceChronologicalInfo.addServiceExtension(this.currentServiceExtension);
                }
                this.currentServiceExtension = null;
                break;
            }
            case "QualificationElement": {
                if (this.currentServiceChronologicalInfo != null) {
                    this.currentServiceChronologicalInfo.addQualifierExtension(this.currentQualifierExtension);
                }
                this.currentQualifierExtension = null;
                break;
            }
            case "CriteriaList": {
                this.criteriaListQueue.pollLast();
                break;
            }
            case "PolicySet": {
                if (this.criteriaListQueue.peekLast() != null) {
                    this.criteriaListQueue.peekLast().addCriteria(this.currentPolicySetCriteria);
                }
                this.currentPolicySetCriteria = null;
                break;
            }
            case "CertSubjectDNAttribute": {
                if (this.criteriaListQueue.peekLast() != null) {
                    this.criteriaListQueue.peekLast().addCriteria(this.currentCertSubjectDNAttributeCriteria);
                }
                this.currentCertSubjectDNAttributeCriteria = null;
                break;
            }
            case "ExtendedKeyUsage": {
                if (this.criteriaListQueue.peekLast() != null) {
                    this.criteriaListQueue.peekLast().addCriteria(this.currentExtendedKeyUsageCriteria);
                }
                this.currentExtendedKeyUsageCriteria = null;
                break;
            }
            case "KeyUsage": {
                if (this.criteriaListQueue.peekLast() != null) {
                    this.criteriaListQueue.peekLast().addCriteria(this.currentKeyUsageCriteria);
                }
                this.currentKeyUsageCriteria = null;
                break;
            }
            case "Identifier": {
                if (this.currentPolicySetCriteria != null) {
                    this.currentPolicySetCriteria.addRequiredPolicyId(this.information.toString());
                    break;
                }
                if (this.currentCertSubjectDNAttributeCriteria == null) break;
                this.currentCertSubjectDNAttributeCriteria.addRequiredAttributeId(this.information.toString());
                break;
            }
            case "KeyPurposeId": {
                if (this.currentExtendedKeyUsageCriteria == null) break;
                this.currentExtendedKeyUsageCriteria.addRequiredExtendedKeyUsage(this.information.toString());
                break;
            }
            case "KeyUsageBit": {
                if (this.currentKeyUsageCriteria != null) {
                    this.currentKeyUsageCriteria.addKeyUsageBit(this.currentKeyUsageBitName, this.information.toString());
                }
                this.currentKeyUsageBitName = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.information != null) {
            this.information.append(ch, start, length);
        }
    }

    void startProvider() {
        this.currentServiceContext = new CountryServiceContext();
    }

    void addCertificateToContext(String certificateString) {
        if (this.currentServiceContext == null) {
            return;
        }
        X509Certificate certificate = CertificateUtil.createCertificateFromEncodedData(XmlCountryCertificateHandler.removeWhitespacesAndBreakLines(certificateString));
        this.currentServiceContext.addCertificate(certificate);
    }

    void endProvider() {
        if (this.currentServiceContext != null) {
            this.serviceContextList.add(this.currentServiceContext);
            this.currentServiceContext = null;
        }
    }

    private static String removeWhitespacesAndBreakLines(String data) {
        return data.replace(" ", "").replace("\n", "");
    }

    static {
        INFORMATION_TAGS.add("ServiceTypeIdentifier");
        INFORMATION_TAGS.add("ServiceStatus");
        INFORMATION_TAGS.add("X509Certificate");
        INFORMATION_TAGS.add("StatusStartingTime");
        INFORMATION_TAGS.add("URI");
        INFORMATION_TAGS.add("Identifier");
        INFORMATION_TAGS.add("KeyPurposeId");
        INFORMATION_TAGS.add("KeyUsageBit");
    }
}

