/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.validation.SafeCallingAvoidantException;
import com.itextpdf.signatures.validation.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.context.CertificateSource;
import com.itextpdf.signatures.validation.context.ValidationContext;
import com.itextpdf.signatures.validation.lotl.AdditionalServiceInformationExtension;
import com.itextpdf.signatures.validation.lotl.CountryServiceContext;
import com.itextpdf.signatures.validation.lotl.IServiceContext;
import com.itextpdf.signatures.validation.lotl.LotlService;
import com.itextpdf.signatures.validation.lotl.LotlValidator;
import com.itextpdf.signatures.validation.lotl.QualifiedValidator;
import com.itextpdf.signatures.validation.lotl.ServiceChronologicalInfo;
import com.itextpdf.signatures.validation.lotl.ServiceTypeIdentifiersConstants;
import com.itextpdf.signatures.validation.report.CertificateReportItem;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LotlTrustedStore {
    static final String REVOKED_CERTIFICATE = "Certificate {0} is revoked.";
    static final String CERTIFICATE_CHECK = "Certificate check.";
    static final String CERTIFICATE_TRUSTED = "Certificate {0} is trusted, revocation data checks are not required.";
    static final String CERTIFICATE_TRUSTED_FOR_DIFFERENT_CONTEXT = "Certificate {0} is trusted for {1}, but it is not used in this context. Validation will continue as usual.";
    static final String CERTIFICATE_SERVICE_TYPE_NOT_RECOGNIZED = "Certificate {0} is trusted, but it's service type {1} is not recognized.";
    static final String NOT_YET_VALID_CERTIFICATE = "Certificate {0} is not yet valid.";
    static final String SCOPE_SPECIFIED_WITH_INVALID_TYPES = "Certificate {0} is trusted for {1}, which is incorrect scope for pdf validation.";
    static final String EXTENSIONS_CHECK = "Certificate extensions check.";
    private static final Map<String, Set<CertificateSource>> serviceTypeIdentifiersScope;
    private final Set<CountryServiceContext> contexts = new HashSet<CountryServiceContext>();
    private final QualifiedValidator qualifiedValidator;
    private final ValidationReport report;
    private List<X509Certificate> previousCertificates = new ArrayList<X509Certificate>();

    public LotlTrustedStore(ValidatorChainBuilder builder) {
        if (builder.isEuropeanLotlTrusted()) {
            LotlService lotlService = builder.getLotlService();
            if (lotlService == null || !lotlService.isCacheInitialized()) {
                throw new SafeCallingAvoidantException("Lotl cache has not been initialized. Please call LotlService#initializeGlobalCache if European LOTLs are trusted.\nIf you are using a custom LotlService, please make sure to call LotlService#initializeCache on your custom implementation.");
            }
            LotlValidator lotlValidator = builder.getLotlService().getLotlValidator();
            this.report = lotlValidator.validate();
            if (this.report.getValidationResult() == ValidationReport.ValidationResult.VALID) {
                this.addCertificatesWithContext(LotlTrustedStore.mapIServiceContextToCountry(lotlValidator.getNationalTrustedCertificates()));
            }
        } else {
            this.report = new ValidationReport();
        }
        this.qualifiedValidator = builder.getQualifiedValidator();
    }

    public Set<Certificate> getCertificates() {
        HashSet<Certificate> allCertificates = new HashSet<Certificate>();
        for (CountryServiceContext context : this.contexts) {
            allCertificates.addAll(context.getCertificates());
        }
        return allCertificates;
    }

    public LotlTrustedStore setPreviousCertificates(List<X509Certificate> previousCertificates) {
        this.previousCertificates = Collections.unmodifiableList(previousCertificates);
        return this;
    }

    public boolean checkIfCertIsTrusted(ValidationReport result, ValidationContext context, X509Certificate certificate, Date validationDate) {
        Set<CountryServiceContext> currentContextSet = this.getCertificateContext(certificate);
        this.checkQualification(context, certificate, validationDate, currentContextSet);
        return this.checkTrustworthiness(result, context, certificate, validationDate, currentContextSet);
    }

    private void checkQualification(ValidationContext context, X509Certificate certificate, Date validationDate, Set<CountryServiceContext> currentContextSet) {
        for (CountryServiceContext currentContext : currentContextSet) {
            this.qualifiedValidator.checkSignatureQualification(this.previousCertificates, currentContext, certificate, validationDate, context);
        }
    }

    private boolean checkTrustworthiness(ValidationReport result, ValidationContext context, X509Certificate certificate, Date validationDate, Set<CountryServiceContext> currentContextSet) {
        ArrayList<ReportItem> validationReportItems = new ArrayList<ReportItem>();
        for (CountryServiceContext currentContext : currentContextSet) {
            ServiceChronologicalInfo chronologicalInfo = this.getCertificateChronologicalInfoByTime(validationReportItems, certificate, currentContext, validationDate);
            if (chronologicalInfo == null || !this.isScopeCorrectlySpecified(validationReportItems, certificate, chronologicalInfo.getServiceExtensions())) continue;
            Set<CertificateSource> currentScope = this.getCertificateSourceBasedOnServiceType(currentContext.getServiceType());
            if (currentScope == null) {
                validationReportItems.add(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_SERVICE_TYPE_NOT_RECOGNIZED, (Object[])new Object[]{certificate.getSubjectX500Principal(), currentContext.getServiceType()}), ReportItem.ReportItemStatus.INFO));
                continue;
            }
            for (CertificateSource source : currentScope) {
                if (ValidationContext.checkIfContextChainContainsCertificateSource(context, source)) {
                    result.addReportItem(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INFO));
                    return true;
                }
                validationReportItems.add(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)CERTIFICATE_TRUSTED_FOR_DIFFERENT_CONTEXT, (Object[])new Object[]{certificate.getSubjectX500Principal(), currentContext.getServiceType()}), ReportItem.ReportItemStatus.INFO));
            }
        }
        for (ReportItem reportItem : validationReportItems) {
            result.addReportItem(reportItem);
        }
        return false;
    }

    public ValidationReport getLotlValidationReport() {
        return new ValidationReport(this.report);
    }

    protected Set<CertificateSource> getCertificateSourceBasedOnServiceType(String serviceType) {
        return serviceTypeIdentifiersScope.get(serviceType);
    }

    protected boolean isScopeCorrectlySpecified(List<ReportItem> reportItems, X509Certificate certificate, List<AdditionalServiceInformationExtension> extensions) {
        ArrayList<CertificateReportItem> currentReportItems = new ArrayList<CertificateReportItem>();
        for (AdditionalServiceInformationExtension extension : extensions) {
            if (extension.isScopeValid()) {
                return true;
            }
            currentReportItems.add(new CertificateReportItem(certificate, EXTENSIONS_CHECK, MessageFormatUtil.format((String)SCOPE_SPECIFIED_WITH_INVALID_TYPES, (Object[])new Object[]{certificate.getSubjectX500Principal(), extension.getUri()}), ReportItem.ReportItemStatus.INVALID));
        }
        if (currentReportItems.isEmpty()) {
            return true;
        }
        reportItems.addAll(currentReportItems);
        return false;
    }

    static List<CountryServiceContext> mapIServiceContextToCountry(List<IServiceContext> serviceContexts) {
        ArrayList<CountryServiceContext> list = new ArrayList<CountryServiceContext>();
        for (IServiceContext serviceContext : serviceContexts) {
            CountryServiceContext countryServiceContext = serviceContext instanceof CountryServiceContext ? (CountryServiceContext)serviceContext : null;
            if (countryServiceContext == null) continue;
            list.add(countryServiceContext);
        }
        return list;
    }

    final void addCertificatesWithContext(Collection<CountryServiceContext> contexts) {
        this.contexts.addAll(contexts);
    }

    ServiceChronologicalInfo getCertificateChronologicalInfoByTime(List<ReportItem> reportItems, X509Certificate certificate, CountryServiceContext currentContext, Date validationDate) {
        ServiceChronologicalInfo status = currentContext.getServiceChronologicalInfoByDate(DateTimeUtil.getRelativeTime((Date)validationDate));
        if (status == null) {
            reportItems.add(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)NOT_YET_VALID_CERTIFICATE, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INVALID));
            return null;
        }
        if (!ServiceChronologicalInfo.isStatusValid(status.getServiceStatus())) {
            reportItems.add(new CertificateReportItem(certificate, CERTIFICATE_CHECK, MessageFormatUtil.format((String)REVOKED_CERTIFICATE, (Object[])new Object[]{certificate.getSubjectX500Principal()}), ReportItem.ReportItemStatus.INVALID));
            return null;
        }
        return status;
    }

    private Set<CountryServiceContext> getCertificateContext(Certificate certificate) {
        HashSet<CountryServiceContext> contextSet = new HashSet<CountryServiceContext>();
        for (CountryServiceContext context : this.contexts) {
            if (!context.getCertificates().contains(certificate)) continue;
            contextSet.add(context);
        }
        return contextSet;
    }

    static {
        HashSet<CertificateSource> crlOcspSignScope = new HashSet<CertificateSource>();
        crlOcspSignScope.add(CertificateSource.CRL_ISSUER);
        crlOcspSignScope.add(CertificateSource.OCSP_ISSUER);
        crlOcspSignScope.add(CertificateSource.SIGNER_CERT);
        HashSet<CertificateSource> ocspScope = new HashSet<CertificateSource>(Collections.singletonList(CertificateSource.OCSP_ISSUER));
        HashSet<CertificateSource> crlScope = new HashSet<CertificateSource>(Collections.singletonList(CertificateSource.CRL_ISSUER));
        HashSet<CertificateSource> timestampScope = new HashSet<CertificateSource>(Collections.singletonList(CertificateSource.TIMESTAMP));
        HashSet<CertificateSource> signScope = new HashSet<CertificateSource>(Collections.singletonList(CertificateSource.SIGNER_CERT));
        HashMap<String, HashSet<CertificateSource>> tempServiceTypeIdentifiersScope = new HashMap<String, HashSet<CertificateSource>>(ServiceTypeIdentifiersConstants.getAllValues().size());
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/CA/QC", crlOcspSignScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/CA/PKC", crlOcspSignScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/Certstatus/OCSP/QC", ocspScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/Certstatus/CRL/QC", crlScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/TSA/QTST", timestampScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/EDS/Q", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/EDS/REM/Q", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/PSES/Q", timestampScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/QESValidation/Q", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/RemoteQSigCDManagement/Q", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/RemoteQSealCDManagement/Q", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/EAA/Q", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/ElectronicArchiving/Q", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/Ledgers/Q", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/Certstatus/OCSP", crlScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/Certstatus/CRL", crlScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/TS/", timestampScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-QC", timestampScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/TSA/TSS-AdESQCandQES", timestampScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/PSES", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/AdESValidation", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/AdESGeneration", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/RemoteSigCDManagemen", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/RemoteSealCDManagement", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/EAA", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/ElectronicArchiving", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/Ledgers", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/PKCValidation", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/PKCPreservation", timestampScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/EAAValidation", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/TSTValidation", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/EDSValidation", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/EAA/Pub-EAA", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/PKCValidation/CertsforOtherTypesOfTS", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/RA", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/RA/nothavingPKIid", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/SignaturePolicyAuthority", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/Archiv", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/Archiv/nothavingPKIid", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/IdV", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/KEscrow", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/KEscrow/nothavingPKIid", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/PPwd", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/PPwd/nothavinPKIid", signScope);
        tempServiceTypeIdentifiersScope.put("http://uri.etsi.org/TrstSvc/Svctype/TLIssuer", signScope);
        serviceTypeIdentifiersScope = Collections.unmodifiableMap(tempServiceTypeIdentifiersScope);
    }
}

