/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.util.UrlUtil;
import com.itextpdf.signatures.validation.EuropeanTrustedListConfigurationFactory;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.lotl.LotlService;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.net.URL;
import java.util.Arrays;

public class EuropeanLotlFetcher {
    private final LotlService service;

    public EuropeanLotlFetcher(LotlService service) {
        this.service = service;
    }

    public Result fetch() {
        Result result = new Result();
        EuropeanTrustedListConfigurationFactory factory = EuropeanTrustedListConfigurationFactory.getFactory().get();
        SafeCalling.onExceptionLog(() -> {
            URL url = UrlUtil.toURL((String)factory.getTrustedListUri());
            result.setLotlXml(this.service.getResourceRetriever().getByteArrayByUrl(url));
            if (result.getLotlXml() == null || result.getLotlXml().length == 0) {
                ReportItem reportItem = new ReportItem("Lotl validation.", MessageFormatUtil.format((String)"Failed to get European List of Trusted Lists (Lotl) from {0}.", (Object[])new Object[]{factory.getTrustedListUri()}), ReportItem.ReportItemStatus.INVALID);
                result.getLocalReport().addReportItem(reportItem);
            }
        }, result.getLocalReport(), e -> new ReportItem("Lotl validation.", MessageFormatUtil.format((String)"Failed to get European List of Trusted Lists (Lotl) from {0}.", (Object[])new Object[]{factory.getTrustedListUri()}), (Exception)e, ReportItem.ReportItemStatus.INVALID));
        return result;
    }

    public static class Result {
        private final ValidationReport localReport = new ValidationReport();
        private byte[] lotlXml;

        public Result(byte[] lotlXml) {
            this.setLotlXml(lotlXml);
        }

        public Result() {
        }

        public byte[] getLotlXml() {
            if (this.lotlXml == null) {
                return null;
            }
            return Arrays.copyOf(this.lotlXml, this.lotlXml.length);
        }

        final void setLotlXml(byte[] lotlXml) {
            if (lotlXml != null) {
                this.lotlXml = Arrays.copyOf(lotlXml, lotlXml.length);
            }
        }

        public ValidationReport getLocalReport() {
            return this.localReport;
        }

        boolean hasValidXml() {
            return this.lotlXml != null && this.lotlXml.length > 0;
        }
    }
}

