/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.events;

import com.itextpdf.signatures.validation.events.EventType;
import com.itextpdf.signatures.validation.events.IValidationEvent;
import java.util.HashMap;
import java.util.Map;

public class AlgorithmUsageEvent
implements IValidationEvent {
    private static final Map<String, String> allowedDigests = new HashMap<String, String>();
    private static final Map<String, String> allowedSignatureAlgorithms = new HashMap<String, String>();
    private final String name;
    private final String oid;
    private final String usageLocation;

    public AlgorithmUsageEvent(String name, String oid, String usageLocation) {
        this.name = name;
        this.oid = oid;
        this.usageLocation = usageLocation;
    }

    @Override
    public EventType getEventType() {
        return EventType.ALGORITHM_USAGE;
    }

    public boolean isAllowedAccordingToEtsiTs119_312() {
        if (this.oid != null) {
            return allowedDigests.containsValue(this.oid) || allowedSignatureAlgorithms.containsValue(this.oid);
        }
        return allowedDigests.containsKey(this.name) || allowedSignatureAlgorithms.containsKey(this.name);
    }

    public boolean isAllowedAccordingToAdES() {
        if (this.oid != null) {
            return !"1.2.840.113549.2.5".equals(this.oid);
        }
        return !"MD5".equals(this.name.toUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public String getUsageLocation() {
        return this.usageLocation;
    }

    public String getOid() {
        return this.oid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Algorithm Usage:\n\tname: ");
        sb.append(this.name).append("\n\t oid:").append(this.oid).append("\n\tusage: ").append(this.usageLocation);
        return sb.toString();
    }

    static {
        allowedDigests.put("SHA224", "2.16.840.1.101.3.4.2.4");
        allowedDigests.put("SHA-224", "2.16.840.1.101.3.4.2.4");
        allowedDigests.put("SHA256", "2.16.840.1.101.3.4.2.1");
        allowedDigests.put("SHA-256", "2.16.840.1.101.3.4.2.1");
        allowedDigests.put("SHA384", "2.16.840.1.101.3.4.2.2");
        allowedDigests.put("SHA-384", "2.16.840.1.101.3.4.2.2");
        allowedDigests.put("SHA-512", "2.16.840.1.101.3.4.2.3");
        allowedDigests.put("SHA512", "2.16.840.1.101.3.4.2.3");
        allowedDigests.put("SHA-512/256", "2.16.840.1.101.3.4.2.6");
        allowedDigests.put("SHA512/256", "2.16.840.1.101.3.4.2.6");
        allowedDigests.put("SHA3-256", "2.16.840.1.101.3.4.2.8");
        allowedDigests.put("SHA3-384", "2.16.840.1.101.3.4.2.9");
        allowedDigests.put("SHA3-512", "2.16.840.1.101.3.4.2.10");
        allowedSignatureAlgorithms.put("FRP256v1", "1.2.250.1.223.101.256.1");
        allowedSignatureAlgorithms.put("brainpoolP256r1", "1.3.36.3.3.2.8.1.1.7");
        allowedSignatureAlgorithms.put("brainpoolP384r1", "1.3.36.3.3.2.8.1.1.11");
        allowedSignatureAlgorithms.put("brainpoolP512r1", "1.3.36.3.3.2.8.1.1.13");
        allowedSignatureAlgorithms.put("P-256", "1.2.840.10045.3.1.7");
        allowedSignatureAlgorithms.put("secp256r1", "1.2.840.10045.3.1.7");
        allowedSignatureAlgorithms.put("P-384", "1.3.132.0.34");
        allowedSignatureAlgorithms.put("secp384r1", "1.3.132.0.34");
        allowedSignatureAlgorithms.put("P-521", "1.3.132.0.35");
        allowedSignatureAlgorithms.put("secp521r1", "1.3.132.0.35");
        allowedSignatureAlgorithms.put("RSAES-PKCS1-v1_5", "1.2.840.113549.1.1.1");
        allowedSignatureAlgorithms.put("rsaEncryption", "1.2.840.113549.1.1.1");
        allowedSignatureAlgorithms.put("DSA", "1.2.840.10040.4.1");
        allowedSignatureAlgorithms.put("id-dsa", "1.2.840.10040.4.1");
        allowedSignatureAlgorithms.put("ECDSA", "1.2.840.10045.2.1");
        allowedSignatureAlgorithms.put("sha224WithRsaEncryption", "1.2.840.113549.1.1.14");
        allowedSignatureAlgorithms.put("sha256WithRsaEncryption", "1.2.840.113549.1.1.11");
        allowedSignatureAlgorithms.put("sha384WithRsaEncryption", "1.2.840.113549.1.1.13");
        allowedSignatureAlgorithms.put("sha512WithRsaEncryption", "1.2.840.113549.1.1.12");
        allowedSignatureAlgorithms.put("id-RSASSA-PSS", "1.2.840.113549.1.1.10");
        allowedSignatureAlgorithms.put("id-dsa-with-sha224", "2.16.840.1.101.3.4.3.1");
        allowedSignatureAlgorithms.put("id-dsa-with-sha256", "2.16.840.1.101.3.4.3.2");
        allowedSignatureAlgorithms.put("ecdsa-with-SHA224", "1.2.840.10045.4.3.1");
        allowedSignatureAlgorithms.put("ecdsa-with-SHA256", "1.2.840.10045.4.3.2");
        allowedSignatureAlgorithms.put("ecdsa-with-SHA384", "1.2.840.10045.4.3.3");
        allowedSignatureAlgorithms.put("ecdsa-with-SHA512", "1.2.840.10045.4.3.4");
        allowedSignatureAlgorithms.put("id-ecdsa-with-sha3-224", "2.16.840.1.101.3.4.3.9");
        allowedSignatureAlgorithms.put("id-ecdsa-with-sha3-256", "2.16.840.1.101.3.4.3.10");
        allowedSignatureAlgorithms.put("id-ecdsa-with-sha3-384", "2.16.840.1.101.3.4.3.11");
        allowedSignatureAlgorithms.put("id-ecdsa-with-sha3-512", "2.16.840.1.101.3.4.3.12");
        allowedSignatureAlgorithms.put("id-dswa-dl-EC-SDSA-opt", "1.0.14888.3.0.13");
    }
}

