/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEventHandler;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.signatures.CrlClientOnline;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IOcspClientBouncyCastle;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.validation.CRLValidator;
import com.itextpdf.signatures.validation.CertificateChainValidator;
import com.itextpdf.signatures.validation.DocumentRevisionsValidator;
import com.itextpdf.signatures.validation.NullQualifiedValidator;
import com.itextpdf.signatures.validation.OCSPValidator;
import com.itextpdf.signatures.validation.RevocationDataValidator;
import com.itextpdf.signatures.validation.SignatureValidationProperties;
import com.itextpdf.signatures.validation.SignatureValidator;
import com.itextpdf.signatures.validation.dataorigin.CertificateOrigin;
import com.itextpdf.signatures.validation.lotl.LotlService;
import com.itextpdf.signatures.validation.lotl.LotlTrustedStore;
import com.itextpdf.signatures.validation.lotl.QualifiedValidator;
import com.itextpdf.signatures.validation.report.pades.PAdESLevelReportGenerator;
import com.itextpdf.signatures.validation.report.xml.AdESReportAggregator;
import com.itextpdf.signatures.validation.report.xml.EventsToAdESReportAggratorConvertor;
import com.itextpdf.signatures.validation.report.xml.NullAdESReportAggregator;
import com.itextpdf.signatures.validation.report.xml.XmlReportAggregator;
import com.itextpdf.styledxmlparser.resolver.resource.DefaultResourceRetriever;
import com.itextpdf.styledxmlparser.resolver.resource.IResourceRetriever;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class ValidatorChainBuilder {
    private SignatureValidationProperties properties = new SignatureValidationProperties();
    private Supplier<IssuingCertificateRetriever> certificateRetrieverFactory;
    private Supplier<CertificateChainValidator> certificateChainValidatorFactory;
    private Supplier<RevocationDataValidator> revocationDataValidatorFactory;
    private Supplier<OCSPValidator> ocspValidatorFactory;
    private Supplier<CRLValidator> crlValidatorFactory;
    private Supplier<IResourceRetriever> resourceRetrieverFactory;
    private Supplier<DocumentRevisionsValidator> documentRevisionsValidatorFactory;
    private Supplier<IOcspClientBouncyCastle> ocspClientFactory;
    private Supplier<ICrlClient> crlClientFactory;
    private Supplier<LotlTrustedStore> lotlTrustedStoreFactory;
    private Supplier<LotlService> lotlServiceFactory;
    private QualifiedValidator qualifiedValidator;
    private Set<X509Certificate> certificatesChainBeingValidated = new HashSet<X509Certificate>();
    private Collection<Certificate> trustedCertificates;
    private Collection<Certificate> knownCertificates;
    private boolean trustEuropeanLotl = false;
    private final EventManager eventManager;
    private AdESReportAggregator adESReportAggregator = new NullAdESReportAggregator();
    private boolean padesValidationRequested = false;

    public ValidatorChainBuilder() {
        this.lotlTrustedStoreFactory = () -> this.buildLotlTrustedStore();
        this.certificateRetrieverFactory = () -> this.buildIssuingCertificateRetriever();
        this.certificateChainValidatorFactory = () -> this.buildCertificateChainValidator();
        this.revocationDataValidatorFactory = () -> this.buildRevocationDataValidator();
        this.ocspValidatorFactory = () -> this.buildOCSPValidator();
        this.crlValidatorFactory = () -> this.buildCRLValidator();
        this.resourceRetrieverFactory = () -> new DefaultResourceRetriever();
        this.documentRevisionsValidatorFactory = () -> this.buildDocumentRevisionsValidator();
        this.ocspClientFactory = () -> new OcspClientBouncyCastle();
        this.crlClientFactory = () -> new CrlClientOnline();
        this.lotlServiceFactory = () -> ValidatorChainBuilder.buildLotlService();
        this.qualifiedValidator = new NullQualifiedValidator();
        this.eventManager = EventManager.createNewInstance();
    }

    public ValidatorChainBuilder trustEuropeanLotl(boolean trustEuropeanLotl) {
        this.trustEuropeanLotl = trustEuropeanLotl;
        return this;
    }

    public boolean isEuropeanLotlTrusted() {
        return this.trustEuropeanLotl;
    }

    public SignatureValidator buildSignatureValidator(PdfDocument document) {
        return new SignatureValidator(document, this);
    }

    public DocumentRevisionsValidator buildDocumentRevisionsValidator() {
        return new DocumentRevisionsValidator(this);
    }

    public CertificateChainValidator buildCertificateChainValidator() {
        return new CertificateChainValidator(this);
    }

    public RevocationDataValidator buildRevocationDataValidator() {
        return new RevocationDataValidator(this);
    }

    public OCSPValidator buildOCSPValidator() {
        return new OCSPValidator(this);
    }

    public CRLValidator buildCRLValidator() {
        return new CRLValidator(this);
    }

    public ValidatorChainBuilder withDocumentRevisionsValidatorFactory(Supplier<DocumentRevisionsValidator> documentRevisionsValidatorFactory) {
        this.documentRevisionsValidatorFactory = documentRevisionsValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withCRLValidatorFactory(Supplier<CRLValidator> crlValidatorFactory) {
        this.crlValidatorFactory = crlValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withResourceRetriever(Supplier<IResourceRetriever> resourceRetrieverFactory) {
        this.resourceRetrieverFactory = resourceRetrieverFactory;
        return this;
    }

    public ValidatorChainBuilder withOCSPValidatorFactory(Supplier<OCSPValidator> ocspValidatorFactory) {
        this.ocspValidatorFactory = ocspValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withRevocationDataValidatorFactory(Supplier<RevocationDataValidator> revocationDataValidatorFactory) {
        this.revocationDataValidatorFactory = revocationDataValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withCertificateChainValidatorFactory(Supplier<CertificateChainValidator> certificateChainValidatorFactory) {
        this.certificateChainValidatorFactory = certificateChainValidatorFactory;
        return this;
    }

    public ValidatorChainBuilder withSignatureValidationProperties(SignatureValidationProperties properties) {
        this.properties = properties;
        return this;
    }

    public ValidatorChainBuilder withIssuingCertificateRetrieverFactory(Supplier<IssuingCertificateRetriever> certificateRetrieverFactory) {
        this.certificateRetrieverFactory = certificateRetrieverFactory;
        return this;
    }

    public ValidatorChainBuilder withOcspClient(Supplier<IOcspClientBouncyCastle> ocspClientFactory) {
        this.ocspClientFactory = ocspClientFactory;
        return this;
    }

    public ValidatorChainBuilder withCrlClient(Supplier<ICrlClient> crlClientFactory) {
        this.crlClientFactory = crlClientFactory;
        return this;
    }

    public ValidatorChainBuilder withKnownCertificates(Collection<Certificate> knownCertificates) {
        this.knownCertificates = new ArrayList<Certificate>(knownCertificates);
        return this;
    }

    public ValidatorChainBuilder withTrustedCertificates(Collection<Certificate> trustedCertificates) {
        this.trustedCertificates = new ArrayList<Certificate>(trustedCertificates);
        return this;
    }

    @Deprecated
    public ValidatorChainBuilder withAdESReportAggregator(AdESReportAggregator adESReportAggregator) {
        this.adESReportAggregator = adESReportAggregator;
        this.eventManager.register((IEventHandler)new EventsToAdESReportAggratorConvertor(adESReportAggregator));
        return this;
    }

    public ValidatorChainBuilder withAdESLevelReportGenerator(XmlReportAggregator reportEventListener) {
        this.eventManager.register((IEventHandler)reportEventListener);
        return this;
    }

    public ValidatorChainBuilder withPAdESLevelReportGenerator(PAdESLevelReportGenerator reportGenerator) {
        this.padesValidationRequested = true;
        this.eventManager.register((IEventHandler)reportGenerator);
        return this;
    }

    public boolean padesValidationRequested() {
        return this.padesValidationRequested;
    }

    public ValidatorChainBuilder withQualifiedValidator(QualifiedValidator qualifiedValidator) {
        this.qualifiedValidator = qualifiedValidator;
        return this;
    }

    public IssuingCertificateRetriever getCertificateRetriever() {
        return this.certificateRetrieverFactory.get();
    }

    public SignatureValidationProperties getProperties() {
        return this.properties;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Deprecated
    public AdESReportAggregator getAdESReportAggregator() {
        return this.adESReportAggregator;
    }

    public IResourceRetriever getResourceRetriever() {
        return this.resourceRetrieverFactory.get();
    }

    public QualifiedValidator getQualifiedValidator() {
        return this.qualifiedValidator;
    }

    DocumentRevisionsValidator getDocumentRevisionsValidator() {
        return this.documentRevisionsValidatorFactory.get();
    }

    CertificateChainValidator getCertificateChainValidator() {
        return this.certificateChainValidatorFactory.get();
    }

    RevocationDataValidator getRevocationDataValidator() {
        return this.revocationDataValidatorFactory.get();
    }

    ICrlClient getCrlClient() {
        return this.crlClientFactory.get();
    }

    IOcspClientBouncyCastle getOcspClient() {
        return this.ocspClientFactory.get();
    }

    CRLValidator getCRLValidator() {
        return this.crlValidatorFactory.get();
    }

    OCSPValidator getOCSPValidator() {
        return this.ocspValidatorFactory.get();
    }

    public ValidatorChainBuilder withLotlTrustedStoreFactory(Supplier<LotlTrustedStore> lotlTrustedStoreFactory) {
        this.lotlTrustedStoreFactory = lotlTrustedStoreFactory;
        return this;
    }

    public LotlTrustedStore getLotlTrustedStore() {
        return this.lotlTrustedStoreFactory.get();
    }

    public ValidatorChainBuilder withLotlService(Supplier<LotlService> lotlServiceFactory) {
        this.lotlServiceFactory = lotlServiceFactory;
        return this;
    }

    public LotlService getLotlService() {
        return this.lotlServiceFactory.get();
    }

    void addCertificateBeingValidated(X509Certificate certificate) {
        this.certificatesChainBeingValidated.add(certificate);
    }

    void removeCertificateBeingValidated(X509Certificate certificate) {
        this.certificatesChainBeingValidated.remove(certificate);
    }

    boolean isCertificateBeingValidated(X509Certificate certificate) {
        return this.certificatesChainBeingValidated.contains(certificate);
    }

    private static LotlService buildLotlService() {
        return LotlService.getGlobalService();
    }

    private IssuingCertificateRetriever buildIssuingCertificateRetriever() {
        IssuingCertificateRetriever result = new IssuingCertificateRetriever(this.resourceRetrieverFactory.get());
        if (this.trustedCertificates != null) {
            result.setTrustedCertificates(this.trustedCertificates);
        }
        if (this.knownCertificates != null) {
            result.addKnownCertificates(this.knownCertificates, CertificateOrigin.OTHER);
        }
        result.addKnownCertificates(this.lotlTrustedStoreFactory.get().getCertificates(), CertificateOrigin.OTHER);
        return result;
    }

    private LotlTrustedStore buildLotlTrustedStore() {
        return new LotlTrustedStore(this);
    }
}

