/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.validation.RevocationDataValidator;
import com.itextpdf.signatures.validation.context.TimeBasedContext;
import com.itextpdf.signatures.validation.dataorigin.RevocationDataOrigin;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ValidationOcspClient
implements IOcspClient {
    private final Map<IBasicOCSPResp, RevocationDataValidator.OcspResponseValidationInfo> responses = new HashMap<IBasicOCSPResp, RevocationDataValidator.OcspResponseValidationInfo>();

    @Deprecated
    public void addResponse(IBasicOCSPResp response, Date date, TimeBasedContext context) {
        this.addResponse(response, date, context, RevocationDataOrigin.OTHER);
    }

    public void addResponse(IBasicOCSPResp response, Date date, TimeBasedContext context, RevocationDataOrigin responseOrigin) {
        RevocationDataValidator.OcspResponseValidationInfo validationInfo = this.responses.get(response);
        if (validationInfo == null) {
            this.responses.put(response, new RevocationDataValidator.OcspResponseValidationInfo(null, response, date, context, responseOrigin));
        } else {
            if (validationInfo.trustedGenerationDate.after(date)) {
                validationInfo.trustedGenerationDate = date;
                validationInfo.timeBasedContext = context;
            }
            if (validationInfo.responseOrigin.ordinal() > responseOrigin.ordinal()) {
                validationInfo.responseOrigin = responseOrigin;
            }
        }
    }

    public Map<IBasicOCSPResp, RevocationDataValidator.OcspResponseValidationInfo> getResponses() {
        return Collections.unmodifiableMap(this.responses);
    }

    @Override
    public byte[] getEncoded(X509Certificate checkCert, X509Certificate issuerCert, String url) {
        if (this.responses.isEmpty()) {
            return null;
        }
        try {
            return ((IBasicOCSPResp)((Map.Entry)this.responses.entrySet().stream().sorted((r1, r2) -> ((IBasicOCSPResp)r2.getKey()).getProducedAt().compareTo(((IBasicOCSPResp)r1.getKey()).getProducedAt())).collect(Collectors.toList()).get(0)).getKey()).getEncoded();
        }
        catch (IOException | RuntimeException e) {
            return null;
        }
    }
}

