/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.x509.IDistributionPoint;
import com.itextpdf.commons.bouncycastle.asn1.x509.IIssuingDistributionPoint;
import com.itextpdf.commons.bouncycastle.asn1.x509.IReasonFlags;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.TimestampConstants;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.SignatureValidationProperties;
import com.itextpdf.signatures.validation.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.context.CertificateSource;
import com.itextpdf.signatures.validation.context.ValidationContext;
import com.itextpdf.signatures.validation.context.ValidatorContext;
import com.itextpdf.signatures.validation.events.AlgorithmUsageEvent;
import com.itextpdf.signatures.validation.extensions.DynamicBasicConstraintsExtension;
import com.itextpdf.signatures.validation.report.CertificateReportItem;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.IOException;
import java.security.cert.CRLReason;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CRLValidator {
    static final String CRL_CHECK = "CRL response check.";
    static final String ATTRIBUTE_CERTS_ASSERTED = "The onlyContainsAttributeCerts is asserted. Conforming CRLs issuers MUST set the onlyContainsAttributeCerts boolean to FALSE.";
    static final String CERTIFICATE_IS_EXPIRED = "Certificate is expired on {0} and could have been removed from the CRL.";
    static final String CERTIFICATE_IS_UNREVOKED = "The certificate was unrevoked.";
    static final String CERTIFICATE_IS_NOT_IN_THE_CRL_SCOPE = "Certificate isn't in the current CRL scope.";
    static final String CERTIFICATE_REVOKED = "Certificate was revoked by {0} on {1}.";
    static final String CRL_ISSUER_NOT_FOUND = "Unable to validate CRL response: no issuer certificate found.";
    static final String CRL_ISSUER_REQUEST_FAILED = "Unable to validate CRL response: Unexpected exception occurred retrieving issuer certificate.";
    static final String CRL_ISSUER_CHAIN_FAILED = "Unable to validate CRL response: Unexpected exception occurred validating issuer certificate.";
    static final String CRL_ISSUER_NO_COMMON_ROOT = "The CRL issuer does not share the root of the inspected certificate.";
    static final String CRL_INVALID = "CRL response is invalid.";
    static final String FRESHNESS_CHECK = "CRL response is not fresh enough: this update: {0}, validation date: {1}, freshness: {2}.";
    static final String ONLY_SOME_REASONS_CHECKED = "Revocation status cannot be determined since not all reason codes are covered by the current CRL.";
    static final String UPDATE_DATE_BEFORE_CHECK_DATE = "nextUpdate: {0} of CRLResponse is before validation date {1}.";
    static final String CERTIFICATE_IN_ISSUER_CHAIN = "Unable to validate CRL response: validated certificate is part of issuer certificate chain.";
    static final int ALL_REASONS = 32895;
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final Map<Certificate, Integer> checkedReasonsMask = new HashMap<Certificate, Integer>();
    private final IssuingCertificateRetriever certificateRetriever;
    private final SignatureValidationProperties properties;
    private final ValidatorChainBuilder builder;
    private final EventManager eventManager;

    protected CRLValidator(ValidatorChainBuilder builder) {
        this.certificateRetriever = builder.getCertificateRetriever();
        this.properties = builder.getProperties();
        this.eventManager = builder.getEventManager();
        this.builder = builder;
    }

    public void validate(ValidationReport report, ValidationContext context, X509Certificate certificate, X509CRL crl, Date validationDate, Date responseGenerationDate) {
        Date startExpirationDate;
        this.reportAlgortihmUsage(crl);
        ValidationContext localContext = context.setValidatorContext(ValidatorContext.CRL_VALIDATOR);
        if (CertificateUtil.isSelfSigned(certificate)) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, "Certificate is self-signed. Revocation data check will be skipped.", ReportItem.ReportItemStatus.INFO));
            return;
        }
        Duration freshness = this.properties.getFreshness(localContext);
        if (DateTimeUtil.addMillisToDate((Date)crl.getThisUpdate(), (long)freshness.toMillis()).before(validationDate)) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)FRESHNESS_CHECK, (Object[])new Object[]{crl.getThisUpdate(), validationDate, freshness}), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        if (crl.getNextUpdate() != TimestampConstants.UNDEFINED_TIMESTAMP_DATE && validationDate.after(crl.getNextUpdate())) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)UPDATE_DATE_BEFORE_CHECK_DATE, (Object[])new Object[]{crl.getNextUpdate(), validationDate}), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        if (certificate.getNotAfter().before(crl.getThisUpdate()) && (TimestampConstants.UNDEFINED_TIMESTAMP_DATE == (startExpirationDate = CRLValidator.getExpiredCertsOnCRLExtensionDate(crl)) || certificate.getNotAfter().before(startExpirationDate))) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)CERTIFICATE_IS_EXPIRED, (Object[])new Object[]{certificate.getNotAfter()}), ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        IIssuingDistributionPoint issuingDistPoint = CRLValidator.getIssuingDistributionPointExtension(crl);
        IDistributionPoint distributionPoint = null;
        if (!issuingDistPoint.isNull()) {
            boolean basicConstraintsCaAsserted = new DynamicBasicConstraintsExtension().withCertificateChainSize(1).existsInCertificate(certificate);
            if (issuingDistPoint.onlyContainsUserCerts() && basicConstraintsCaAsserted || issuingDistPoint.onlyContainsCACerts() && !basicConstraintsCaAsserted) {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, CERTIFICATE_IS_NOT_IN_THE_CRL_SCOPE, ReportItem.ReportItemStatus.INDETERMINATE));
                return;
            }
            if (issuingDistPoint.onlyContainsAttributeCerts()) {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, ATTRIBUTE_CERTS_ASSERTED, ReportItem.ReportItemStatus.INDETERMINATE));
                return;
            }
            if (!issuingDistPoint.getDistributionPoint().isNull()) {
                distributionPoint = CertificateUtil.getDistributionPointByName(certificate, issuingDistPoint.getDistributionPoint());
            }
        }
        int interimReasonsMask = CRLValidator.computeInterimReasonsMask(issuingDistPoint, distributionPoint);
        Integer reasonsMask = this.checkedReasonsMask.get(certificate);
        if (reasonsMask != null) {
            interimReasonsMask |= reasonsMask.intValue();
        }
        this.verifyCrlIntegrity(report, localContext, certificate, crl, responseGenerationDate);
        CRLValidator.verifyRevocation(report, certificate, validationDate, crl);
        if (report.getValidationResult() == ValidationReport.ValidationResult.VALID) {
            this.checkedReasonsMask.put(certificate, interimReasonsMask);
        }
        if (interimReasonsMask != 32895) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, ONLY_SOME_REASONS_CHECKED, ReportItem.ReportItemStatus.INDETERMINATE));
        }
    }

    private void reportAlgortihmUsage(X509CRL crl) {
        this.eventManager.onEvent((IEvent)new AlgorithmUsageEvent(crl.getSigAlgName(), crl.getSigAlgOID(), CRL_CHECK));
    }

    private static void verifyRevocation(ValidationReport report, X509Certificate certificate, Date verificationDate, X509CRL crl) {
        X509CRLEntry revocation = crl.getRevokedCertificate(certificate.getSerialNumber());
        if (revocation != null) {
            Date revocationDate = revocation.getRevocationDate();
            if (verificationDate.before(revocationDate)) {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)"The certificate was valid on the verification date, but has been revoked since {0}.", (Object[])new Object[]{revocationDate}), ReportItem.ReportItemStatus.INFO));
            } else if (CRLReason.REMOVE_FROM_CRL == revocation.getRevocationReason()) {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)CERTIFICATE_IS_UNREVOKED, (Object[])new Object[]{revocationDate}), ReportItem.ReportItemStatus.INFO));
            } else {
                report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, MessageFormatUtil.format((String)CERTIFICATE_REVOKED, (Object[])new Object[]{crl.getIssuerX500Principal(), revocation.getRevocationDate()}), ReportItem.ReportItemStatus.INVALID));
            }
        }
    }

    private static IIssuingDistributionPoint getIssuingDistributionPointExtension(X509CRL crl) {
        IASN1Primitive issuingDistPointExtension = null;
        try {
            issuingDistPointExtension = CertificateUtil.getExtensionValue(crl, FACTORY.createExtension().getIssuingDistributionPoint().getId());
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
        return FACTORY.createIssuingDistributionPoint(issuingDistPointExtension);
    }

    private static Date getExpiredCertsOnCRLExtensionDate(X509CRL crl) {
        IASN1Primitive expiredCertsOnCRL = null;
        try {
            expiredCertsOnCRL = CertificateUtil.getExtensionValue(crl, FACTORY.createExtension().getExpiredCertsOnCRL().getId());
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
        if (expiredCertsOnCRL != null) {
            try {
                return FACTORY.createASN1GeneralizedTime((IASN1Encodable)expiredCertsOnCRL).getDate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (Date)TimestampConstants.UNDEFINED_TIMESTAMP_DATE;
    }

    private static int computeInterimReasonsMask(IIssuingDistributionPoint issuingDistPoint, IDistributionPoint distributionPoint) {
        IReasonFlags reasons;
        IReasonFlags onlySomeReasons;
        int interimReasonsMask = 32895;
        if (!issuingDistPoint.isNull() && !(onlySomeReasons = issuingDistPoint.getOnlySomeReasons()).isNull()) {
            interimReasonsMask &= onlySomeReasons.intValue();
        }
        if (distributionPoint != null && !(reasons = distributionPoint.getReasons()).isNull()) {
            interimReasonsMask &= reasons.intValue();
        }
        return interimReasonsMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyCrlIntegrity(ValidationReport report, ValidationContext context, X509Certificate certificate, X509CRL crl, Date responseGenerationDate) {
        Certificate[][] certificateSets;
        try {
            certificateSets = this.certificateRetriever.getCrlIssuerCertificatesByName(crl);
        }
        catch (RuntimeException e2) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, CRL_ISSUER_REQUEST_FAILED, e2, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        if (certificateSets == null || certificateSets.length == 0) {
            report.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, CRL_ISSUER_NOT_FOUND, ReportItem.ReportItemStatus.INDETERMINATE));
            return;
        }
        List certificatesList = Arrays.stream(certificateSets).sorted((array1, array2) -> Integer.compare(this.certificateRetriever.getCertificateOrigin(array1[0]).ordinal(), this.certificateRetriever.getCertificateOrigin(array2[0]).ordinal())).collect(Collectors.toList());
        ValidationReport[] candidateReports = new ValidationReport[certificatesList.size()];
        for (int i = 0; i < certificatesList.size(); ++i) {
            ValidationReport candidateReport;
            candidateReports[i] = candidateReport = new ValidationReport();
            Certificate[] certs = (Certificate[])certificatesList.get(i);
            Certificate crlIssuer = certs[0];
            List<X509Certificate> crlIssuerRoots = this.getRoots(crlIssuer);
            List<X509Certificate> subjectRoots = this.getRoots(certificate);
            if (!crlIssuerRoots.stream().anyMatch(cert -> subjectRoots.contains(cert))) {
                candidateReport.addReportItem(new CertificateReportItem(certificate, CRL_CHECK, CRL_ISSUER_NO_COMMON_ROOT, ReportItem.ReportItemStatus.INDETERMINATE));
                continue;
            }
            SafeCalling.onExceptionLog(() -> crl.verify(crlIssuer.getPublicKey()), candidateReport, e -> new CertificateReportItem(certificate, CRL_CHECK, CRL_INVALID, (Exception)e, ReportItem.ReportItemStatus.INDETERMINATE));
            if (this.builder.isCertificateBeingValidated((X509Certificate)crlIssuer)) {
                report.addReportItem(new CertificateReportItem((X509Certificate)crlIssuer, CRL_CHECK, CERTIFICATE_IN_ISSUER_CHAIN, ReportItem.ReportItemStatus.INDETERMINATE));
                continue;
            }
            this.builder.addCertificateBeingValidated((X509Certificate)crlIssuer);
            ValidationReport responderReport = new ValidationReport();
            try {
                SafeCalling.onExceptionLog(() -> this.builder.getCertificateChainValidator().validate(responderReport, context.setCertificateSource(CertificateSource.CRL_ISSUER), (X509Certificate)crlIssuer, responseGenerationDate), candidateReport, e -> new CertificateReportItem(certificate, CRL_CHECK, CRL_ISSUER_CHAIN_FAILED, (Exception)e, ReportItem.ReportItemStatus.INDETERMINATE));
            }
            finally {
                this.builder.removeCertificateBeingValidated((X509Certificate)crlIssuer);
            }
            CRLValidator.addResponderValidationReport(candidateReport, responderReport);
            if (candidateReport.getValidationResult() != ValidationReport.ValidationResult.VALID) continue;
            report.merge(candidateReport);
            return;
        }
        for (ValidationReport candidateReport : candidateReports) {
            report.merge(candidateReport);
        }
    }

    private List<X509Certificate> getRoots(Certificate cert) {
        List<X509Certificate[]> chains = this.certificateRetriever.buildCertificateChains((X509Certificate)cert);
        return chains.stream().map(certArray -> certArray[((X509Certificate[])certArray).length - 1]).collect(Collectors.toList());
    }

    private static void addResponderValidationReport(ValidationReport report, ValidationReport responderReport) {
        for (ReportItem reportItem : responderReport.getLogs()) {
            report.addReportItem(ReportItem.ReportItemStatus.INVALID == reportItem.getStatus() ? reportItem.setStatus(ReportItem.ReportItemStatus.INDETERMINATE) : reportItem);
        }
    }
}

