/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPResp;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.signatures.CertificateUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.util.Arrays;

public class PdfDSS
extends PdfObjectWrapper<PdfDictionary> {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();

    public PdfDSS(PdfDictionary pdfObject) {
        super((PdfObject)pdfObject);
    }

    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    public Certificate[] getCertificates() {
        PdfArray certs = ((PdfDictionary)super.getPdfObject()).getAsArray(PdfName.Certs);
        Certificate[] result = new Certificate[certs == null ? 0 : certs.size()];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = CertificateUtil.generateCertificate(new ByteArrayInputStream(certs.getAsStream(i).getBytes()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public IOCSPResp[] getOcsps() {
        PdfArray ocsps = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.OCSPs);
        IOCSPResp[] result = new IOCSPResp[ocsps == null ? 0 : ocsps.size()];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = BOUNCY_CASTLE_FACTORY.createOCSPResp(ocsps.getAsStream(i).getBytes());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public X509CRL[] getCrls() {
        PdfArray crls = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.CRLs);
        X509CRL[] result = new X509CRL[crls == null ? 0 : crls.size()];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = (X509CRL)CertificateUtil.parseCrlFromBytes(crls.getAsStream(i).getBytes());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Arrays.hashCode(this.getCertificates());
        result = 31 * result + Arrays.hashCode(this.getOcsps());
        result = 31 * result + Arrays.hashCode(this.getCrls());
        return result;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

