/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IDEROctetString;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IOCSPResponse;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IOCSPResponseStatus;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IResponseBytes;
import com.itextpdf.commons.bouncycastle.cert.ocsp.AbstractOCSPException;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.operator.AbstractOperatorCreationException;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDeveloperExtension;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.signatures.DefaultIssuingCertificateRetriever;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IIssuingCertificateRetriever;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.PdfSignature;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.SignatureUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LtvVerification {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(LtvVerification.class);
    private final PdfDocument document;
    private final SignatureUtil sgnUtil;
    private final Map<PdfName, ValidationData> validated = new HashMap<PdfName, ValidationData>();
    private boolean used = false;
    private String securityProviderCode = null;
    private RevocationDataNecessity revocationDataNecessity = RevocationDataNecessity.OPTIONAL;
    private IIssuingCertificateRetriever issuingCertificateRetriever = new DefaultIssuingCertificateRetriever();

    public LtvVerification(PdfDocument document) {
        this.document = document;
        this.sgnUtil = new SignatureUtil(document);
    }

    public LtvVerification(PdfDocument document, String securityProviderCode) {
        this(document);
        this.securityProviderCode = securityProviderCode;
    }

    public LtvVerification setRevocationDataNecessity(RevocationDataNecessity revocationDataNecessity) {
        this.revocationDataNecessity = revocationDataNecessity;
        return this;
    }

    public LtvVerification setIssuingCertificateRetriever(IIssuingCertificateRetriever issuingCertificateRetriever) {
        this.issuingCertificateRetriever = issuingCertificateRetriever;
        return this;
    }

    public boolean addVerification(String signatureName, IOcspClient ocsp, ICrlClient crl, CertificateOption certOption, Level level, CertificateInclusion certInclude) throws IOException, GeneralSecurityException {
        if (this.used) {
            throw new IllegalStateException("Verification already output.");
        }
        PdfPKCS7 pk = this.sgnUtil.readSignatureData(signatureName, this.securityProviderCode);
        LOGGER.info("Adding verification for " + signatureName);
        Certificate[] certificateChain = pk.getCertificates();
        X509Certificate signingCert = pk.getSigningCertificate();
        ValidationData validationData = new ValidationData();
        HashSet<X509Certificate> processedCerts = new HashSet<X509Certificate>();
        this.addRevocationDataForChain(signingCert, certificateChain, ocsp, crl, level, certInclude, certOption, validationData, processedCerts);
        if (certOption == CertificateOption.ALL_CERTIFICATES) {
            Certificate[] timestampCertsChain = pk.getTimestampCertificates();
            this.addRevocationDataForChain(signingCert, timestampCertsChain, ocsp, crl, level, certInclude, certOption, validationData, processedCerts);
        }
        if (certInclude == CertificateInclusion.YES) {
            for (X509Certificate processedCert : processedCerts) {
                List<byte[]> certs = validationData.getCerts();
                certs.add(processedCert.getEncoded());
                validationData.setCerts(certs);
            }
        }
        if (validationData.getCrls().isEmpty() && validationData.getOcsps().isEmpty()) {
            return false;
        }
        this.validated.put(this.getSignatureHashKey(signatureName), validationData);
        return true;
    }

    public boolean addVerification(String signatureName, Collection<byte[]> ocsps, Collection<byte[]> crls, Collection<byte[]> certs) throws IOException, GeneralSecurityException {
        if (this.used) {
            throw new IllegalStateException("Verification already output.");
        }
        ValidationData vd = new ValidationData();
        if (ocsps != null) {
            for (byte[] ocsp : ocsps) {
                List<byte[]> ocspsArr = vd.getOcsps();
                ocspsArr.add(LtvVerification.buildOCSPResponse(ocsp));
                vd.setOcsps(ocspsArr);
            }
        }
        if (crls != null) {
            List<byte[]> crlsArr = vd.getCrls();
            crlsArr.addAll(crls);
            vd.setCrls(crlsArr);
        }
        if (certs != null) {
            List<byte[]> certsArr = vd.getCerts();
            certsArr.addAll(certs);
            vd.setCerts(certsArr);
        }
        this.validated.put(this.getSignatureHashKey(signatureName), vd);
        return true;
    }

    public void merge() {
        if (this.used || this.validated.isEmpty()) {
            return;
        }
        this.used = true;
        PdfDictionary catalog = (PdfDictionary)this.document.getCatalog().getPdfObject();
        PdfObject dss = catalog.get(PdfName.DSS);
        if (dss == null) {
            this.createDss();
        } else {
            this.updateDss();
        }
    }

    public static String convertToHex(byte[] bytes) {
        ByteBuffer buf = new ByteBuffer();
        for (byte b : bytes) {
            buf.appendHex(b);
        }
        return StringNormalizer.toUpperCase((String)PdfEncodings.convertToString((byte[])buf.toByteArray(), null));
    }

    X509Certificate getParent(X509Certificate cert, Certificate[] certs) {
        for (Certificate certificate : certs) {
            X509Certificate parent = (X509Certificate)certificate;
            if (!cert.getIssuerX500Principal().equals(parent.getSubjectX500Principal())) continue;
            try {
                cert.verify(parent.getPublicKey());
                return parent;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void addRevocationDataForChain(X509Certificate signingCert, Certificate[] certChain, IOcspClient ocsp, ICrlClient crl, Level level, CertificateInclusion certInclude, CertificateOption certOption, ValidationData validationData, Set<X509Certificate> processedCerts) throws CertificateException, IOException, CRLException {
        Certificate[] fullChain;
        for (Certificate certificate : fullChain = certOption == CertificateOption.ALL_CERTIFICATES ? this.retrieveMissingCertificates(certChain) : certChain) {
            X509Certificate cert = (X509Certificate)certificate;
            LOGGER.info(MessageFormatUtil.format((String)"Certificate: {0}", (Object[])new Object[]{BOUNCY_CASTLE_FACTORY.createX500Name(cert)}));
            if (certOption == CertificateOption.SIGNING_CERTIFICATE && !cert.equals(signingCert) || processedCerts.contains(cert)) continue;
            this.addRevocationDataForCertificate(signingCert, fullChain, cert, ocsp, crl, level, certInclude, certOption, validationData, processedCerts);
        }
    }

    private void addRevocationDataForCertificate(X509Certificate signingCert, Certificate[] certificateChain, X509Certificate cert, IOcspClient ocsp, ICrlClient crl, Level level, CertificateInclusion certInclude, CertificateOption certOption, ValidationData validationData, Set<X509Certificate> processedCerts) throws IOException, CertificateException, CRLException {
        Collection<byte[]> cims;
        processedCerts.add(cert);
        byte[] validityAssured = SignUtils.getExtensionValueByOid(cert, "0.4.0.194121.2.1");
        if (validityAssured != null) {
            LOGGER.info(MessageFormatUtil.format((String)"Revocation data for certificate: \"{0}\" is not added due to validity assured - short term extension.", (Object[])new Object[]{cert.getSubjectX500Principal()}));
            return;
        }
        byte[] ocspEnc = null;
        boolean revocationDataAdded = false;
        if (ocsp != null && level != Level.CRL) {
            ocspEnc = ocsp.getEncoded(cert, this.getParent(cert, certificateChain), null);
            if (ocspEnc != null && BOUNCY_CASTLE_FACTORY.createCertificateStatus().getGood().equals(OcspClientBouncyCastle.getCertificateStatus(ocspEnc))) {
                List<byte[]> ocsps = validationData.getOcsps();
                ocsps.add(LtvVerification.buildOCSPResponse(ocspEnc));
                validationData.setOcsps(ocsps);
                revocationDataAdded = true;
                LOGGER.info("OCSP added");
                if (certOption == CertificateOption.ALL_CERTIFICATES) {
                    this.addRevocationDataForOcspCert(ocspEnc, signingCert, ocsp, crl, level, certInclude, certOption, validationData, processedCerts);
                }
            } else {
                ocspEnc = null;
            }
        }
        if (crl != null && (level == Level.CRL || level == Level.OCSP_CRL || level == Level.OCSP_OPTIONAL_CRL && ocspEnc == null) && (cims = crl.getEncoded(cert, null)) != null) {
            for (byte[] cim : cims) {
                revocationDataAdded = true;
                boolean dup = false;
                for (byte[] b : validationData.getCrls()) {
                    if (!Arrays.equals(b, cim)) continue;
                    dup = true;
                    break;
                }
                if (dup) continue;
                List<byte[]> crls = validationData.getCrls();
                crls.add(cim);
                validationData.setCrls(crls);
                LOGGER.info("CRL added");
                if (certOption != CertificateOption.ALL_CERTIFICATES) continue;
                Certificate[] certsList = this.issuingCertificateRetriever.getCrlIssuerCertificates(SignUtils.parseCrlFromStream(new ByteArrayInputStream(cim)));
                this.addRevocationDataForChain(signingCert, certsList, ocsp, crl, level, certInclude, certOption, validationData, processedCerts);
            }
        }
        if (this.revocationDataNecessity == RevocationDataNecessity.REQUIRED_FOR_SIGNING_CERTIFICATE && signingCert.equals(cert) && !revocationDataAdded) {
            throw new PdfException("Neither ocsp nor crl data are available for the signing certificate or certificate is revoked.");
        }
    }

    private void addRevocationDataForOcspCert(byte[] ocspEnc, X509Certificate signingCert, IOcspClient ocsp, ICrlClient crl, Level level, CertificateInclusion certInclude, CertificateOption certOption, ValidationData validationData, Set<X509Certificate> processedCerts) throws CertificateException, IOException, CRLException {
        IBasicOCSPResp ocspResp = BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(BOUNCY_CASTLE_FACTORY.createBasicOCSPResponse(ocspEnc));
        Iterable<X509Certificate> certs = SignUtils.getCertsFromOcspResponse(ocspResp);
        List<X509Certificate> ocspCertsList = LtvVerification.iterableToList(certs);
        X509Certificate ocspSigningCert = null;
        for (X509Certificate ocspCert : ocspCertsList) {
            try {
                if (!SignUtils.isSignatureValid(ocspResp, (Certificate)ocspCert, BOUNCY_CASTLE_FACTORY.getProviderName())) continue;
                ocspSigningCert = ocspCert;
                break;
            }
            catch (AbstractOCSPException | AbstractOperatorCreationException throwable) {
            }
        }
        if (ocspSigningCert != null && SignUtils.getExtensionValueByOid(ocspSigningCert, "1.3.6.1.5.5.7.48.1.5") != null) {
            ocspCertsList.remove(ocspSigningCert);
            processedCerts.add(ocspSigningCert);
        }
        this.addRevocationDataForChain(signingCert, ocspCertsList.toArray(new X509Certificate[0]), ocsp, crl, level, certInclude, certOption, validationData, processedCerts);
    }

    private static List<X509Certificate> iterableToList(Iterable<X509Certificate> iterable) {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (X509Certificate certificate : iterable) {
            list.add(certificate);
        }
        return list;
    }

    private static byte[] buildOCSPResponse(byte[] basicOcspResponse) throws IOException {
        IDEROctetString doctet = BOUNCY_CASTLE_FACTORY.createDEROctetString(basicOcspResponse);
        IOCSPResponseStatus respStatus = BOUNCY_CASTLE_FACTORY.createOCSPResponseStatus(BOUNCY_CASTLE_FACTORY.createOCSPRespBuilderInstance().getSuccessful());
        IResponseBytes responseBytes = BOUNCY_CASTLE_FACTORY.createResponseBytes(BOUNCY_CASTLE_FACTORY.createOCSPObjectIdentifiers().getIdPkixOcspBasic(), doctet);
        IOCSPResponse ocspResponse = BOUNCY_CASTLE_FACTORY.createOCSPResponse(respStatus, responseBytes);
        return BOUNCY_CASTLE_FACTORY.createOCSPResp(ocspResponse).getEncoded();
    }

    private PdfName getSignatureHashKey(String signatureName) throws NoSuchAlgorithmException {
        PdfSignature sig = this.sgnUtil.getSignature(signatureName);
        PdfString contents = sig.getContents();
        byte[] bc = PdfEncodings.convertToBytes((String)contents.getValue(), null);
        byte[] bt = LtvVerification.hashBytesSha1(bc);
        return new PdfName(LtvVerification.convertToHex(bt));
    }

    private static byte[] hashBytesSha1(byte[] b) throws NoSuchAlgorithmException {
        MessageDigest sh = MessageDigest.getInstance("SHA1");
        return sh.digest(b);
    }

    private void updateDss() {
        PdfDictionary catalog = (PdfDictionary)this.document.getCatalog().getPdfObject();
        catalog.setModified();
        PdfDictionary dss = catalog.getAsDictionary(PdfName.DSS);
        PdfArray ocsps = dss.getAsArray(PdfName.OCSPs);
        PdfArray crls = dss.getAsArray(PdfName.CRLs);
        PdfArray certs = dss.getAsArray(PdfName.Certs);
        dss.remove(PdfName.OCSPs);
        dss.remove(PdfName.CRLs);
        dss.remove(PdfName.Certs);
        PdfDictionary vrim = dss.getAsDictionary(PdfName.VRI);
        if (vrim != null) {
            for (PdfName n : vrim.keySet()) {
                PdfDictionary vri;
                if (!this.validated.containsKey(n) || (vri = vrim.getAsDictionary(n)) == null) continue;
                LtvVerification.deleteOldReferences(ocsps, vri.getAsArray(PdfName.OCSP));
                LtvVerification.deleteOldReferences(crls, vri.getAsArray(PdfName.CRL));
                LtvVerification.deleteOldReferences(certs, vri.getAsArray(PdfName.Cert));
            }
        }
        if (ocsps == null) {
            ocsps = new PdfArray();
        }
        if (crls == null) {
            crls = new PdfArray();
        }
        if (certs == null) {
            certs = new PdfArray();
        }
        if (vrim == null) {
            vrim = new PdfDictionary();
        }
        this.outputDss(dss, vrim, ocsps, crls, certs);
    }

    private static void deleteOldReferences(PdfArray all, PdfArray toDelete) {
        if (all == null || toDelete == null) {
            return;
        }
        for (PdfObject pi : toDelete) {
            PdfIndirectReference pir = pi.getIndirectReference();
            for (int i = 0; i < all.size(); ++i) {
                PdfIndirectReference pod = all.get(i).getIndirectReference();
                if (!Objects.equals(pir, pod)) continue;
                all.remove(i);
                --i;
            }
        }
    }

    private void createDss() {
        this.outputDss(new PdfDictionary(), new PdfDictionary(), new PdfArray(), new PdfArray(), new PdfArray());
    }

    private void outputDss(PdfDictionary dss, PdfDictionary vrim, PdfArray ocsps, PdfArray crls, PdfArray certs) {
        PdfCatalog catalog = this.document.getCatalog();
        if (this.document.getPdfVersion().compareTo(PdfVersion.PDF_2_0) < 0) {
            catalog.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL5);
        }
        for (PdfName vkey : this.validated.keySet()) {
            PdfStream ps;
            PdfArray ocsp = new PdfArray();
            PdfArray crl = new PdfArray();
            PdfArray cert = new PdfArray();
            PdfDictionary vri = new PdfDictionary();
            for (byte[] b : this.validated.get(vkey).getCrls()) {
                ps = new PdfStream(b);
                ps.setCompressionLevel(-1);
                ps.makeIndirect(this.document);
                crl.add((PdfObject)ps);
                crls.add((PdfObject)ps);
                crls.setModified();
            }
            for (byte[] b : this.validated.get(vkey).getOcsps()) {
                ps = new PdfStream(b);
                ps.setCompressionLevel(-1);
                ocsp.add((PdfObject)ps);
                ocsps.add((PdfObject)ps);
                ocsps.setModified();
            }
            for (byte[] b : this.validated.get(vkey).getCerts()) {
                ps = new PdfStream(b);
                ps.setCompressionLevel(-1);
                ps.makeIndirect(this.document);
                cert.add((PdfObject)ps);
                certs.add((PdfObject)ps);
                certs.setModified();
            }
            if (!ocsp.isEmpty()) {
                ocsp.makeIndirect(this.document);
                vri.put(PdfName.OCSP, (PdfObject)ocsp);
            }
            if (!crl.isEmpty()) {
                crl.makeIndirect(this.document);
                vri.put(PdfName.CRL, (PdfObject)crl);
            }
            if (!cert.isEmpty()) {
                cert.makeIndirect(this.document);
                vri.put(PdfName.Cert, (PdfObject)cert);
            }
            vri.makeIndirect(this.document);
            vrim.put(vkey, (PdfObject)vri);
        }
        vrim.makeIndirect(this.document);
        vrim.setModified();
        dss.put(PdfName.VRI, (PdfObject)vrim);
        if (!ocsps.isEmpty()) {
            ocsps.makeIndirect(this.document);
            dss.put(PdfName.OCSPs, (PdfObject)ocsps);
        }
        if (!crls.isEmpty()) {
            crls.makeIndirect(this.document);
            dss.put(PdfName.CRLs, (PdfObject)crls);
        }
        if (!certs.isEmpty()) {
            certs.makeIndirect(this.document);
            dss.put(PdfName.Certs, (PdfObject)certs);
        }
        dss.makeIndirect(this.document);
        dss.setModified();
        catalog.put(PdfName.DSS, (PdfObject)dss);
    }

    private Certificate[] retrieveMissingCertificates(Certificate[] certChain) {
        LinkedHashMap<String, Certificate> restoredChain = new LinkedHashMap<String, Certificate>();
        for (Certificate certificate : certChain) {
            Certificate[] subChain;
            for (Certificate cert : subChain = this.issuingCertificateRetriever.retrieveMissingCertificates(new Certificate[]{certificate})) {
                restoredChain.put(((X509Certificate)cert).getSubjectX500Principal().getName(), cert);
            }
        }
        return restoredChain.values().toArray(new Certificate[0]);
    }

    private static class ValidationData {
        private List<byte[]> crls = new ArrayList<byte[]>();
        private List<byte[]> ocsps = new ArrayList<byte[]>();
        private List<byte[]> certs = new ArrayList<byte[]>();

        private ValidationData() {
        }

        public void setCrls(List<byte[]> crls) {
            this.crls = crls;
        }

        public List<byte[]> getCrls() {
            return this.crls;
        }

        public void setOcsps(List<byte[]> ocsps) {
            this.ocsps = ocsps;
        }

        public List<byte[]> getOcsps() {
            return this.ocsps;
        }

        public void setCerts(List<byte[]> certs) {
            this.certs = certs;
        }

        public List<byte[]> getCerts() {
            return this.certs;
        }
    }

    public static enum RevocationDataNecessity {
        REQUIRED_FOR_SIGNING_CERTIFICATE,
        OPTIONAL;

    }

    public static enum CertificateInclusion {
        YES,
        NO;

    }

    public static enum CertificateOption {
        SIGNING_CERTIFICATE,
        WHOLE_CHAIN,
        ALL_CERTIFICATES;

    }

    public static enum Level {
        OCSP,
        CRL,
        OCSP_CRL,
        OCSP_OPTIONAL_CRL;

    }
}

