/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl.criteria;

import com.itextpdf.signatures.validation.lotl.criteria.Criteria;
import java.security.cert.X509Certificate;

public class KeyUsageCriteria
implements Criteria {
    private final Boolean[] requiredKeyUsage = new Boolean[9];

    public void addKeyUsageBit(String name, String value) {
        boolean booleanValue = "true".equals(value);
        switch (name) {
            case "digitalSignature": {
                this.requiredKeyUsage[0] = booleanValue;
                break;
            }
            case "nonRepudiation": {
                this.requiredKeyUsage[1] = booleanValue;
                break;
            }
            case "keyEncipherment": {
                this.requiredKeyUsage[2] = booleanValue;
                break;
            }
            case "dataEncipherment": {
                this.requiredKeyUsage[3] = booleanValue;
                break;
            }
            case "keyAgreement": {
                this.requiredKeyUsage[4] = booleanValue;
                break;
            }
            case "keyCertSign": {
                this.requiredKeyUsage[5] = booleanValue;
                break;
            }
            case "crlSign": {
                this.requiredKeyUsage[6] = booleanValue;
                break;
            }
            case "encipherOnly": {
                this.requiredKeyUsage[7] = booleanValue;
                break;
            }
            case "decipherOnly": {
                this.requiredKeyUsage[8] = booleanValue;
            }
        }
    }

    public Boolean[] getKeyUsageBits() {
        return this.requiredKeyUsage;
    }

    @Override
    public boolean checkCriteria(X509Certificate certificate) {
        boolean[] keyUsage = certificate.getKeyUsage();
        if (keyUsage == null || keyUsage.length != this.requiredKeyUsage.length) {
            return false;
        }
        for (int i = 0; i < keyUsage.length; ++i) {
            if (this.requiredKeyUsage[i] == null || keyUsage[i] == this.requiredKeyUsage[i]) continue;
            return false;
        }
        return true;
    }
}

