/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl.criteria;

import com.itextpdf.signatures.validation.lotl.criteria.Criteria;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class ExtendedKeyUsageCriteria
implements Criteria {
    private final List<String> requiredExtendedKeyUsages = new ArrayList<String>();

    public void addRequiredExtendedKeyUsage(String requiredExtendedKeyUsage) {
        this.requiredExtendedKeyUsages.add(requiredExtendedKeyUsage);
    }

    public List<String> getRequiredExtendedKeyUsages() {
        return new ArrayList<String>(this.requiredExtendedKeyUsages);
    }

    @Override
    public boolean checkCriteria(X509Certificate certificate) {
        try {
            List<String> extendedKeyUsage = certificate.getExtendedKeyUsage();
            for (String requiredExtendedKeyUsage : this.requiredExtendedKeyUsages) {
                if (extendedKeyUsage.contains(requiredExtendedKeyUsage)) continue;
                return false;
            }
        }
        catch (CertificateParsingException ignored) {
            return false;
        }
        return true;
    }
}

