/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.commons.utils.RuntimeUtil;
import com.itextpdf.eutrustedlistsresources.EuropeanTrustedListConfiguration;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.validation.EuropeanTrustedCertificatesResourceLoader;
import com.itextpdf.signatures.validation.EuropeanTrustedListConfigurationFactory;
import java.security.cert.Certificate;
import java.util.List;

class LoadFromModuleEuropeanTrustedListConfigurationFactory
extends EuropeanTrustedListConfigurationFactory {
    private static final String CLASS_FOR_RESOURCES = "com.itextpdf.eutrustedlistsresources.EuropeanTrustedListConfiguration";
    EuropeanTrustedListConfiguration config;

    public LoadFromModuleEuropeanTrustedListConfigurationFactory() {
        if (!RuntimeUtil.isClassLoaded((String)CLASS_FOR_RESOURCES)) {
            throw new PdfException("European Trusted List resources are not available. Please ensure that the itextpdf-eutrustedlistsresources module is included in your project. Alternatively,  you can use the EuropeanTrustedListConfigurationFactory to load the resources from a custom location.");
        }
        this.config = new EuropeanTrustedListConfiguration();
    }

    @Override
    public String getTrustedListUri() {
        return this.config.getTrustedListUri();
    }

    @Override
    public String getCurrentlySupportedPublication() {
        return this.config.getCurrentlySupportedPublication();
    }

    @Override
    public List<Certificate> getCertificates() {
        EuropeanTrustedCertificatesResourceLoader loader = new EuropeanTrustedCertificatesResourceLoader(this.config);
        return loader.loadCertificates();
    }
}

