/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.validation.LoadFromModuleEuropeanTrustedListConfigurationFactory;
import java.security.cert.Certificate;
import java.util.List;
import java.util.function.Supplier;

public abstract class EuropeanTrustedListConfigurationFactory {
    private static Supplier<EuropeanTrustedListConfigurationFactory> configuration = () -> {
        try {
            return new LoadFromModuleEuropeanTrustedListConfigurationFactory();
        }
        catch (Exception e) {
            throw new PdfException("European Trusted List resources are not available. Please ensure that the itextpdf-eutrustedlistsresources module is included in your project. Alternatively,  you can use the EuropeanTrustedListConfigurationFactory to load the resources from a custom location.");
        }
    };

    public static Supplier<EuropeanTrustedListConfigurationFactory> getFactory() {
        return configuration;
    }

    public static void setFactory(Supplier<EuropeanTrustedListConfigurationFactory> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory cannot be null");
        }
        configuration = factory;
    }

    public abstract String getTrustedListUri();

    public abstract String getCurrentlySupportedPublication();

    public abstract List<Certificate> getCertificates();
}

