/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1.extensions;

import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.signatures.CertificateUtil;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class CertificateExtension {
    private final String extensionOid;
    private final IASN1Primitive extensionValue;

    public CertificateExtension(String extensionOid, IASN1Primitive extensionValue) {
        this.extensionOid = extensionOid;
        this.extensionValue = extensionValue;
    }

    public IASN1Primitive getExtensionValue() {
        return this.extensionValue;
    }

    public String getExtensionOid() {
        return this.extensionOid;
    }

    public boolean existsInCertificate(X509Certificate certificate) {
        IASN1Primitive providedExtensionValue;
        try {
            providedExtensionValue = CertificateUtil.getExtensionValue(certificate, this.extensionOid);
        }
        catch (IOException e) {
            return false;
        }
        return Objects.equals(providedExtensionValue, this.extensionValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateExtension that = (CertificateExtension)o;
        return Objects.equals(this.extensionOid, that.extensionOid) && Objects.equals(this.extensionValue, that.extensionValue);
    }

    public int hashCode() {
        return Objects.hash(this.extensionOid, this.extensionValue);
    }
}

