/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1.extensions;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.validation.v1.extensions.CertificateExtension;
import java.io.IOException;
import java.security.cert.X509Certificate;

public class BasicConstraintsExtension
extends CertificateExtension {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final int pathLength;

    public BasicConstraintsExtension(boolean ca) {
        super("2.5.29.19", FACTORY.createBasicConstraints(ca).toASN1Primitive());
        this.pathLength = ca ? Integer.MAX_VALUE : -1;
    }

    public BasicConstraintsExtension(int pathLength) {
        super("2.5.29.19", FACTORY.createBasicConstraints(pathLength).toASN1Primitive());
        this.pathLength = pathLength;
    }

    @Override
    public boolean existsInCertificate(X509Certificate certificate) {
        try {
            if (CertificateUtil.getExtensionValue(certificate, "2.5.29.19") == null) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        if (this.pathLength >= 0) {
            return certificate.getBasicConstraints() >= this.pathLength;
        }
        return certificate.getBasicConstraints() < 0;
    }
}

