/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.SignatureUtil;
import com.itextpdf.signatures.validation.v1.CertificateChainValidator;
import com.itextpdf.signatures.validation.v1.SignatureValidationProperties;
import com.itextpdf.signatures.validation.v1.ValidatorChainBuilder;
import com.itextpdf.signatures.validation.v1.context.CertificateSource;
import com.itextpdf.signatures.validation.v1.context.TimeBasedContext;
import com.itextpdf.signatures.validation.v1.context.ValidationContext;
import com.itextpdf.signatures.validation.v1.context.ValidatorContext;
import com.itextpdf.signatures.validation.v1.report.ReportItem;
import com.itextpdf.signatures.validation.v1.report.ValidationReport;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

class SignatureValidator {
    static final String TIMESTAMP_VERIFICATION = "Timestamp verification check.";
    static final String SIGNATURE_VERIFICATION = "Signature verification check.";
    static final String CERTS_FROM_DSS = "Certificates from DSS check.";
    static final String CANNOT_PARSE_CERT_FROM_DSS = "Certificate {0} stored in DSS dictionary cannot be parsed.";
    static final String CANNOT_VERIFY_SIGNATURE = "Signature {0} cannot be mathematically verified.";
    static final String DOCUMENT_IS_NOT_COVERED = "Signature {0} doesn't cover entire document.";
    static final String CANNOT_VERIFY_TIMESTAMP = "Signature timestamp attribute cannot be verified";
    private final PdfDocument document;
    private final ValidationContext baseValidationContext;
    private final CertificateChainValidator certificateChainValidator;
    private final IssuingCertificateRetriever certificateRetriever;
    private final SignatureValidationProperties properties;

    SignatureValidator(PdfDocument document, ValidatorChainBuilder builder) {
        this.document = document;
        this.certificateRetriever = builder.getCertificateRetriever();
        this.properties = builder.getProperties();
        this.certificateChainValidator = builder.getCertificateChainValidator();
        this.baseValidationContext = new ValidationContext(ValidatorContext.SIGNATURE_VALIDATOR, CertificateSource.SIGNER_CERT, TimeBasedContext.PRESENT);
    }

    public ValidationReport validateLatestSignature() {
        ValidationReport validationReport = new ValidationReport();
        PdfPKCS7 pkcs7 = this.mathematicallyVerifySignature(validationReport);
        if (this.stopValidation(validationReport, this.baseValidationContext)) {
            return validationReport;
        }
        List<Certificate> certificatesFromDss = this.getCertificatesFromDss(validationReport);
        this.certificateRetriever.addKnownCertificates(certificatesFromDss);
        if (pkcs7.isTsp()) {
            return this.validateTimestampChain(validationReport, pkcs7.getCertificates(), pkcs7.getSigningCertificate());
        }
        Date signingDate = DateTimeUtil.getCurrentTimeDate();
        if (pkcs7.getTimeStampTokenInfo() != null) {
            try {
                if (!pkcs7.verifyTimestampImprint()) {
                    validationReport.addReportItem(new ReportItem(TIMESTAMP_VERIFICATION, CANNOT_VERIFY_TIMESTAMP, ReportItem.ReportItemStatus.INVALID));
                }
            }
            catch (GeneralSecurityException e) {
                validationReport.addReportItem(new ReportItem(TIMESTAMP_VERIFICATION, CANNOT_VERIFY_TIMESTAMP, e, ReportItem.ReportItemStatus.INVALID));
            }
            if (this.stopValidation(validationReport, this.baseValidationContext)) {
                return validationReport;
            }
            Certificate[] timestampCertificates = pkcs7.getTimestampCertificates();
            this.validateTimestampChain(validationReport, timestampCertificates, (X509Certificate)timestampCertificates[0]);
            if (this.stopValidation(validationReport, this.baseValidationContext)) {
                return validationReport;
            }
            signingDate = pkcs7.getTimeStampDate().getTime();
        }
        Certificate[] certificates = pkcs7.getCertificates();
        this.certificateRetriever.addKnownCertificates(Arrays.asList(certificates));
        X509Certificate signingCertificate = pkcs7.getSigningCertificate();
        return this.certificateChainValidator.validate(validationReport, this.baseValidationContext, signingCertificate, signingDate);
    }

    private PdfPKCS7 mathematicallyVerifySignature(ValidationReport validationReport) {
        SignatureUtil signatureUtil = new SignatureUtil(this.document);
        List<String> signatures = signatureUtil.getSignatureNames();
        String latestSignatureName = signatures.get(signatures.size() - 1);
        PdfPKCS7 pkcs7 = signatureUtil.readSignatureData(latestSignatureName);
        if (!signatureUtil.signatureCoversWholeDocument(latestSignatureName)) {
            validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format((String)DOCUMENT_IS_NOT_COVERED, (Object[])new Object[]{latestSignatureName}), ReportItem.ReportItemStatus.INVALID));
        }
        try {
            if (!pkcs7.verifySignatureIntegrityAndAuthenticity()) {
                validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format((String)CANNOT_VERIFY_SIGNATURE, (Object[])new Object[]{latestSignatureName}), ReportItem.ReportItemStatus.INVALID));
            }
        }
        catch (GeneralSecurityException e) {
            validationReport.addReportItem(new ReportItem(SIGNATURE_VERIFICATION, MessageFormatUtil.format((String)CANNOT_VERIFY_SIGNATURE, (Object[])new Object[]{latestSignatureName}), e, ReportItem.ReportItemStatus.INVALID));
        }
        return pkcs7;
    }

    private ValidationReport validateTimestampChain(ValidationReport validationReport, Certificate[] knownCerts, X509Certificate signingCert) {
        this.certificateRetriever.addKnownCertificates(Arrays.asList(knownCerts));
        Date signingDate = DateTimeUtil.getCurrentTimeDate();
        return this.certificateChainValidator.validate(validationReport, this.baseValidationContext.setCertificateSource(CertificateSource.TIMESTAMP), signingCert, signingDate);
    }

    private List<Certificate> getCertificatesFromDss(ValidationReport validationReport) {
        PdfArray certs;
        PdfDictionary dss = ((PdfDictionary)this.document.getCatalog().getPdfObject()).getAsDictionary(PdfName.DSS);
        ArrayList<Certificate> certificatesFromDss = new ArrayList<Certificate>();
        if (dss != null && (certs = dss.getAsArray(PdfName.Certs)) != null) {
            for (int i = 0; i < certs.size(); ++i) {
                PdfStream certStream = certs.getAsStream(i);
                try {
                    certificatesFromDss.add(CertificateUtil.generateCertificate(new ByteArrayInputStream(certStream.getBytes())));
                    continue;
                }
                catch (GeneralSecurityException e) {
                    validationReport.addReportItem(new ReportItem(CERTS_FROM_DSS, MessageFormatUtil.format((String)CANNOT_PARSE_CERT_FROM_DSS, (Object[])new Object[]{certStream}), e, ReportItem.ReportItemStatus.INFO));
                }
            }
        }
        return certificatesFromDss;
    }

    private boolean stopValidation(ValidationReport result, ValidationContext validationContext) {
        return !this.properties.getContinueAfterFailure(validationContext) && result.getValidationResult() != ValidationReport.ValidationResult.VALID;
    }
}

