/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1EncodableVector;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Enumerated;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.IASN1OctetString;
import com.itextpdf.commons.bouncycastle.asn1.IASN1OutputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Set;
import com.itextpdf.commons.bouncycastle.asn1.IASN1TaggedObject;
import com.itextpdf.commons.bouncycastle.asn1.IDEROctetString;
import com.itextpdf.commons.bouncycastle.asn1.IDERSequence;
import com.itextpdf.commons.bouncycastle.asn1.IDERSet;
import com.itextpdf.commons.bouncycastle.asn1.cms.IAttribute;
import com.itextpdf.commons.bouncycastle.asn1.cms.IAttributeTable;
import com.itextpdf.commons.bouncycastle.asn1.cms.IContentInfo;
import com.itextpdf.commons.bouncycastle.asn1.esf.ISignaturePolicyIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.ess.IESSCertID;
import com.itextpdf.commons.bouncycastle.asn1.ess.ISigningCertificate;
import com.itextpdf.commons.bouncycastle.asn1.ess.ISigningCertificateV2;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IBasicOCSPResponse;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IOCSPObjectIdentifiers;
import com.itextpdf.commons.bouncycastle.asn1.pkcs.IPKCSObjectIdentifiers;
import com.itextpdf.commons.bouncycastle.asn1.pkcs.IRSASSAPSSParams;
import com.itextpdf.commons.bouncycastle.asn1.tsp.IMessageImprint;
import com.itextpdf.commons.bouncycastle.asn1.tsp.ITSTInfo;
import com.itextpdf.commons.bouncycastle.asn1.x509.IAlgorithmIdentifier;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateID;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.signatures.BouncyCastleDigest;
import com.itextpdf.signatures.CertificateInfo;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.DigestAlgorithms;
import com.itextpdf.signatures.IExternalDigest;
import com.itextpdf.signatures.ISignatureMechanismParams;
import com.itextpdf.signatures.ITSAClient;
import com.itextpdf.signatures.PdfSigner;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.SignatureMechanisms;
import com.itextpdf.signatures.SignaturePolicyInfo;
import com.itextpdf.signatures.TimestampConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class PdfPKCS7 {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private ISignaturePolicyIdentifier signaturePolicyIdentifier;
    private final String provider;
    private String signName;
    private String reason;
    private String location;
    private Calendar signDate = (Calendar)TimestampConstants.UNDEFINED_TIMESTAMP_DATE;
    private final Collection<IASN1Sequence> signedDataRevocationInfo = new ArrayList<IASN1Sequence>();
    private int version = 1;
    private int signerversion = 1;
    private final String digestAlgorithmOid;
    private MessageDigest messageDigest;
    private Set<String> digestalgos;
    private byte[] digestAttr;
    private PdfName filterSubtype;
    private String signatureMechanismOid;
    private IASN1Encodable signatureMechanismParameters = null;
    private IExternalDigest interfaceDigest;
    private byte[] externalSignatureValue;
    private byte[] externalEncapMessageContent;
    private Signature sig;
    private byte[] signatureValue;
    private byte[] encapMessageContent;
    private byte[] sigAttr;
    private byte[] sigAttrDer;
    private MessageDigest encContDigest;
    private boolean verified;
    private boolean verifyResult;
    private Collection<Certificate> certs;
    private Collection<Certificate> timestampCerts;
    Collection<Certificate> signCerts;
    private X509Certificate signCert;
    private Collection<CRL> crls;
    private final Collection<CRL> signedDataCrls = new ArrayList<CRL>();
    IBasicOCSPResponse basicResp;
    private final Collection<IBasicOCSPResponse> signedDataOcsps = new ArrayList<IBasicOCSPResponse>();
    private boolean isTsp;
    private boolean isCades;
    private ITSTInfo timeStampTokenInfo;

    public PdfPKCS7(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm, String provider, IExternalDigest interfaceDigest, boolean hasEncapContent) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.provider = provider;
        this.interfaceDigest = interfaceDigest;
        this.digestAlgorithmOid = DigestAlgorithms.getAllowedDigest(hashAlgorithm);
        if (this.digestAlgorithmOid == null) {
            throw new PdfException("Unknown hash algorithm: {0}.").setMessageParams(new Object[]{hashAlgorithm});
        }
        this.signCert = (X509Certificate)certChain[0];
        this.certs = new ArrayList<Certificate>();
        Collections.addAll(this.certs, certChain);
        this.digestalgos = new HashSet<String>();
        this.digestalgos.add(this.digestAlgorithmOid);
        if (privKey != null) {
            String signatureAlgo = SignUtils.getPrivateKeyAlgorithm(privKey);
            String mechanismOid = SignatureMechanisms.getSignatureMechanismOid(signatureAlgo, hashAlgorithm);
            if (mechanismOid == null) {
                throw new PdfException("Could not determine OID for signature algorithm {0} with digest {1}.").setMessageParams(new Object[]{signatureAlgo, hashAlgorithm});
            }
            this.signatureMechanismOid = mechanismOid;
        }
        if (hasEncapContent) {
            this.encapMessageContent = new byte[0];
            this.messageDigest = DigestAlgorithms.getMessageDigest(this.getDigestAlgorithmName(), provider);
        }
        if (privKey != null) {
            this.sig = this.initSignature(privKey);
        }
    }

    public PdfPKCS7(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm, String provider, boolean hasEncapContent) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, hashAlgorithm, provider, new BouncyCastleDigest(), hasEncapContent);
    }

    public PdfPKCS7(byte[] contentsKey, byte[] certsKey, String provider) {
        try {
            this.provider = provider;
            this.certs = SignUtils.readAllCerts(certsKey);
            this.signCerts = this.certs;
            this.signCert = (X509Certificate)SignUtils.getFirstElement(this.certs);
            this.crls = new ArrayList<CRL>();
            try (IASN1InputStream in = BOUNCY_CASTLE_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(contentsKey));){
                this.signatureValue = BOUNCY_CASTLE_FACTORY.createASN1OctetString((IASN1Encodable)in.readObject()).getOctets();
            }
            this.sig = SignUtils.getSignatureHelper("SHA1withRSA", provider);
            this.sig.initVerify(this.signCert.getPublicKey());
            this.digestAlgorithmOid = "1.2.840.10040.4.3";
            this.signatureMechanismOid = "1.3.36.3.3.1.2";
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
    }

    public PdfPKCS7(byte[] contentsKey, PdfName filterSubtype, String provider) {
        this.filterSubtype = filterSubtype;
        this.isTsp = PdfName.ETSI_RFC3161.equals((Object)filterSubtype);
        this.isCades = PdfName.ETSI_CAdES_DETACHED.equals((Object)filterSubtype);
        try {
            IPKCSObjectIdentifiers ipkcsObjectIdentifiers;
            IASN1Set unat;
            IAttributeTable attble;
            IAttribute ts;
            IASN1TaggedObject taggedObject;
            IASN1TaggedObject taggedObj;
            IASN1Primitive pkcs;
            this.provider = provider;
            try (IASN1InputStream din = BOUNCY_CASTLE_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(contentsKey));){
                pkcs = din.readObject();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot decode PKCS#7 SignedData object.");
            }
            IASN1Sequence signedData = BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)pkcs);
            if (signedData == null) {
                throw new IllegalArgumentException("Not a valid PKCS#7 object - not a sequence");
            }
            IASN1ObjectIdentifier objId = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(signedData.getObjectAt(0));
            if (!objId.getId().equals("1.2.840.113549.1.7.2")) {
                throw new IllegalArgumentException("Not a valid PKCS#7 object - not signed data.");
            }
            IASN1Sequence content = BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)BOUNCY_CASTLE_FACTORY.createASN1TaggedObject(signedData.getObjectAt(1)).getObject());
            this.version = BOUNCY_CASTLE_FACTORY.createASN1Integer(content.getObjectAt(0)).getValue().intValue();
            this.digestalgos = new HashSet<String>();
            Enumeration e = BOUNCY_CASTLE_FACTORY.createASN1Set(content.getObjectAt(1)).getObjects();
            while (e.hasMoreElements()) {
                IASN1Sequence s = BOUNCY_CASTLE_FACTORY.createASN1Sequence(e.nextElement());
                IASN1ObjectIdentifier o = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(s.getObjectAt(0));
                this.digestalgos.add(o.getId());
            }
            IASN1Sequence encapContentInfo = BOUNCY_CASTLE_FACTORY.createASN1Sequence(content.getObjectAt(2));
            if (encapContentInfo.size() > 1) {
                IASN1OctetString encapContent = BOUNCY_CASTLE_FACTORY.createASN1OctetString((IASN1Encodable)BOUNCY_CASTLE_FACTORY.createASN1TaggedObject(encapContentInfo.getObjectAt(1)).getObject());
                this.encapMessageContent = encapContent.getOctets();
            }
            int next = 3;
            while ((taggedObj = BOUNCY_CASTLE_FACTORY.createASN1TaggedObject(content.getObjectAt(next))) != null) {
                ++next;
                if (taggedObj.getTagNo() != 1) continue;
                CertificateUtil.retrieveRevocationInfoFromSignedData(taggedObj, this.signedDataCrls, this.signedDataOcsps, this.signedDataRevocationInfo);
            }
            this.certs = SignUtils.readAllCerts(contentsKey);
            IASN1Set signerInfos = BOUNCY_CASTLE_FACTORY.createASN1Set(content.getObjectAt(next));
            if (signerInfos.size() != 1) {
                throw new IllegalArgumentException("This PKCS#7 object has multiple SignerInfos. Only one is supported at this time.");
            }
            IASN1Sequence signerInfo = BOUNCY_CASTLE_FACTORY.createASN1Sequence(signerInfos.getObjectAt(0));
            this.signerversion = BOUNCY_CASTLE_FACTORY.createASN1Integer(signerInfo.getObjectAt(0)).getValue().intValue();
            IASN1Sequence issuerAndSerialNumber = BOUNCY_CASTLE_FACTORY.createASN1Sequence(signerInfo.getObjectAt(1));
            X500Principal issuer = SignUtils.getIssuerX500Principal(issuerAndSerialNumber);
            BigInteger serialNumber = BOUNCY_CASTLE_FACTORY.createASN1Integer(issuerAndSerialNumber.getObjectAt(1)).getValue();
            for (Certificate element : this.certs) {
                X509Certificate cert = BOUNCY_CASTLE_FACTORY.createX509Certificate((Object)element);
                if (!cert.getIssuerX500Principal().equals(issuer) || !serialNumber.equals(cert.getSerialNumber())) continue;
                this.signCert = cert;
                break;
            }
            if (this.signCert == null) {
                throw new PdfException("Cannot find signing certificate with serial {0}.").setMessageParams(new Object[]{issuer.getName() + " / " + serialNumber.toString(16)});
            }
            this.signCertificateChain();
            this.digestAlgorithmOid = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(BOUNCY_CASTLE_FACTORY.createASN1Sequence(signerInfo.getObjectAt(2)).getObjectAt(0)).getId();
            next = 3;
            boolean foundCades = false;
            IASN1TaggedObject tagsig = BOUNCY_CASTLE_FACTORY.createASN1TaggedObject(signerInfo.getObjectAt(next));
            if (tagsig != null) {
                IASN1Set sseq = BOUNCY_CASTLE_FACTORY.createASN1Set(tagsig, false);
                this.sigAttr = sseq.getEncoded();
                this.sigAttrDer = sseq.getEncoded(BOUNCY_CASTLE_FACTORY.createASN1Encoding().getDer());
                for (int k = 0; k < sseq.size(); ++k) {
                    byte[] hs2;
                    IESSCertID cerv2;
                    IESSCertID[] cerv2m;
                    IASN1Sequence seqout;
                    IASN1Set setout;
                    IASN1Sequence seq2 = BOUNCY_CASTLE_FACTORY.createASN1Sequence(sseq.getObjectAt(k));
                    String idSeq2 = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(seq2.getObjectAt(0)).getId();
                    if (idSeq2.equals("1.2.840.113549.1.9.4")) {
                        IASN1Set set = BOUNCY_CASTLE_FACTORY.createASN1Set(seq2.getObjectAt(1));
                        this.digestAttr = BOUNCY_CASTLE_FACTORY.createASN1OctetString(set.getObjectAt(0)).getOctets();
                        continue;
                    }
                    if (idSeq2.equals("1.2.840.113583.1.1.8")) {
                        setout = BOUNCY_CASTLE_FACTORY.createASN1Set(seq2.getObjectAt(1));
                        seqout = BOUNCY_CASTLE_FACTORY.createASN1Sequence(setout.getObjectAt(0));
                        for (int j = 0; j < seqout.size(); ++j) {
                            IASN1Sequence seqin;
                            IASN1TaggedObject tg = BOUNCY_CASTLE_FACTORY.createASN1TaggedObject(seqout.getObjectAt(j));
                            if (tg.getTagNo() == 0) {
                                seqin = BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)tg.getObject());
                                this.findCRL(seqin);
                            }
                            if (tg.getTagNo() != 1) continue;
                            seqin = BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)tg.getObject());
                            this.findOcsp(seqin);
                        }
                        continue;
                    }
                    if (this.isCades && idSeq2.equals("1.2.840.113549.1.9.16.2.12")) {
                        byte[] hs22;
                        setout = BOUNCY_CASTLE_FACTORY.createASN1Set(seq2.getObjectAt(1));
                        seqout = BOUNCY_CASTLE_FACTORY.createASN1Sequence(setout.getObjectAt(0));
                        ISigningCertificate sv2 = BOUNCY_CASTLE_FACTORY.createSigningCertificate(seqout);
                        cerv2m = sv2.getCerts();
                        cerv2 = cerv2m[0];
                        byte[] enc2 = this.signCert.getEncoded();
                        MessageDigest m2 = SignUtils.getMessageDigest("SHA-1");
                        byte[] signCertHash = m2.digest(enc2);
                        if (!Arrays.equals(signCertHash, hs22 = cerv2.getCertHash())) {
                            throw new IllegalArgumentException("Signing certificate doesn't match the ESS information.");
                        }
                        foundCades = true;
                        continue;
                    }
                    if (!this.isCades || !idSeq2.equals("1.2.840.113549.1.9.16.2.47")) continue;
                    setout = BOUNCY_CASTLE_FACTORY.createASN1Set(seq2.getObjectAt(1));
                    seqout = BOUNCY_CASTLE_FACTORY.createASN1Sequence(setout.getObjectAt(0));
                    ISigningCertificateV2 sv2 = BOUNCY_CASTLE_FACTORY.createSigningCertificateV2(seqout);
                    cerv2m = sv2.getCerts();
                    cerv2 = cerv2m[0];
                    IAlgorithmIdentifier ai2 = cerv2.getHashAlgorithm();
                    byte[] enc2 = this.signCert.getEncoded();
                    MessageDigest m2 = SignUtils.getMessageDigest(DigestAlgorithms.getDigest(ai2.getAlgorithm().getId()));
                    byte[] signCertHash = m2.digest(enc2);
                    if (!Arrays.equals(signCertHash, hs2 = cerv2.getCertHash())) {
                        throw new IllegalArgumentException("Signing certificate doesn't match the ESS information.");
                    }
                    foundCades = true;
                }
                if (this.digestAttr == null) {
                    throw new IllegalArgumentException("Authenticated attribute is missing the digest.");
                }
                ++next;
            }
            if (this.isCades && !foundCades) {
                throw new IllegalArgumentException("CAdES ESS information missing.");
            }
            IASN1Sequence signatureMechanismInfo = BOUNCY_CASTLE_FACTORY.createASN1Sequence(signerInfo.getObjectAt(next));
            ++next;
            this.signatureMechanismOid = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(signatureMechanismInfo.getObjectAt(0)).getId();
            if (signatureMechanismInfo.size() > 1) {
                this.signatureMechanismParameters = signatureMechanismInfo.getObjectAt(1);
            }
            this.signatureValue = BOUNCY_CASTLE_FACTORY.createASN1OctetString(signerInfo.getObjectAt(next)).getOctets();
            if (++next < signerInfo.size() && (taggedObject = BOUNCY_CASTLE_FACTORY.createASN1TaggedObject(signerInfo.getObjectAt(next))) != null && !BOUNCY_CASTLE_FACTORY.isNull((IASN1Encodable)(ts = (attble = BOUNCY_CASTLE_FACTORY.createAttributeTable(unat = BOUNCY_CASTLE_FACTORY.createASN1Set(taggedObject, false))).get((ipkcsObjectIdentifiers = BOUNCY_CASTLE_FACTORY.createPKCSObjectIdentifiers()).getIdAaSignatureTimeStampToken()))) && ts.getAttrValues().size() > 0) {
                IASN1Set attributeValues = ts.getAttrValues();
                IASN1Sequence tokenSequence = BOUNCY_CASTLE_FACTORY.createASN1SequenceInstance((Object)attributeValues.getObjectAt(0));
                this.timestampCerts = SignUtils.readAllCerts(tokenSequence.getEncoded());
                IContentInfo contentInfo = BOUNCY_CASTLE_FACTORY.createContentInfo(tokenSequence);
                this.timeStampTokenInfo = BOUNCY_CASTLE_FACTORY.createTSTInfo(contentInfo);
            }
            if (this.isTsp) {
                IContentInfo contentInfoTsp = BOUNCY_CASTLE_FACTORY.createContentInfo(signedData);
                this.timeStampTokenInfo = BOUNCY_CASTLE_FACTORY.createTSTInfo(contentInfoTsp);
                this.timestampCerts = this.certs;
                String algOID = this.timeStampTokenInfo.getMessageImprint().getHashAlgorithm().getAlgorithm().getId();
                this.messageDigest = DigestAlgorithms.getMessageDigestFromOid(algOID, null);
            } else {
                if (this.encapMessageContent != null || this.digestAttr != null) {
                    this.messageDigest = PdfName.Adbe_pkcs7_sha1.equals((Object)this.getFilterSubtype()) ? DigestAlgorithms.getMessageDigest("SHA1", provider) : DigestAlgorithms.getMessageDigest(this.getDigestAlgorithmName(), provider);
                    this.encContDigest = DigestAlgorithms.getMessageDigest(this.getDigestAlgorithmName(), provider);
                }
                this.sig = this.initSignature(this.signCert.getPublicKey());
            }
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
    }

    public void setSignaturePolicy(SignaturePolicyInfo signaturePolicy) {
        this.signaturePolicyIdentifier = signaturePolicy.toSignaturePolicyIdentifier();
    }

    public void setSignaturePolicy(ISignaturePolicyIdentifier signaturePolicy) {
        this.signaturePolicyIdentifier = signaturePolicy;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Calendar getSignDate() {
        Calendar dt = this.getTimeStampDate();
        if (dt == TimestampConstants.UNDEFINED_TIMESTAMP_DATE) {
            return this.signDate;
        }
        return dt;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public String getDigestAlgorithmOid() {
        return this.digestAlgorithmOid;
    }

    public String getDigestAlgorithmName() {
        String hashAlgoName = DigestAlgorithms.getDigest(this.digestAlgorithmOid);
        if ("1.3.101.112".equals(this.signatureMechanismOid) && !"2.16.840.1.101.3.4.2.3".equals(this.digestAlgorithmOid)) {
            throw new PdfException("{0} requires the document to be digested using {1}, not {2}").setMessageParams(new Object[]{"Ed25519", "SHA-512", hashAlgoName});
        }
        if ("1.3.101.113".equals(this.signatureMechanismOid) && !"2.16.840.1.101.3.4.2.12".equals(this.digestAlgorithmOid)) {
            throw new PdfException("{0} requires the document to be digested using {1}, not {2}").setMessageParams(new Object[]{"Ed448", "512-bit SHAKE256", hashAlgoName});
        }
        return hashAlgoName;
    }

    public String getSignatureMechanismOid() {
        return this.signatureMechanismOid;
    }

    public String getSignatureMechanismName() {
        switch (this.signatureMechanismOid) {
            case "1.3.101.112": {
                return "Ed25519";
            }
            case "1.3.101.113": {
                return "Ed448";
            }
            case "1.2.840.113549.1.1.10": {
                return "RSASSA-PSS";
            }
        }
        return SignatureMechanisms.getMechanism(this.signatureMechanismOid, this.getDigestAlgorithmName());
    }

    public String getSignatureAlgorithmName() {
        String signAlgo = SignatureMechanisms.getAlgorithm(this.signatureMechanismOid);
        if (signAlgo == null) {
            signAlgo = this.signatureMechanismOid;
        }
        return signAlgo;
    }

    public void setExternalSignatureValue(byte[] signatureValue, byte[] signedMessageContent, String signatureAlgorithm) {
        this.setExternalSignatureValue(signatureValue, signedMessageContent, signatureAlgorithm, null);
    }

    public void setExternalSignatureValue(byte[] signatureValue, byte[] signedMessageContent, String signatureAlgorithm, ISignatureMechanismParams signatureMechanismParams) {
        this.externalSignatureValue = signatureValue;
        this.externalEncapMessageContent = signedMessageContent;
        if (signatureAlgorithm != null) {
            String digestAlgo = this.getDigestAlgorithmName();
            String oid = SignatureMechanisms.getSignatureMechanismOid(signatureAlgorithm, digestAlgo);
            if (oid == null) {
                throw new PdfException("Could not determine OID for signature algorithm {0} with digest {1}.").setMessageParams(new Object[]{signatureAlgorithm, digestAlgo});
            }
            this.signatureMechanismOid = oid;
        }
        if (signatureMechanismParams != null) {
            this.signatureMechanismParameters = signatureMechanismParams.toEncodable();
        }
    }

    private Signature initSignature(PrivateKey key) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Signature signature = SignUtils.getSignatureHelper(this.getSignatureMechanismName(), this.provider);
        signature.initSign(key);
        return signature;
    }

    private Signature initSignature(PublicKey key) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        String signatureMechanism = PdfName.Adbe_x509_rsa_sha1.equals((Object)this.getFilterSubtype()) ? "SHA1withRSA" : this.getSignatureMechanismName();
        Signature signature = SignUtils.getSignatureHelper(signatureMechanism, this.provider);
        this.configureSignatureMechanismParameters(signature);
        signature.initVerify(key);
        return signature;
    }

    private void configureSignatureMechanismParameters(Signature signature) {
        if ("1.2.840.113549.1.1.10".equals(this.signatureMechanismOid)) {
            IRSASSAPSSParams params = BOUNCY_CASTLE_FACTORY.createRSASSAPSSParams(this.signatureMechanismParameters);
            String mgfOid = params.getMaskGenAlgorithm().getAlgorithm().getId();
            if (!"1.2.840.113549.1.1.8".equals(mgfOid)) {
                throw new IllegalArgumentException("Only MGF1 is supported in RSASSA-PSS");
            }
            String mechParamDigestAlgoOid = params.getHashAlgorithm().getAlgorithm().getId();
            if (!this.digestAlgorithmOid.equals(mechParamDigestAlgoOid)) {
                throw new IllegalArgumentException(MessageFormatUtil.format((String)"Digest algorithm in RSASSA-PSS parameters is {0} while ambientdigest algorithm is {1}", (Object[])new Object[]{mechParamDigestAlgoOid, this.digestAlgorithmOid}));
            }
            IASN1Sequence mgfParams = BOUNCY_CASTLE_FACTORY.createASN1Sequence(params.getMaskGenAlgorithm().getParameters());
            String mgfParamDigestAlgoOid = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(mgfParams.getObjectAt(0)).getId();
            if (!this.digestAlgorithmOid.equals(mgfParamDigestAlgoOid)) {
                throw new IllegalArgumentException(MessageFormatUtil.format((String)"Digest algorithm in MGF1 parameters is {0} while ambient digest algorithm is {1}", (Object[])new Object[]{mgfParamDigestAlgoOid, this.digestAlgorithmOid}));
            }
            try {
                int saltLength = params.getSaltLength().intValue();
                int trailerField = params.getTrailerField().intValue();
                SignUtils.setRSASSAPSSParamsWithMGF1(signature, this.getDigestAlgorithmName(), saltLength, trailerField);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new IllegalArgumentException("Invalid parameters provided.", e);
            }
        }
    }

    public void update(byte[] buf, int off, int len) throws SignatureException {
        if (this.encapMessageContent != null || this.digestAttr != null || this.isTsp) {
            this.messageDigest.update(buf, off, len);
        } else {
            this.sig.update(buf, off, len);
        }
    }

    public byte[] getEncodedPKCS1() {
        try {
            this.signatureValue = this.externalSignatureValue != null ? this.externalSignatureValue : this.sig.sign();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            IASN1OutputStream dout = BOUNCY_CASTLE_FACTORY.createASN1OutputStream((OutputStream)bOut);
            dout.writeObject((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDEROctetString(this.signatureValue));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
    }

    public byte[] getEncodedPKCS7() {
        return this.getEncodedPKCS7(null, PdfSigner.CryptoStandard.CMS, null, null, null);
    }

    public byte[] getEncodedPKCS7(byte[] secondDigest) {
        return this.getEncodedPKCS7(secondDigest, PdfSigner.CryptoStandard.CMS, null, null, null);
    }

    public byte[] getEncodedPKCS7(byte[] secondDigest, PdfSigner.CryptoStandard sigtype, ITSAClient tsaClient, Collection<byte[]> ocsp, Collection<byte[]> crlBytes) {
        try {
            IASN1EncodableVector unauthAttributes;
            byte[] tsImprint;
            byte[] tsToken;
            if (this.externalSignatureValue != null) {
                this.signatureValue = this.externalSignatureValue;
                if (this.encapMessageContent != null) {
                    this.encapMessageContent = this.externalEncapMessageContent;
                }
            } else if (this.externalEncapMessageContent != null && this.encapMessageContent != null) {
                this.encapMessageContent = this.externalEncapMessageContent;
                this.sig.update(this.encapMessageContent);
                this.signatureValue = this.sig.sign();
            } else {
                if (this.encapMessageContent != null) {
                    this.encapMessageContent = this.messageDigest.digest();
                    this.sig.update(this.encapMessageContent);
                }
                this.signatureValue = this.sig.sign();
            }
            IASN1EncodableVector digestAlgorithms = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            for (String element : this.digestalgos) {
                IASN1EncodableVector algos = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
                algos.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(element));
                algos.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERNull());
                digestAlgorithms.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(algos));
            }
            IASN1EncodableVector v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.7.1"));
            if (this.encapMessageContent != null) {
                v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERTaggedObject(0, (IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDEROctetString(this.encapMessageContent)));
            }
            IDERSequence contentinfo = BOUNCY_CASTLE_FACTORY.createDERSequence(v);
            v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            for (Object e : this.certs) {
                IASN1InputStream tempstream = BOUNCY_CASTLE_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(BOUNCY_CASTLE_FACTORY.createX509Certificate(e).getEncoded()));
                Throwable throwable = null;
                try {
                    v.add(tempstream.readObject());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tempstream == null) continue;
                    if (throwable != null) {
                        try {
                            tempstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    tempstream.close();
                }
            }
            IDERSet dercertificates = BOUNCY_CASTLE_FACTORY.createDERSet(v);
            IDERSet iDERSet = CertificateUtil.createRevocationInfoChoices(this.signedDataCrls, this.signedDataOcsps, this.signedDataRevocationInfo);
            IASN1EncodableVector signerInfo = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            signerInfo.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1Integer(this.signerversion));
            v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            v.add(CertificateInfo.getIssuer(this.signCert.getTBSCertificate()));
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1Integer(this.signCert.getSerialNumber()));
            signerInfo.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v));
            v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(this.digestAlgorithmOid));
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERNull());
            signerInfo.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v));
            if (secondDigest != null) {
                signerInfo.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERTaggedObject(false, 0, (IASN1Primitive)this.getAuthenticatedAttributeSet(secondDigest, ocsp, crlBytes, sigtype)));
            }
            v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(this.signatureMechanismOid));
            if (this.signatureMechanismParameters == null) {
                v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERNull());
            } else {
                v.add(this.signatureMechanismParameters.toASN1Primitive());
            }
            signerInfo.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v));
            signerInfo.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDEROctetString(this.signatureValue));
            if (tsaClient != null && (tsToken = tsaClient.getTimeStampToken(tsImprint = tsaClient.getMessageDigest().digest(this.signatureValue))) != null && (unauthAttributes = this.buildUnauthenticatedAttributes(tsToken)) != null) {
                signerInfo.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERTaggedObject(false, 1, (IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSet(unauthAttributes)));
            }
            IASN1EncodableVector body = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            body.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1Integer(this.version));
            body.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSet(digestAlgorithms));
            body.add((IASN1Primitive)contentinfo);
            body.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERTaggedObject(false, 0, (IASN1Primitive)dercertificates));
            if (iDERSet != null) {
                body.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERTaggedObject(false, 1, (IASN1Primitive)iDERSet));
            }
            body.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSet((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(signerInfo)));
            IASN1EncodableVector whole = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            whole.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERTaggedObject(0, (IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(body)));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            IASN1OutputStream dout = BOUNCY_CASTLE_FACTORY.createASN1OutputStream((OutputStream)bOut);
            dout.writeObject((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(whole));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
    }

    private IASN1EncodableVector buildUnauthenticatedAttributes(byte[] timeStampToken) throws IOException {
        if (timeStampToken == null) {
            return null;
        }
        IASN1EncodableVector unauthAttributes = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
        IASN1EncodableVector v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
        v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.14"));
        try (IASN1InputStream tempstream = BOUNCY_CASTLE_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(timeStampToken));){
            IASN1Sequence seq = BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)tempstream.readObject());
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSet((IASN1Primitive)seq));
        }
        unauthAttributes.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v));
        return unauthAttributes;
    }

    public byte[] getAuthenticatedAttributeBytes(byte[] secondDigest, PdfSigner.CryptoStandard sigtype, Collection<byte[]> ocsp, Collection<byte[]> crlBytes) {
        try {
            return this.getAuthenticatedAttributeSet(secondDigest, ocsp, crlBytes, sigtype).getEncoded(BOUNCY_CASTLE_FACTORY.createASN1Encoding().getDer());
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
    }

    private IDERSet getAuthenticatedAttributeSet(byte[] secondDigest, Collection<byte[]> ocsp, Collection<byte[]> crlBytes, PdfSigner.CryptoStandard sigtype) {
        try {
            IASN1EncodableVector attribute = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            IASN1EncodableVector v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.9.3"));
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSet((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
            attribute.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v));
            v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.9.4"));
            v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSet((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDEROctetString(secondDigest)));
            attribute.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v));
            boolean haveCrl = false;
            if (crlBytes != null) {
                for (byte[] bCrl : crlBytes) {
                    if (bCrl == null) continue;
                    haveCrl = true;
                    break;
                }
            }
            if (ocsp != null && !ocsp.isEmpty() || haveCrl) {
                v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
                v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("1.2.840.113583.1.1.8"));
                IASN1EncodableVector revocationV = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
                if (haveCrl) {
                    IASN1EncodableVector v2 = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
                    for (byte[] bCrl : crlBytes) {
                        if (bCrl == null) continue;
                        IASN1InputStream t = BOUNCY_CASTLE_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(bCrl));
                        Throwable throwable = null;
                        try {
                            v2.add(t.readObject());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (t == null) continue;
                            if (throwable != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            t.close();
                        }
                    }
                    revocationV.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERTaggedObject(true, 0, (IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v2)));
                }
                if (ocsp != null && !ocsp.isEmpty()) {
                    IASN1EncodableVector vo1 = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
                    for (byte[] ocspBytes : ocsp) {
                        IDEROctetString doctet = BOUNCY_CASTLE_FACTORY.createDEROctetString(ocspBytes);
                        IASN1EncodableVector v2 = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
                        IOCSPObjectIdentifiers objectIdentifiers = BOUNCY_CASTLE_FACTORY.createOCSPObjectIdentifiers();
                        v2.add((IASN1Primitive)objectIdentifiers.getIdPkixOcspBasic());
                        v2.add((IASN1Primitive)doctet);
                        IASN1Enumerated den = BOUNCY_CASTLE_FACTORY.createASN1Enumerated(0);
                        IASN1EncodableVector v3 = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
                        v3.add((IASN1Primitive)den);
                        v3.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERTaggedObject(true, 0, (IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v2)));
                        vo1.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v3));
                    }
                    revocationV.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERTaggedObject(true, 1, (IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(vo1)));
                }
                v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSet((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(revocationV)));
                attribute.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v));
            }
            if (sigtype == PdfSigner.CryptoStandard.CADES) {
                v = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
                v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.47"));
                IASN1EncodableVector aaV2 = BOUNCY_CASTLE_FACTORY.createASN1EncodableVector();
                if (!"2.16.840.1.101.3.4.2.1".equals(this.digestAlgorithmOid)) {
                    IAlgorithmIdentifier algoId = BOUNCY_CASTLE_FACTORY.createAlgorithmIdentifier(BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(this.digestAlgorithmOid));
                    aaV2.add(algoId);
                }
                MessageDigest md = SignUtils.getMessageDigest(this.getDigestAlgorithmName(), this.interfaceDigest);
                byte[] dig = md.digest(this.signCert.getEncoded());
                aaV2.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDEROctetString(dig));
                v.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSet((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(aaV2)))));
                attribute.add((IASN1Primitive)BOUNCY_CASTLE_FACTORY.createDERSequence(v));
            }
            if (this.signaturePolicyIdentifier != null) {
                IPKCSObjectIdentifiers ipkcsObjectIdentifiers = BOUNCY_CASTLE_FACTORY.createPKCSObjectIdentifiers();
                IAttribute attr = BOUNCY_CASTLE_FACTORY.createAttribute(ipkcsObjectIdentifiers.getIdAaEtsSigPolicyId(), (IASN1Set)BOUNCY_CASTLE_FACTORY.createDERSet(this.signaturePolicyIdentifier));
                attribute.add(attr);
            }
            return BOUNCY_CASTLE_FACTORY.createDERSet(attribute);
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
    }

    public boolean verifySignatureIntegrityAndAuthenticity() throws GeneralSecurityException {
        if (this.verified) {
            return this.verifyResult;
        }
        if (this.isTsp) {
            IMessageImprint imprint = this.timeStampTokenInfo.getMessageImprint();
            byte[] md = this.messageDigest.digest();
            byte[] imphashed = imprint.getHashedMessage();
            this.verifyResult = Arrays.equals(md, imphashed);
        } else if (this.sigAttr != null || this.sigAttrDer != null) {
            boolean absentEncContDigestCompare;
            byte[] msgDigestBytes = this.messageDigest.digest();
            boolean verifySignedMessageContent = true;
            boolean encContDigestCompare = false;
            if (this.encapMessageContent != null) {
                verifySignedMessageContent = Arrays.equals(msgDigestBytes, this.encapMessageContent);
                this.encContDigest.update(this.encapMessageContent);
                encContDigestCompare = Arrays.equals(this.encContDigest.digest(), this.digestAttr);
            }
            boolean concludingDigestCompare = (absentEncContDigestCompare = Arrays.equals(msgDigestBytes, this.digestAttr)) || encContDigestCompare;
            boolean sigVerify = this.verifySigAttributes(this.sigAttr) || this.verifySigAttributes(this.sigAttrDer);
            this.verifyResult = concludingDigestCompare && sigVerify && verifySignedMessageContent;
        } else {
            if (this.encapMessageContent != null) {
                SignUtils.updateVerifier(this.sig, this.messageDigest.digest());
            }
            this.verifyResult = this.sig.verify(this.signatureValue);
        }
        this.verified = true;
        return this.verifyResult;
    }

    private boolean verifySigAttributes(byte[] attr) throws GeneralSecurityException {
        Signature signature = this.initSignature(this.signCert.getPublicKey());
        SignUtils.updateVerifier(signature, attr);
        return signature.verify(this.signatureValue);
    }

    public boolean verifyTimestampImprint() throws GeneralSecurityException {
        if (this.timeStampTokenInfo == null) {
            return false;
        }
        IMessageImprint imprint = this.timeStampTokenInfo.getMessageImprint();
        String algOID = imprint.getHashAlgorithm().getAlgorithm().getId();
        byte[] md = SignUtils.getMessageDigest(DigestAlgorithms.getDigest(algOID)).digest(this.signatureValue);
        byte[] imphashed = imprint.getHashedMessage();
        return Arrays.equals(md, imphashed);
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new Certificate[0]);
    }

    public Certificate[] getTimestampCertificates() {
        return this.timestampCerts.toArray(new Certificate[0]);
    }

    public Certificate[] getSignCertificateChain() {
        return this.signCerts.toArray(new Certificate[0]);
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    private void signCertificateChain() {
        ArrayList<Certificate> cc = new ArrayList<Certificate>();
        cc.add(this.signCert);
        ArrayList<Certificate> oc = new ArrayList<Certificate>(this.certs);
        for (int k = 0; k < oc.size(); ++k) {
            if (!this.signCert.equals(oc.get(k))) continue;
            oc.remove(k);
            --k;
        }
        boolean found = true;
        block1: while (found) {
            X509Certificate v = (X509Certificate)cc.get(cc.size() - 1);
            found = false;
            for (int k = 0; k < oc.size(); ++k) {
                X509Certificate issuer = (X509Certificate)oc.get(k);
                if (!SignUtils.verifyCertificateSignature(v, issuer.getPublicKey(), this.provider)) continue;
                found = true;
                cc.add((Certificate)oc.get(k));
                oc.remove(k);
                continue block1;
            }
        }
        this.signCerts = cc;
    }

    public Collection<CRL> getCRLs() {
        return this.crls;
    }

    public Collection<CRL> getSignedDataCRLs() {
        return this.signedDataCrls;
    }

    void findCRL(IASN1Sequence seq) {
        try {
            this.crls = new ArrayList<CRL>();
            for (int k = 0; k < seq.size(); ++k) {
                ByteArrayInputStream ar = new ByteArrayInputStream(seq.getObjectAt(k).toASN1Primitive().getEncoded(BOUNCY_CASTLE_FACTORY.createASN1Encoding().getDer()));
                X509CRL crl = (X509CRL)SignUtils.parseCrlFromStream(ar);
                this.crls.add(crl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Collection<IBasicOCSPResponse> getSignedDataOcsps() {
        return this.signedDataOcsps;
    }

    public IBasicOCSPResponse getOcsp() {
        return this.basicResp;
    }

    public boolean isRevocationValid() {
        if (this.basicResp == null) {
            return false;
        }
        if (this.signCerts.size() < 2) {
            return false;
        }
        try {
            Certificate[] cs = this.getSignCertificateChain();
            ISingleResp sr = BOUNCY_CASTLE_FACTORY.createSingleResp(this.basicResp);
            ICertificateID cid = sr.getCertID();
            X509Certificate sigcer = this.getSigningCertificate();
            X509Certificate isscer = (X509Certificate)cs[1];
            ICertificateID tis = SignUtils.generateCertificateId(isscer, sigcer.getSerialNumber(), cid.getHashAlgOID());
            return tis.equals(cid);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void findOcsp(IASN1Sequence seq) throws IOException {
        block16: {
            boolean ret;
            this.basicResp = null;
            block9: do {
                IASN1ObjectIdentifier objectIdentifier = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(seq.getObjectAt(0));
                IOCSPObjectIdentifiers ocspObjectIdentifiers = BOUNCY_CASTLE_FACTORY.createOCSPObjectIdentifiers();
                if (objectIdentifier != null && objectIdentifier.getId().equals(ocspObjectIdentifiers.getIdPkixOcspBasic().getId())) break block16;
                ret = true;
                for (int k = 0; k < seq.size(); ++k) {
                    IASN1Sequence nextSeq = BOUNCY_CASTLE_FACTORY.createASN1Sequence(seq.getObjectAt(k));
                    if (nextSeq != null) {
                        seq = nextSeq;
                        ret = false;
                        continue block9;
                    }
                    IASN1TaggedObject tag = BOUNCY_CASTLE_FACTORY.createASN1TaggedObject(seq.getObjectAt(k));
                    if (tag == null) continue;
                    nextSeq = BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)tag.getObject());
                    if (nextSeq != null) {
                        seq = nextSeq;
                        ret = false;
                        continue block9;
                    }
                    return;
                }
            } while (!ret);
            return;
        }
        IASN1OctetString os = BOUNCY_CASTLE_FACTORY.createASN1OctetString(seq.getObjectAt(1));
        try (IASN1InputStream inp = BOUNCY_CASTLE_FACTORY.createASN1InputStream(os.getOctets());){
            this.basicResp = BOUNCY_CASTLE_FACTORY.createBasicOCSPResponse(inp.readObject());
        }
    }

    public boolean isTsp() {
        return this.isTsp;
    }

    public ITSTInfo getTimeStampTokenInfo() {
        return this.timeStampTokenInfo;
    }

    public Calendar getTimeStampDate() {
        if (this.timeStampTokenInfo == null) {
            return (Calendar)TimestampConstants.UNDEFINED_TIMESTAMP_DATE;
        }
        return SignUtils.getTimeStampDate(this.timeStampTokenInfo);
    }

    public PdfName getFilterSubtype() {
        return this.filterSubtype;
    }
}

