/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.signatures.DigestAlgorithms;
import com.itextpdf.signatures.IExternalSignature;
import com.itextpdf.signatures.SignUtils;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;

public class PrivateKeySignature
implements IExternalSignature {
    private PrivateKey pk;
    private String hashAlgorithm;
    private String encryptionAlgorithm;
    private String provider;

    public PrivateKeySignature(PrivateKey pk, String hashAlgorithm, String provider) {
        this.pk = pk;
        this.provider = provider;
        this.hashAlgorithm = DigestAlgorithms.getDigest(DigestAlgorithms.getAllowedDigest(hashAlgorithm));
        this.encryptionAlgorithm = SignUtils.getPrivateKeyAlgorithm(pk);
    }

    @Override
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public byte[] sign(byte[] message) throws GeneralSecurityException {
        String algorithm = this.hashAlgorithm + "with" + this.encryptionAlgorithm;
        Signature sig = SignUtils.getSignatureHelper(algorithm, this.provider);
        sig.initSign(this.pk);
        sig.update(message);
        return sig.sign();
    }
}

