/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.OCSPVerifier;
import com.itextpdf.signatures.SignUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcspClientBouncyCastle
implements IOcspClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcspClientBouncyCastle.class);
    private final OCSPVerifier verifier;

    public OcspClientBouncyCastle(OCSPVerifier verifier) {
        this.verifier = verifier;
    }

    public BasicOCSPResp getBasicOCSPResp(X509Certificate checkCert, X509Certificate rootCert, String url) {
        try {
            OCSPResp ocspResponse = this.getOcspResponse(checkCert, rootCert, url);
            if (ocspResponse == null) {
                return null;
            }
            if (ocspResponse.getStatus() != 0) {
                return null;
            }
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
            if (this.verifier != null) {
                this.verifier.isValidResponse(basicResponse, rootCert);
            }
            return basicResponse;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
            return null;
        }
    }

    @Override
    public byte[] getEncoded(X509Certificate checkCert, X509Certificate rootCert, String url) {
        try {
            SingleResp[] responses;
            BasicOCSPResp basicResponse = this.getBasicOCSPResp(checkCert, rootCert, url);
            if (basicResponse != null && (responses = basicResponse.getResponses()).length == 1) {
                SingleResp resp = responses[0];
                CertificateStatus status = resp.getCertStatus();
                if (status == CertificateStatus.GOOD) {
                    return basicResponse.getEncoded();
                }
                if (status instanceof RevokedStatus) {
                    throw new IOException("OCSP status is revoked.");
                }
                throw new IOException("OCSP status is unknown.");
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
        }
        return null;
    }

    private static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws OCSPException, IOException, OperatorException, CertificateEncodingException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertificateID id = SignUtils.generateCertificateId(issuerCert, serialNumber, CertificateID.HASH_SHA1);
        return SignUtils.generateOcspRequestWithNonce(id);
    }

    private OCSPResp getOcspResponse(X509Certificate checkCert, X509Certificate rootCert, String url) throws GeneralSecurityException, OCSPException, IOException, OperatorException {
        if (checkCert == null || rootCert == null) {
            return null;
        }
        if (url == null) {
            url = CertificateUtil.getOCSPURL(checkCert);
        }
        if (url == null) {
            return null;
        }
        LOGGER.info("Getting OCSP from " + url);
        OCSPReq request = OcspClientBouncyCastle.generateOCSPRequest(rootCert, checkCert.getSerialNumber());
        byte[] array = request.getEncoded();
        URL urlt = new URL(url);
        InputStream in = SignUtils.getHttpResponseForOcspRequest(array, urlt);
        return new OCSPResp(StreamUtil.inputStreamToArray((InputStream)in));
    }
}

