/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.signatures.CRLVerifier;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.CertificateVerifier;
import com.itextpdf.signatures.OcspClientBouncyCastle;
import com.itextpdf.signatures.RootStoreVerifier;
import com.itextpdf.signatures.VerificationException;
import com.itextpdf.signatures.VerificationOK;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPVerifier
extends RootStoreVerifier {
    protected static final Logger LOGGER = LoggerFactory.getLogger(OCSPVerifier.class);
    protected static final String id_kp_OCSPSigning = "1.3.6.1.5.5.7.3.9";
    protected List<BasicOCSPResp> ocsps;

    public OCSPVerifier(CertificateVerifier verifier, List<BasicOCSPResp> ocsps) {
        super(verifier);
        this.ocsps = ocsps;
    }

    @Override
    public List<VerificationOK> verify(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        ArrayList<VerificationOK> result = new ArrayList<VerificationOK>();
        int validOCSPsFound = 0;
        if (this.ocsps != null) {
            for (BasicOCSPResp ocspResp : this.ocsps) {
                if (!this.verify(ocspResp, signCert, issuerCert, signDate)) continue;
                ++validOCSPsFound;
            }
        }
        boolean online = false;
        if (this.onlineCheckingAllowed && validOCSPsFound == 0 && this.verify(this.getOcspResponse(signCert, issuerCert), signCert, issuerCert, signDate)) {
            ++validOCSPsFound;
            online = true;
        }
        LOGGER.info("Valid OCSPs found: " + validOCSPsFound);
        if (validOCSPsFound > 0) {
            result.add(new VerificationOK(signCert, this.getClass(), "Valid OCSPs Found: " + validOCSPsFound + (online ? " (online)" : "")));
        }
        if (this.verifier != null) {
            result.addAll(this.verifier.verify(signCert, issuerCert, signDate));
        }
        return result;
    }

    public boolean verify(BasicOCSPResp ocspResp, X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        if (ocspResp == null) {
            return false;
        }
        SingleResp[] resp = ocspResp.getResponses();
        for (int i = 0; i < resp.length; ++i) {
            if (!signCert.getSerialNumber().equals(resp[i].getCertID().getSerialNumber())) continue;
            try {
                if (issuerCert == null) {
                    issuerCert = signCert;
                }
                if (!resp[i].getCertID().matchesIssuer(new X509CertificateHolder(issuerCert.getEncoded()), (DigestCalculatorProvider)new BcDigestCalculatorProvider())) {
                    LOGGER.info("OCSP: Issuers doesn't match.");
                }
            }
            catch (OCSPException e) {}
            continue;
            Date nextUpdate = resp[i].getNextUpdate();
            if (nextUpdate == null) {
                nextUpdate = new Date(resp[i].getThisUpdate().getTime() + 180000L);
                LOGGER.info(MessageFormat.format("No 'next update' for OCSP Response; assuming {0}", nextUpdate));
            }
            if (signDate.after(nextUpdate)) {
                LOGGER.info(MessageFormat.format("OCSP no longer valid: {0} after {1}", signDate, nextUpdate));
                continue;
            }
            CertificateStatus status = resp[i].getCertStatus();
            if (status != CertificateStatus.GOOD) continue;
            this.isValidResponse(ocspResp, issuerCert);
            return true;
        }
        return false;
    }

    public void isValidResponse(BasicOCSPResp ocspResp, X509Certificate issuerCert) throws GeneralSecurityException, IOException {
        X509Certificate responderCert = null;
        if (this.isSignatureValid(ocspResp, issuerCert)) {
            responderCert = issuerCert;
        }
        if (responderCert == null) {
            if (ocspResp.getCerts() != null) {
                X509CertificateHolder[] certs;
                for (X509CertificateHolder cert : certs = ocspResp.getCerts()) {
                    X509Certificate tempCert;
                    try {
                        tempCert = new JcaX509CertificateConverter().getCertificate(cert);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    List<String> keyPurposes = null;
                    try {
                        keyPurposes = tempCert.getExtendedKeyUsage();
                        if (keyPurposes == null || !keyPurposes.contains(id_kp_OCSPSigning) || !this.isSignatureValid(ocspResp, tempCert)) continue;
                        responderCert = tempCert;
                        break;
                    }
                    catch (CertificateParsingException certificateParsingException) {
                        // empty catch block
                    }
                }
                if (responderCert == null) {
                    throw new VerificationException(issuerCert, "OCSP response could not be verified");
                }
            } else {
                if (this.rootStore != null) {
                    try {
                        Enumeration<String> aliases = this.rootStore.aliases();
                        while (aliases.hasMoreElements()) {
                            String alias = aliases.nextElement();
                            try {
                                X509Certificate anchor;
                                if (!this.rootStore.isCertificateEntry(alias) || !this.isSignatureValid(ocspResp, anchor = (X509Certificate)this.rootStore.getCertificate(alias))) continue;
                                responderCert = anchor;
                                break;
                            }
                            catch (GeneralSecurityException generalSecurityException) {
                            }
                        }
                    }
                    catch (KeyStoreException e) {
                        responderCert = null;
                    }
                }
                if (responderCert == null) {
                    throw new VerificationException(issuerCert, "OCSP response could not be verified");
                }
            }
        }
        responderCert.verify(issuerCert.getPublicKey());
        if (responderCert.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) == null) {
            CRL crl;
            try {
                crl = CertificateUtil.getCRL(responderCert);
            }
            catch (Exception ignored) {
                crl = null;
            }
            if (crl != null && crl instanceof X509CRL) {
                CRLVerifier crlVerifier = new CRLVerifier(null, null);
                crlVerifier.setRootStore(this.rootStore);
                crlVerifier.setOnlineCheckingAllowed(this.onlineCheckingAllowed);
                crlVerifier.verify((X509CRL)crl, responderCert, issuerCert, new Date());
                return;
            }
        }
        responderCert.checkValidity();
    }

    @Deprecated
    public boolean verifyResponse(BasicOCSPResp ocspResp, X509Certificate issuerCert) {
        try {
            this.isValidResponse(ocspResp, issuerCert);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSignatureValid(BasicOCSPResp ocspResp, Certificate responderCert) {
        try {
            ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(responderCert.getPublicKey());
            return ocspResp.isSignatureValid(verifierProvider);
        }
        catch (OperatorCreationException e) {
            return false;
        }
        catch (OCSPException e) {
            return false;
        }
    }

    public BasicOCSPResp getOcspResponse(X509Certificate signCert, X509Certificate issuerCert) {
        SingleResp[] resps;
        if (signCert == null && issuerCert == null) {
            return null;
        }
        OcspClientBouncyCastle ocsp = new OcspClientBouncyCastle(null);
        BasicOCSPResp ocspResp = ocsp.getBasicOCSPResp(signCert, issuerCert, null);
        if (ocspResp == null) {
            return null;
        }
        for (SingleResp resp : resps = ocspResp.getResponses()) {
            CertificateStatus status = resp.getCertStatus();
            if (status != CertificateStatus.GOOD) continue;
            return ocspResp;
        }
        return null;
    }
}

