/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import com.itextpdf.test.LoggerHelper;
import com.itextpdf.test.annotations.LogMessage;
import com.itextpdf.test.annotations.LogMessages;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.SubstituteLoggerFactory;

public class LogListener
extends TestWatcher {
    private static final String ROOT_ITEXT_PACKAGE = "com.itextpdf";
    private final CustomListAppender<ILoggingEvent> listAppender = new CustomListAppender();
    private final ILoggerFactory lc = LoggerFactory.getILoggerFactory();
    private Map<ch.qos.logback.classic.Logger, Map<String, Appender<ILoggingEvent>>> appenders;

    protected void starting(Description description) {
        this.before(description);
    }

    protected void finished(Description description) {
        this.checkLogMessages(description);
        this.after();
    }

    private int contains(LogMessage loggingStatement) {
        List list = this.listAppender.list;
        int index = 0;
        for (ILoggingEvent event : list) {
            if (!this.isLevelCompatible(loggingStatement.logLevel(), event.getLevel()) || !LoggerHelper.equalsMessageByTemplate(event.getFormattedMessage(), loggingStatement.messageTemplate())) continue;
            ++index;
        }
        return index;
    }

    private boolean isLevelCompatible(int logMessageLevel, Level eventLevel) {
        switch (logMessageLevel) {
            case 3000: {
                return eventLevel.isGreaterOrEqual(Level.WARN);
            }
            case 2000: {
                return eventLevel == Level.ERROR;
            }
            case 1000: {
                return eventLevel == Level.WARN;
            }
            case 0: {
                return eventLevel == Level.INFO;
            }
            case -1000: {
                return eventLevel == Level.DEBUG;
            }
        }
        return false;
    }

    public int getSize() {
        return this.listAppender.list.size();
    }

    private void before(Description description) {
        this.listAppender.clear();
        LogMessages logMessages = LoggerHelper.getTestAnnotation(description, LogMessages.class);
        if (logMessages != null) {
            LogMessage[] messages;
            HashSet<String> expectedTemplates = new HashSet<String>();
            for (LogMessage logMessage : messages = logMessages.messages()) {
                expectedTemplates.add(logMessage.messageTemplate());
            }
            this.listAppender.setExpectedTemplates(expectedTemplates);
        }
        this.appenders = LoggerHelper.getAllAppendersMap((LoggerContext)this.lc);
        this.resetLoggingContext();
        this.addAppenderToPackage();
        this.listAppender.start();
    }

    private void after() {
        this.listAppender.stop();
        this.resetLoggingContext();
        LoggerHelper.restoreAppenders(this.appenders);
    }

    private void addAppenderToPackage() {
        Logger logger = LoggerFactory.getLogger((String)ROOT_ITEXT_PACKAGE);
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)logger).addAppender(this.listAppender);
        }
    }

    private void resetLoggingContext() {
        if (this.lc instanceof LoggerContext) {
            ((LoggerContext)this.lc).reset();
        } else if (this.lc instanceof SubstituteLoggerFactory) {
            ((SubstituteLoggerFactory)this.lc).clear();
        }
    }

    private void checkLogMessages(Description description) {
        LogMessages logMessages = LoggerHelper.getTestAnnotation(description, LogMessages.class);
        int checkedMessages = 0;
        if (logMessages != null) {
            LogMessage[] messages;
            for (LogMessage logMessage : messages = logMessages.messages()) {
                int foundCount = this.contains(logMessage);
                if (foundCount != logMessage.count() && !logMessages.ignore()) {
                    LoggerHelper.failWrongMessageCount(logMessage.count(), foundCount, logMessage.messageTemplate(), description);
                    continue;
                }
                checkedMessages += foundCount;
            }
        }
        if (this.getSize() > checkedMessages) {
            LoggerHelper.failWrongTotalCount(this.getSize(), checkedMessages, description);
        }
    }

    private class CustomListAppender<E>
    extends ListAppender<ILoggingEvent> {
        private Set<String> expectedTemplates = new HashSet<String>();

        private CustomListAppender() {
        }

        public void setExpectedTemplates(Set<String> expectedTemplates) {
            this.expectedTemplates.clear();
            this.expectedTemplates.addAll(expectedTemplates);
        }

        public void clear() {
            this.list.clear();
            this.expectedTemplates.clear();
        }

        protected void append(ILoggingEvent e) {
            System.out.println(e.getLoggerName() + " " + e.getLevel() + " " + e.getMessage());
            this.printStackTraceIfAny(e);
            if (e.getLevel().isGreaterOrEqual(Level.WARN) || this.isExpectedMessage(e.getMessage())) {
                this.list.add(e);
            }
        }

        private boolean isExpectedMessage(String message) {
            if (message != null) {
                for (String template : this.expectedTemplates) {
                    if (!LoggerHelper.equalsMessageByTemplate(message, template)) continue;
                    return true;
                }
            }
            return false;
        }

        private void printStackTraceIfAny(ILoggingEvent e) {
            IThrowableProxy throwableProxy = e.getThrowableProxy();
            if (throwableProxy != null) {
                System.out.println(throwableProxy.getMessage());
                for (StackTraceElementProxy el : throwableProxy.getStackTraceElementProxyArray()) {
                    System.out.println("\t" + el);
                }
            }
        }
    }
}

