/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.log.CounterManager;
import com.itextpdf.kernel.log.ICounter;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputIntent;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.XMPUtils;
import com.itextpdf.pdfa.PdfAConformanceException;
import com.itextpdf.pdfa.checker.PdfA1Checker;
import com.itextpdf.pdfa.checker.PdfA2Checker;
import com.itextpdf.pdfa.checker.PdfA3Checker;
import com.itextpdf.pdfa.checker.PdfAChecker;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfADocument
extends PdfDocument {
    private static final long serialVersionUID = -5908390625367471894L;
    protected PdfAChecker checker;

    public PdfADocument(PdfWriter writer, PdfAConformanceLevel conformanceLevel, PdfOutputIntent outputIntent) {
        this(writer, conformanceLevel, outputIntent, new DocumentProperties());
    }

    public PdfADocument(PdfWriter writer, PdfAConformanceLevel conformanceLevel, PdfOutputIntent outputIntent, DocumentProperties properties) {
        super(writer, properties);
        this.setChecker(conformanceLevel);
        this.addOutputIntent(outputIntent);
    }

    public PdfADocument(PdfReader reader, PdfWriter writer) {
        this(reader, writer, new StampingProperties());
    }

    public PdfADocument(PdfReader reader, PdfWriter writer, StampingProperties properties) {
        super(reader, writer, properties);
        XMPMeta meta;
        byte[] existingXmpMetadata = this.getXmpMetadata();
        if (existingXmpMetadata == null) {
            throw new PdfAConformanceException("Document to read from shall be a pdfa conformant file with valid xmp metadata");
        }
        try {
            meta = XMPMetaFactory.parseFromBuffer((byte[])existingXmpMetadata);
        }
        catch (XMPException exc) {
            throw new PdfAConformanceException("Document to read from shall be a pdfa conformant file with valid xmp metadata");
        }
        PdfAConformanceLevel conformanceLevel = PdfAConformanceLevel.getConformanceLevel((XMPMeta)meta);
        if (conformanceLevel == null) {
            throw new PdfAConformanceException("Document to read from shall be a pdfa conformant file with valid xmp metadata");
        }
        this.setChecker(conformanceLevel);
    }

    public void checkIsoConformance(Object obj, IsoKey key) {
        this.checkIsoConformance(obj, key, null);
    }

    public void checkIsoConformance(Object obj, IsoKey key, PdfResources resources) {
        PdfDictionary currentColorSpaces = null;
        if (resources != null) {
            currentColorSpaces = ((PdfDictionary)resources.getPdfObject()).getAsDictionary(PdfName.ColorSpace);
        }
        switch (key) {
            case CANVAS_STACK: {
                this.checker.checkCanvasStack(((Character)obj).charValue());
                break;
            }
            case PDF_OBJECT: {
                this.checker.checkPdfObject((PdfObject)obj);
                break;
            }
            case RENDERING_INTENT: {
                this.checker.checkRenderingIntent((PdfName)obj);
                break;
            }
            case INLINE_IMAGE: {
                this.checker.checkInlineImage((PdfStream)obj, currentColorSpaces);
                break;
            }
            case EXTENDED_GRAPHICS_STATE: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkExtGState(gState);
                break;
            }
            case FILL_COLOR: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkColor(gState.getFillColor(), currentColorSpaces, true);
                break;
            }
            case PAGE: {
                this.checker.checkSinglePage((PdfPage)obj);
                break;
            }
            case STROKE_COLOR: {
                CanvasGraphicsState gState = (CanvasGraphicsState)obj;
                this.checker.checkColor(gState.getStrokeColor(), currentColorSpaces, false);
                break;
            }
            case TAG_STRUCTURE_ELEMENT: {
                this.checker.checkTagStructureElement((PdfObject)obj);
            }
        }
    }

    public PdfAConformanceLevel getConformanceLevel() {
        return this.checker.getConformanceLevel();
    }

    protected void addCustomMetadataExtensions(XMPMeta xmpMeta) {
        if (this.isTagged()) {
            try {
                if (xmpMeta.getPropertyInteger("http://www.aiim.org/pdfua/ns/id/", "part") != null) {
                    XMPMeta taggedExtensionMeta = XMPMetaFactory.parseFromString((String)"    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:namespaceURI>http://www.aiim.org/pdfua/ns/id/</pdfaSchema:namespaceURI>\n                <pdfaSchema:prefix>pdfuaid</pdfaSchema:prefix>\n                <pdfaSchema:schema>PDF/UA identification schema</pdfaSchema:schema>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA version identifier</pdfaProperty:description>\n                      <pdfaProperty:name>part</pdfaProperty:name>\n                      <pdfaProperty:valueType>Integer</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA amendment identifier</pdfaProperty:description>\n                      <pdfaProperty:name>amd</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA corrigenda identifier</pdfaProperty:description>\n                      <pdfaProperty:name>corr</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>");
                    XMPUtils.appendProperties((XMPMeta)taggedExtensionMeta, (XMPMeta)xmpMeta, (boolean)true, (boolean)false);
                }
            }
            catch (XMPException exc) {
                Logger logger = LoggerFactory.getLogger(PdfADocument.class);
                logger.error("Exception while updating XmpMetadata", (Throwable)exc);
            }
        }
    }

    protected void updateXmpMetadata() {
        try {
            XMPMeta xmpMeta = this.updateDefaultXmpMetadata();
            xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", (Object)this.checker.getConformanceLevel().getPart());
            xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", (Object)this.checker.getConformanceLevel().getConformance());
            this.addCustomMetadataExtensions(xmpMeta);
            this.setXmpMetadata(xmpMeta);
        }
        catch (XMPException e) {
            Logger logger = LoggerFactory.getLogger(PdfADocument.class);
            logger.error("Exception while updating XmpMetadata", (Throwable)e);
        }
    }

    protected void checkIsoConformance() {
        this.checker.checkDocument(this.catalog);
    }

    protected void flushObject(PdfObject pdfObject, boolean canBeInObjStm) throws IOException {
        this.markObjectAsMustBeFlushed(pdfObject);
        if (this.isClosing || this.checker.objectIsChecked(pdfObject)) {
            super.flushObject(pdfObject, canBeInObjStm);
        }
    }

    protected void flushFonts() {
        for (PdfFont pdfFont : this.getDocumentFonts()) {
            this.checker.checkFont(pdfFont);
        }
        super.flushFonts();
    }

    protected void setChecker(PdfAConformanceLevel conformanceLevel) {
        switch (conformanceLevel.getPart()) {
            case "1": {
                this.checker = new PdfA1Checker(conformanceLevel);
                break;
            }
            case "2": {
                this.checker = new PdfA2Checker(conformanceLevel);
                break;
            }
            case "3": {
                this.checker = new PdfA3Checker(conformanceLevel);
            }
        }
    }

    protected void initTagStructureContext() {
        this.tagStructureContext = new TagStructureContext((PdfDocument)this, PdfADocument.getPdfVersionForPdfA(this.checker.getConformanceLevel()));
    }

    @Deprecated
    protected List<ICounter> getCounters() {
        return CounterManager.getInstance().getCounters(PdfADocument.class);
    }

    private static PdfVersion getPdfVersionForPdfA(PdfAConformanceLevel conformanceLevel) {
        PdfVersion version;
        switch (conformanceLevel.getPart()) {
            case "1": {
                version = PdfVersion.PDF_1_4;
                break;
            }
            case "2": {
                version = PdfVersion.PDF_1_7;
                break;
            }
            case "3": {
                version = PdfVersion.PDF_1_7;
                break;
            }
            default: {
                version = PdfVersion.PDF_1_4;
            }
        }
        return version;
    }
}

