/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.properties.JustifyContent;
import com.itextpdf.layout.renderer.FlexColumnItemMainDirector;
import com.itextpdf.layout.renderer.FlexUtil;
import java.util.Collections;
import java.util.List;

class BottomToTopFlexItemMainDirector
extends FlexColumnItemMainDirector {
    BottomToTopFlexItemMainDirector() {
    }

    @Override
    public <T> void applyDirectionForLine(List<T> renderers) {
        Collections.reverse(renderers);
    }

    @Override
    public void applyJustifyContent(List<FlexUtil.FlexItemCalculationInfo> line, JustifyContent justifyContent, float freeSpace) {
        if (freeSpace < 0.0f && (JustifyContent.SPACE_AROUND == justifyContent || JustifyContent.SPACE_BETWEEN == justifyContent || JustifyContent.SPACE_EVENLY == justifyContent)) {
            return;
        }
        switch (justifyContent) {
            case END: 
            case START: 
            case STRETCH: 
            case NORMAL: 
            case FLEX_START: {
                line.get((int)(line.size() - 1)).yShift = freeSpace;
                break;
            }
            case CENTER: {
                line.get((int)(line.size() - 1)).yShift = freeSpace / 2.0f;
                break;
            }
            case SPACE_BETWEEN: {
                if (line.size() == 1) {
                    line.get((int)0).yShift = freeSpace;
                    break;
                }
                float space = freeSpace / (float)(line.size() - 1);
                for (int i = 0; i < line.size() - 1; ++i) {
                    FlexUtil.FlexItemCalculationInfo item = line.get(i);
                    item.yShift = space;
                }
                break;
            }
            case SPACE_AROUND: {
                float space = freeSpace / (float)(line.size() * 2);
                for (int i = 0; i < line.size(); ++i) {
                    FlexUtil.FlexItemCalculationInfo item = line.get(i);
                    item.yShift = i == line.size() - 1 ? space : space * 2.0f;
                }
                break;
            }
            case SPACE_EVENLY: {
                float space = freeSpace / (float)(line.size() + 1);
                for (FlexUtil.FlexItemCalculationInfo item : line) {
                    item.yShift = space;
                }
                break;
            }
        }
    }
}

