/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.properties;

import com.itextpdf.kernel.colors.gradients.AbstractLinearGradientBuilder;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.properties.BackgroundBox;
import com.itextpdf.layout.properties.BackgroundPosition;
import com.itextpdf.layout.properties.BackgroundRepeat;
import com.itextpdf.layout.properties.BackgroundSize;
import com.itextpdf.layout.properties.BlendMode;
import com.itextpdf.layout.properties.UnitValue;

public class BackgroundImage {
    private static final UnitValue PERCENT_VALUE_100 = UnitValue.createPercentValue(100.0f);
    private static final float EPS = 1.0E-4f;
    private static final BlendMode DEFAULT_BLEND_MODE = BlendMode.NORMAL;
    protected PdfXObject image;
    protected AbstractLinearGradientBuilder linearGradientBuilder;
    private BlendMode blendMode = DEFAULT_BLEND_MODE;
    private final BackgroundRepeat repeat;
    private final BackgroundPosition position;
    private final BackgroundSize backgroundSize;
    private final BackgroundBox backgroundClip;
    private final BackgroundBox backgroundOrigin;

    public BackgroundImage(BackgroundImage backgroundImage) {
        this((PdfXObject)(backgroundImage.getImage() == null ? backgroundImage.getForm() : backgroundImage.getImage()), backgroundImage.getRepeat(), backgroundImage.getBackgroundPosition(), backgroundImage.getBackgroundSize(), backgroundImage.getLinearGradientBuilder(), backgroundImage.getBlendMode(), backgroundImage.getBackgroundClip(), backgroundImage.getBackgroundOrigin());
    }

    public PdfImageXObject getImage() {
        return this.image instanceof PdfImageXObject ? (PdfImageXObject)this.image : null;
    }

    public PdfFormXObject getForm() {
        return this.image instanceof PdfFormXObject ? (PdfFormXObject)this.image : null;
    }

    private BackgroundImage(PdfXObject image, BackgroundRepeat repeat, BackgroundPosition position, BackgroundSize backgroundSize, AbstractLinearGradientBuilder linearGradientBuilder, BlendMode blendMode, BackgroundBox clip, BackgroundBox origin) {
        this.image = image;
        this.repeat = repeat;
        this.position = position;
        this.backgroundSize = backgroundSize;
        this.linearGradientBuilder = linearGradientBuilder;
        if (blendMode != null) {
            this.blendMode = blendMode;
        }
        this.backgroundClip = clip;
        this.backgroundOrigin = origin;
    }

    public float[] calculateBackgroundImageSize(float areaWidth, float areaHeight) {
        BackgroundSize size = this.getLinearGradientBuilder() == null && this.getBackgroundSize().isSpecificSize() ? BackgroundImage.calculateBackgroundSizeForArea(this, areaWidth, areaHeight) : this.getBackgroundSize();
        UnitValue widthUV = size.getBackgroundWidthSize();
        UnitValue heightUV = size.getBackgroundHeightSize();
        if (widthUV != null && widthUV.isPercentValue()) {
            widthUV = UnitValue.createPointValue(areaWidth * widthUV.getValue() / PERCENT_VALUE_100.getValue());
        }
        if (heightUV != null && heightUV.isPercentValue()) {
            heightUV = UnitValue.createPointValue(areaHeight * heightUV.getValue() / PERCENT_VALUE_100.getValue());
        }
        Float width = widthUV != null && widthUV.getValue() >= 0.0f ? Float.valueOf(widthUV.getValue()) : null;
        Float height = heightUV != null && heightUV.getValue() >= 0.0f ? Float.valueOf(heightUV.getValue()) : null;
        return this.resolveWidthAndHeight(width, height, areaWidth, areaHeight);
    }

    public BackgroundPosition getBackgroundPosition() {
        return this.position;
    }

    public AbstractLinearGradientBuilder getLinearGradientBuilder() {
        return this.linearGradientBuilder;
    }

    public boolean isBackgroundSpecified() {
        return this.image instanceof PdfFormXObject || this.image instanceof PdfImageXObject || this.linearGradientBuilder != null;
    }

    public BackgroundSize getBackgroundSize() {
        return this.backgroundSize;
    }

    public float getImageWidth() {
        return this.image.getWidth();
    }

    public float getImageHeight() {
        return this.image.getHeight();
    }

    public BackgroundRepeat getRepeat() {
        return this.repeat;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public BackgroundBox getBackgroundClip() {
        return this.backgroundClip;
    }

    public BackgroundBox getBackgroundOrigin() {
        return this.backgroundOrigin;
    }

    protected float[] resolveWidthAndHeight(Float width, Float height, float areaWidth, float areaHeight) {
        float difference;
        boolean isGradient = this.getLinearGradientBuilder() != null;
        Float[] widthAndHeight = new Float[2];
        if (width != null) {
            widthAndHeight[0] = width;
            if (!isGradient && height == null) {
                difference = this.getImageWidth() < 1.0E-4f ? 1.0f : width.floatValue() / this.getImageWidth();
                widthAndHeight[1] = Float.valueOf(this.getImageHeight() * difference);
            }
        }
        if (height != null) {
            widthAndHeight[1] = height;
            if (!isGradient && width == null) {
                difference = this.getImageHeight() < 1.0E-4f ? 1.0f : height.floatValue() / this.getImageHeight();
                widthAndHeight[0] = Float.valueOf(this.getImageWidth() * difference);
            }
        }
        if (widthAndHeight[0] == null) {
            widthAndHeight[0] = Float.valueOf(isGradient ? areaWidth : this.getImageWidth());
        }
        if (widthAndHeight[1] == null) {
            widthAndHeight[1] = Float.valueOf(isGradient ? areaHeight : this.getImageHeight());
        }
        return new float[]{widthAndHeight[0].floatValue(), widthAndHeight[1].floatValue()};
    }

    private static BackgroundSize calculateBackgroundSizeForArea(BackgroundImage image, float areaWidth, float areaHeight) {
        double widthDifference = areaWidth / image.getImageWidth();
        double heightDifference = areaHeight / image.getImageHeight();
        if (image.getBackgroundSize().isCover()) {
            return BackgroundImage.createBackgroundSizeWithMaxValueSide(widthDifference > heightDifference);
        }
        if (image.getBackgroundSize().isContain()) {
            return BackgroundImage.createBackgroundSizeWithMaxValueSide(widthDifference < heightDifference);
        }
        return new BackgroundSize();
    }

    private static BackgroundSize createBackgroundSizeWithMaxValueSide(boolean maxWidth) {
        BackgroundSize size = new BackgroundSize();
        if (maxWidth) {
            size.setBackgroundSizeToValues(PERCENT_VALUE_100, null);
        } else {
            size.setBackgroundSizeToValues(null, PERCENT_VALUE_100);
        }
        return size;
    }

    static /* synthetic */ BlendMode access$000() {
        return DEFAULT_BLEND_MODE;
    }

    public static class Builder {
        private PdfXObject image;
        private AbstractLinearGradientBuilder linearGradientBuilder;
        private BackgroundPosition position = new BackgroundPosition();
        private BackgroundRepeat repeat = new BackgroundRepeat();
        private BlendMode blendMode = BackgroundImage.access$000();
        private BackgroundSize backgroundSize = new BackgroundSize();
        private BackgroundBox clip = BackgroundBox.BORDER_BOX;
        private BackgroundBox origin = BackgroundBox.PADDING_BOX;

        public Builder setImage(PdfXObject image) {
            this.image = image;
            this.linearGradientBuilder = null;
            return this;
        }

        public Builder setLinearGradientBuilder(AbstractLinearGradientBuilder linearGradientBuilder) {
            this.linearGradientBuilder = linearGradientBuilder;
            this.repeat = new BackgroundRepeat(BackgroundRepeat.BackgroundRepeatValue.NO_REPEAT);
            this.image = null;
            return this;
        }

        public Builder setBackgroundRepeat(BackgroundRepeat repeat) {
            this.repeat = repeat;
            return this;
        }

        public Builder setBackgroundPosition(BackgroundPosition position) {
            this.position = position;
            return this;
        }

        public Builder setBackgroundBlendMode(BlendMode blendMode) {
            if (blendMode != null) {
                this.blendMode = blendMode;
            }
            return this;
        }

        public Builder setBackgroundSize(BackgroundSize backgroundSize) {
            if (backgroundSize != null) {
                this.backgroundSize = backgroundSize;
            }
            return this;
        }

        public Builder setBackgroundClip(BackgroundBox clip) {
            this.clip = clip;
            return this;
        }

        public Builder setBackgroundOrigin(BackgroundBox origin) {
            this.origin = origin;
            return this;
        }

        public BackgroundImage build() {
            return new BackgroundImage(this.image, this.repeat, this.position, this.backgroundSize, this.linearGradientBuilder, this.blendMode, this.clip, this.origin);
        }
    }
}

