/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.layout.font.Range;
import java.util.ArrayList;
import java.util.List;

public class RangeBuilder {
    private static final Range fullRangeSingleton = new Range.FullRange();
    private List<Range.SubRange> ranges = new ArrayList<Range.SubRange>();

    static Range getFullRange() {
        return fullRangeSingleton;
    }

    public RangeBuilder() {
    }

    public RangeBuilder(int low, int high) {
        this.addRange(low, high);
    }

    public RangeBuilder(int n) {
        this(n, n);
    }

    public RangeBuilder(char low, char high) {
        this((int)low, (int)high);
    }

    public RangeBuilder(char ch) {
        this((int)ch);
    }

    public RangeBuilder addRange(int low, int high) {
        if (high < low) {
            throw new IllegalArgumentException("'from' shall be less than 'to'");
        }
        this.ranges.add(new Range.SubRange(low, high));
        return this;
    }

    public RangeBuilder addRange(char low, char high) {
        return this.addRange((int)low, (int)high);
    }

    public RangeBuilder addRange(int n) {
        return this.addRange(n, n);
    }

    public RangeBuilder addRange(char ch) {
        return this.addRange((int)ch);
    }

    public Range create() {
        return new Range(this.ranges);
    }
}

