/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font;

import com.itextpdf.io.font.FontProgramDescriptor;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FontSelector {
    protected List<FontInfo> fonts;
    private static final int EXPECTED_FONT_IS_BOLD_AWARD = 5;
    private static final int EXPECTED_FONT_IS_NOT_BOLD_AWARD = 3;
    private static final int EXPECTED_FONT_IS_ITALIC_AWARD = 5;
    private static final int EXPECTED_FONT_IS_NOT_ITALIC_AWARD = 3;
    private static final int EXPECTED_FONT_IS_MONOSPACED_AWARD = 5;
    private static final int EXPECTED_FONT_IS_NOT_MONOSPACED_AWARD = 1;
    private static final int FULL_NAME_EQUALS_AWARD = 11;
    private static final int FONT_NAME_EQUALS_AWARD = 11;
    private static final int ALIAS_EQUALS_AWARD = 11;
    private static final int FULL_NAME_CONTAINS_AWARD = 7;
    private static final int FONT_NAME_CONTAINS_AWARD = 7;
    private static final int ALIAS_CONTAINS_AWARD = 7;
    private static final int CONTAINS_ADDITIONAL_AWARD = 3;
    private static final int EQUALS_ADDITIONAL_AWARD = 3;

    public FontSelector(Collection<FontInfo> allFonts, List<String> fontFamilies, FontCharacteristics fc) {
        this.fonts = new ArrayList<FontInfo>(allFonts);
        Collections.sort(this.fonts, this.getComparator(fontFamilies, fc));
    }

    public final FontInfo bestMatch() {
        return this.fonts.get(0);
    }

    public final Iterable<FontInfo> getFonts() {
        return this.fonts;
    }

    protected Comparator<FontInfo> getComparator(List<String> fontFamilies, FontCharacteristics fc) {
        return new PdfFontComparator(fontFamilies, fc);
    }

    private static class PdfFontComparator
    implements Comparator<FontInfo> {
        List<String> fontFamilies = new ArrayList<String>();
        List<FontCharacteristics> fontStyles = new ArrayList<FontCharacteristics>();

        PdfFontComparator(List<String> fontFamilies, FontCharacteristics fc) {
            if (fontFamilies != null && fontFamilies.size() > 0) {
                for (String fontFamily : fontFamilies) {
                    String lowercaseFontFamily = fontFamily.toLowerCase();
                    this.fontFamilies.add(lowercaseFontFamily);
                    this.fontStyles.add(PdfFontComparator.parseFontStyle(lowercaseFontFamily, fc));
                }
            } else {
                this.fontFamilies.add("");
                this.fontStyles.add(fc);
            }
        }

        @Override
        public int compare(FontInfo o1, FontInfo o2) {
            int res = 0;
            for (int i = 0; i < this.fontFamilies.size() && res == 0; ++i) {
                FontCharacteristics fc = this.fontStyles.get(i);
                String fontName = this.fontFamilies.get(i);
                if (fontName.equalsIgnoreCase("monospace")) {
                    fc.setMonospaceFlag(true);
                }
                res = PdfFontComparator.characteristicsSimilarity(fontName, fc, o2) - PdfFontComparator.characteristicsSimilarity(fontName, fc, o1);
            }
            return res;
        }

        private static FontCharacteristics parseFontStyle(String fontFamily, FontCharacteristics fc) {
            if (fc == null) {
                fc = new FontCharacteristics();
            }
            if (fc.isUndefined()) {
                if (fontFamily.contains("bold")) {
                    fc.setBoldFlag(true);
                }
                if (fontFamily.contains("italic") || fontFamily.contains("oblique")) {
                    fc.setItalicFlag(true);
                }
            }
            return fc;
        }

        private static int characteristicsSimilarity(String fontName, FontCharacteristics fc, FontInfo fontInfo) {
            boolean isFontBold = fontInfo.getDescriptor().isBold() || fontInfo.getDescriptor().getFontWeight() > 500;
            boolean isFontItalic = fontInfo.getDescriptor().isItalic() || fontInfo.getDescriptor().getItalicAngle() < 0.0f;
            boolean isFontMonospace = fontInfo.getDescriptor().isMonospace();
            int score = 0;
            if (fc.isBold()) {
                score = isFontBold ? (score += 5) : (score -= 5);
            } else if (isFontBold) {
                score -= 3;
            }
            if (fc.isItalic()) {
                score = isFontItalic ? (score += 5) : (score -= 5);
            } else if (isFontItalic) {
                score -= 3;
            }
            if (fc.isMonospace()) {
                score = isFontMonospace ? (score += 5) : (score -= 5);
            } else if (isFontMonospace) {
                --score;
            }
            if (!"".equals(fontName)) {
                FontProgramDescriptor descriptor = fontInfo.getDescriptor();
                boolean checkContains = true;
                if (fontName.equals(descriptor.getFullNameLowerCase())) {
                    score += checkContains ? 11 : 3;
                    checkContains = false;
                }
                if (fontName.equals(descriptor.getFontNameLowerCase())) {
                    score += checkContains ? 11 : 3;
                    checkContains = false;
                }
                if (fontName.equals(fontInfo.getAlias())) {
                    score += checkContains ? 11 : 3;
                    checkContains = false;
                }
                if (checkContains) {
                    boolean conditionHasBeenSatisfied = false;
                    if (descriptor.getFullNameLowerCase().contains(fontName)) {
                        score += conditionHasBeenSatisfied ? 7 : 3;
                        conditionHasBeenSatisfied = true;
                    }
                    if (descriptor.getFontNameLowerCase().contains(fontName)) {
                        score += conditionHasBeenSatisfied ? 7 : 3;
                        conditionHasBeenSatisfied = true;
                    }
                    if (null != fontInfo.getAlias() && fontInfo.getAlias().contains(fontName)) {
                        score += conditionHasBeenSatisfied ? 7 : 3;
                        conditionHasBeenSatisfied = true;
                    }
                }
            }
            return score;
        }
    }
}

