/*
    This file is part of the iText (R) project.
    Copyright (c) 1998-2023 Apryse Group NV
    Authors: Apryse Software.

    This program is offered under a commercial and under the AGPL license.
    For commercial licensing, contact us at https://itextpdf.com/sales.  For AGPL licensing, see below.

    AGPL licensing:
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package com.itextpdf.layout.property;

import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IElement;

/**
 * Interface for implementing custom symbols for lists
 */
public interface IListSymbolFactory {
    /**
     * Creates symbol.
     *
     * @param index - the positive (greater then zero) index of list item in list.
     * @param list - the {@link IPropertyContainer} with all properties of corresponding list.
     * @param listItem - the {@link IPropertyContainer} with all properties of corresponding list item.
     * @return the {@link IElement} representing symbol.
     */
    IElement createSymbol(int index, IPropertyContainer list, IPropertyContainer listItem);
}
