/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.OverflowPropertyValue;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.ILeafElementRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRenderer
extends AbstractRenderer
implements ILeafElementRenderer {
    protected Float fixedXPosition;
    protected Float fixedYPosition;
    protected float pivotY;
    protected float deltaX;
    protected float imageWidth;
    protected float imageHeight;
    float[] matrix = new float[6];
    private Float height;
    private Float width;
    private float imageItselfScaledWidth;
    private float imageItselfScaledHeight;
    private Rectangle initialOccupiedAreaBBox;
    private float rotatedDeltaX;
    private float rotatedDeltaY;

    public ImageRenderer(Image image) {
        super(image);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        boolean processOverflowY;
        LayoutArea area = layoutContext.getArea().clone();
        Rectangle layoutBox = area.getBBox().clone();
        Float retrievedWidth = this.hasProperty(77) ? this.retrieveWidth(layoutBox.getWidth()) : null;
        List<Rectangle> floatRendererAreas = layoutContext.getFloatRendererAreas();
        float clearHeightCorrection = FloatingHelper.calculateClearHeightCorrection(this, floatRendererAreas, layoutBox);
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            layoutBox.decreaseHeight(clearHeightCorrection);
            FloatingHelper.adjustFloatedBlockLayoutBox(this, layoutBox, retrievedWidth, floatRendererAreas, floatPropertyValue);
        } else {
            clearHeightCorrection = FloatingHelper.adjustLayoutBoxAccordingToFloats(floatRendererAreas, layoutBox, retrievedWidth, clearHeightCorrection, null);
        }
        this.width = retrievedWidth;
        this.height = this.retrieveHeight();
        this.applyMargins(layoutBox, false);
        Border[] borders = this.getBorders();
        this.applyBorderBox(layoutBox, borders, false);
        OverflowPropertyValue overflowX = null != this.parent ? (OverflowPropertyValue)((Object)this.parent.getProperty(103)) : OverflowPropertyValue.FIT;
        Float declaredMaxHeight = this.retrieveMaxHeight();
        OverflowPropertyValue overflowY = null == this.parent || (null == declaredMaxHeight || declaredMaxHeight.floatValue() > layoutBox.getHeight()) && !layoutContext.isClippedHeight() ? OverflowPropertyValue.FIT : (OverflowPropertyValue)((Object)this.parent.getProperty(104));
        boolean processOverflowX = null != overflowX && !OverflowPropertyValue.FIT.equals((Object)overflowX);
        boolean bl = processOverflowY = null != overflowY && !OverflowPropertyValue.FIT.equals((Object)overflowY);
        if (this.isAbsolutePosition()) {
            this.applyAbsolutePosition(layoutBox);
        }
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), 0.0f, 0.0f));
        Float angle = this.getPropertyAsFloat(55);
        Image modelElement = (Image)this.getModelElement();
        PdfXObject xObject = modelElement.getXObject();
        this.imageWidth = modelElement.getImageWidth();
        this.imageHeight = modelElement.getImageHeight();
        if (this.width == null && this.height == null) {
            this.width = Float.valueOf(this.imageWidth);
            this.height = Float.valueOf(this.width.floatValue() / this.imageWidth * this.imageHeight);
        } else if (this.width == null) {
            this.width = Float.valueOf(this.height.floatValue() / this.imageHeight * this.imageWidth);
        } else if (this.height == null) {
            this.height = Float.valueOf(this.width.floatValue() / this.imageWidth * this.imageHeight);
        }
        this.fixedXPosition = this.getPropertyAsFloat(79);
        this.fixedYPosition = this.getPropertyAsFloat(80);
        Float horizontalScaling = this.getPropertyAsFloat(29, Float.valueOf(1.0f));
        Float verticalScaling = this.getPropertyAsFloat(76, Float.valueOf(1.0f));
        AffineTransform t = new AffineTransform();
        if (xObject instanceof PdfFormXObject && this.width.floatValue() != this.imageWidth) {
            horizontalScaling = Float.valueOf(horizontalScaling.floatValue() * (this.width.floatValue() / this.imageWidth));
            verticalScaling = Float.valueOf(verticalScaling.floatValue() * (this.height.floatValue() / this.imageHeight));
        }
        if (horizontalScaling.floatValue() != 1.0f) {
            if (xObject instanceof PdfFormXObject) {
                t.scale((double)horizontalScaling.floatValue(), 1.0);
                this.width = Float.valueOf(this.imageWidth * horizontalScaling.floatValue());
            } else {
                this.width = Float.valueOf(this.width.floatValue() * horizontalScaling.floatValue());
            }
        }
        if (verticalScaling.floatValue() != 1.0f) {
            if (xObject instanceof PdfFormXObject) {
                t.scale(1.0, (double)verticalScaling.floatValue());
                this.height = Float.valueOf(this.imageHeight * verticalScaling.floatValue());
            } else {
                this.height = Float.valueOf(this.height.floatValue() * verticalScaling.floatValue());
            }
        }
        Float minWidth = this.retrieveMinWidth(layoutBox.getWidth());
        Float maxWidth = this.retrieveMaxWidth(layoutBox.getWidth());
        if (null != minWidth && this.width.floatValue() < minWidth.floatValue()) {
            this.height = Float.valueOf(this.height.floatValue() * (minWidth.floatValue() / this.width.floatValue()));
            this.width = minWidth;
        } else if (null != maxWidth && this.width.floatValue() > maxWidth.floatValue()) {
            this.height = Float.valueOf(this.height.floatValue() * (maxWidth.floatValue() / this.width.floatValue()));
            this.width = maxWidth;
        }
        Float minHeight = this.retrieveMinHeight();
        Float maxHeight = this.retrieveMaxHeight();
        Float declaredHeight = this.retrieveHeight();
        if (null != minHeight && this.height.floatValue() < minHeight.floatValue()) {
            this.width = Float.valueOf(this.width.floatValue() * (minHeight.floatValue() / this.height.floatValue()));
            this.height = minHeight;
        } else if (null != maxHeight && this.height.floatValue() > maxHeight.floatValue()) {
            this.width = Float.valueOf(this.width.floatValue() * (maxHeight.floatValue() / this.height.floatValue()));
            this.height = maxHeight;
        } else if (null != declaredHeight && !this.height.equals(declaredHeight)) {
            this.width = Float.valueOf(this.width.floatValue() * (declaredHeight.floatValue() / this.height.floatValue()));
            this.height = declaredHeight;
        }
        this.imageItselfScaledWidth = this.width.floatValue();
        this.imageItselfScaledHeight = this.height.floatValue();
        if (null == angle) {
            angle = Float.valueOf(0.0f);
        }
        t.rotate((double)angle.floatValue());
        this.initialOccupiedAreaBBox = this.getOccupiedAreaBBox().clone();
        float scaleCoef = this.adjustPositionAfterRotation(angle.floatValue(), layoutBox.getWidth(), layoutBox.getHeight());
        this.imageItselfScaledHeight *= scaleCoef;
        this.imageItselfScaledWidth *= scaleCoef;
        this.initialOccupiedAreaBBox.moveDown(this.imageItselfScaledHeight);
        this.initialOccupiedAreaBBox.setHeight(this.imageItselfScaledHeight);
        this.initialOccupiedAreaBBox.setWidth(this.imageItselfScaledWidth);
        if (xObject instanceof PdfFormXObject) {
            t.scale((double)scaleCoef, (double)scaleCoef);
        }
        this.getMatrix(t, this.imageItselfScaledWidth, this.imageItselfScaledHeight);
        boolean isPlacingForced = false;
        if (this.width.floatValue() > layoutBox.getWidth() || this.height.floatValue() > layoutBox.getHeight()) {
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) || this.width.floatValue() > layoutBox.getWidth() && processOverflowX || this.height.floatValue() > layoutBox.getHeight() && processOverflowY) {
                isPlacingForced = true;
            } else {
                this.occupiedArea.getBBox().setHeight(this.initialOccupiedAreaBBox.getHeight());
                return new MinMaxWidthLayoutResult(3, this.occupiedArea, null, this, this);
            }
        }
        this.occupiedArea.getBBox().moveDown(this.height.floatValue());
        if (borders[3] != null) {
            this.height = Float.valueOf(this.height.floatValue() + (float)Math.sin(angle.floatValue()) * borders[3].getWidth());
        }
        this.occupiedArea.getBBox().setHeight(this.height.floatValue());
        this.occupiedArea.getBBox().setWidth(this.width.floatValue());
        float leftMargin = this.getPropertyAsFloat(44).floatValue();
        float topMargin = this.getPropertyAsFloat(46).floatValue();
        if (leftMargin != 0.0f || topMargin != 0.0f) {
            this.translateImage(leftMargin, topMargin, t);
            this.getMatrix(t, this.imageItselfScaledWidth, this.imageItselfScaledHeight);
        }
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (angle.floatValue() != 0.0f) {
            this.applyRotationLayout(angle.floatValue());
        }
        float unscaledWidth = this.occupiedArea.getBBox().getWidth() / scaleCoef;
        MinMaxWidth minMaxWidth = new MinMaxWidth(0.0f, area.getBBox().getWidth(), unscaledWidth, unscaledWidth);
        UnitValue rendererWidth = (UnitValue)this.getProperty(77);
        if (rendererWidth != null && rendererWidth.isPercentValue()) {
            minMaxWidth.setChildrenMinWidth(0.0f);
            float coeff = this.imageWidth / this.retrieveWidth(area.getBBox().getWidth()).floatValue();
            minMaxWidth.setChildrenMaxWidth(unscaledWidth * coeff);
        } else {
            boolean autoScaleWidth;
            boolean autoScale = this.hasProperty(3) && (Boolean)this.getProperty(3) != false;
            boolean bl2 = autoScaleWidth = this.hasProperty(5) && (Boolean)this.getProperty(5) != false;
            if (autoScale || autoScaleWidth) {
                minMaxWidth.setChildrenMinWidth(0.0f);
            }
        }
        FloatingHelper.removeFloatsAboveRendererBottom(floatRendererAreas, this);
        LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, floatRendererAreas, layoutContext.getArea().getBBox(), clearHeightCorrection, false);
        this.applyAbsolutePositionIfNeeded(layoutContext);
        return new MinMaxWidthLayoutResult(1, editedArea, null, null, isPlacingForced ? this : null).setMinMaxWidth(minMaxWidth);
    }

    @Override
    public void draw(DrawContext drawContext) {
        if (this.occupiedArea == null) {
            Logger logger = LoggerFactory.getLogger(ImageRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Occupied area has not been initialized. {0}", (Object[])new Object[]{"Drawing won't be performed."}));
            return;
        }
        this.applyMargins(this.occupiedArea.getBBox(), false);
        this.applyBorderBox(this.occupiedArea.getBBox(), this.getBorders(), false);
        boolean isRelativePosition = this.isRelativePosition();
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        if (this.fixedYPosition == null) {
            this.fixedYPosition = Float.valueOf(this.occupiedArea.getBBox().getY() + this.pivotY);
        }
        if (this.fixedXPosition == null) {
            this.fixedXPosition = Float.valueOf(this.occupiedArea.getBBox().getX());
        }
        PdfDocument document = drawContext.getDocument();
        boolean isTagged = drawContext.isTaggingEnabled();
        boolean modelElementIsAccessible = isTagged && this.getModelElement() instanceof IAccessibleElement;
        boolean isArtifact = isTagged && !modelElementIsAccessible;
        TagTreePointer tagPointer = null;
        if (isTagged) {
            tagPointer = document.getTagStructureContext().getAutoTaggingPointer();
            if (modelElementIsAccessible) {
                IAccessibleElement accessibleElement = (IAccessibleElement)this.getModelElement();
                PdfName role = accessibleElement.getRole();
                if (role != null && !PdfName.Artifact.equals((Object)role)) {
                    tagPointer.addTag(accessibleElement);
                    PdfDictionary layoutAttributes = AccessibleAttributesApplier.getLayoutAttributes(accessibleElement.getRole(), this, tagPointer);
                    ImageRenderer.applyGeneratedAccessibleAttributes(tagPointer, layoutAttributes);
                } else {
                    modelElementIsAccessible = false;
                    if (PdfName.Artifact.equals((Object)role)) {
                        isArtifact = true;
                    }
                }
            }
        }
        this.beginTranformationIfApplied(drawContext.getCanvas());
        Float angle = this.getPropertyAsFloat(55);
        if (angle != null) {
            this.fixedXPosition = Float.valueOf(this.fixedXPosition.floatValue() + this.rotatedDeltaX);
            this.fixedYPosition = Float.valueOf(this.fixedYPosition.floatValue() - this.rotatedDeltaY);
            drawContext.getCanvas().saveState();
            this.applyConcatMatrix(drawContext, angle);
        }
        super.draw(drawContext);
        if (angle != null) {
            drawContext.getCanvas().restoreState();
        }
        PdfCanvas canvas = drawContext.getCanvas();
        if (isTagged) {
            if (isArtifact) {
                canvas.openTag((CanvasTag)new CanvasArtifact());
            } else {
                canvas.openTag(tagPointer.getTagReference());
            }
        }
        PdfXObject xObject = ((Image)this.getModelElement()).getXObject();
        this.beginElementOpacityApplying(drawContext);
        canvas.addXObject(xObject, this.matrix[0], this.matrix[1], this.matrix[2], this.matrix[3], this.fixedXPosition.floatValue() + this.deltaX, this.fixedYPosition.floatValue());
        this.endElementOpacityApplying(drawContext);
        this.endTranformationIfApplied(drawContext.getCanvas());
        if (Boolean.TRUE.equals(this.getPropertyAsBoolean(19))) {
            xObject.flush();
        }
        if (isTagged) {
            canvas.closeTag();
        }
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(true);
        }
        this.applyBorderBox(this.occupiedArea.getBBox(), this.getBorders(), true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (modelElementIsAccessible) {
            tagPointer.moveToParent();
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        return null;
    }

    @Override
    public Rectangle getBorderAreaBBox() {
        this.applyMargins(this.initialOccupiedAreaBBox, false);
        this.applyBorderBox(this.initialOccupiedAreaBBox, this.getBorders(), false);
        boolean isRelativePosition = this.isRelativePosition();
        if (isRelativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        this.applyMargins(this.initialOccupiedAreaBBox, true);
        this.applyBorderBox(this.initialOccupiedAreaBBox, true);
        return this.initialOccupiedAreaBBox;
    }

    @Override
    protected Rectangle applyPaddings(Rectangle rect, float[] paddings, boolean reverse) {
        return rect;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        super.move(dxRight, dyUp);
        if (this.initialOccupiedAreaBBox != null) {
            this.initialOccupiedAreaBBox.moveRight(dxRight);
            this.initialOccupiedAreaBBox.moveUp(dyUp);
        }
        if (this.fixedXPosition != null) {
            this.fixedXPosition = Float.valueOf(this.fixedXPosition.floatValue() + dxRight);
        }
        if (this.fixedYPosition != null) {
            this.fixedYPosition = Float.valueOf(this.fixedYPosition.floatValue() + dyUp);
        }
    }

    @Override
    protected MinMaxWidth getMinMaxWidth(float availableWidth) {
        return ((MinMaxWidthLayoutResult)this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(availableWidth, 1000000.0f))))).getMinMaxWidth();
    }

    protected ImageRenderer autoScale(LayoutArea layoutArea) {
        Rectangle area = layoutArea.getBBox().clone();
        this.applyMargins(area, false);
        this.applyBorderBox(area, false);
        float angleScaleCoef = this.imageWidth / this.width.floatValue();
        if (this.width.floatValue() > angleScaleCoef * area.getWidth()) {
            this.updateHeight(UnitValue.createPointValue(area.getWidth() / this.width.floatValue() * this.imageHeight));
            this.updateWidth(UnitValue.createPointValue(angleScaleCoef * area.getWidth()));
        }
        return this;
    }

    private void getMatrix(AffineTransform t, float imageItselfScaledWidth, float imageItselfScaledHeight) {
        t.getMatrix(this.matrix);
        PdfXObject xObject = ((Image)this.getModelElement()).getXObject();
        if (xObject instanceof PdfImageXObject) {
            this.matrix[0] = this.matrix[0] * imageItselfScaledWidth;
            this.matrix[1] = this.matrix[1] * imageItselfScaledWidth;
            this.matrix[2] = this.matrix[2] * imageItselfScaledHeight;
            this.matrix[3] = this.matrix[3] * imageItselfScaledHeight;
        }
    }

    private float adjustPositionAfterRotation(float angle, float maxWidth, float maxHeight) {
        if (angle != 0.0f) {
            AffineTransform t = AffineTransform.getRotateInstance((double)angle);
            Point p00 = t.transform(new Point(0, 0), new Point());
            Point p01 = t.transform(new Point(0.0, (double)this.height.floatValue()), new Point());
            Point p10 = t.transform(new Point((double)this.width.floatValue(), 0.0), new Point());
            Point p11 = t.transform(new Point((double)this.width.floatValue(), (double)this.height.floatValue()), new Point());
            double[] xValues = new double[]{p01.getX(), p10.getX(), p11.getX()};
            double[] yValues = new double[]{p01.getY(), p10.getY(), p11.getY()};
            double minX = p00.getX();
            double minY = p00.getY();
            double maxX = minX;
            double maxY = minY;
            for (double x : xValues) {
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
            }
            for (double y : yValues) {
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
            }
            this.height = Float.valueOf((float)(maxY - minY));
            this.width = Float.valueOf((float)(maxX - minX));
            this.pivotY = (float)(p00.getY() - minY);
            this.deltaX = -((float)minX);
        }
        float scaleCoeff = 1.0f;
        if (Boolean.TRUE.equals(this.getPropertyAsBoolean(3))) {
            if (maxWidth / this.width.floatValue() < maxHeight / this.height.floatValue()) {
                scaleCoeff = maxWidth / this.width.floatValue();
                this.height = Float.valueOf(this.height.floatValue() * (maxWidth / this.width.floatValue()));
                this.width = Float.valueOf(maxWidth);
            } else {
                scaleCoeff = maxHeight / this.height.floatValue();
                this.width = Float.valueOf(this.width.floatValue() * (maxHeight / this.height.floatValue()));
                this.height = Float.valueOf(maxHeight);
            }
        } else if (Boolean.TRUE.equals(this.getPropertyAsBoolean(5))) {
            scaleCoeff = maxWidth / this.width.floatValue();
            this.height = Float.valueOf(this.height.floatValue() * scaleCoeff);
            this.width = Float.valueOf(maxWidth);
        } else if (Boolean.TRUE.equals(this.getPropertyAsBoolean(4))) {
            scaleCoeff = maxHeight / this.height.floatValue();
            this.height = Float.valueOf(maxHeight);
            this.width = Float.valueOf(this.width.floatValue() * scaleCoeff);
        }
        this.pivotY *= scaleCoeff;
        this.deltaX *= scaleCoeff;
        return scaleCoeff;
    }

    private void translateImage(float xDistance, float yDistance, AffineTransform t) {
        t.translate((double)xDistance, (double)yDistance);
        t.getMatrix(this.matrix);
        if (this.fixedXPosition != null) {
            this.fixedXPosition = Float.valueOf(this.fixedXPosition.floatValue() + (float)t.getTranslateX());
        }
        if (this.fixedYPosition != null) {
            this.fixedYPosition = Float.valueOf(this.fixedYPosition.floatValue() + (float)t.getTranslateY());
        }
    }

    private void applyConcatMatrix(DrawContext drawContext, Float angle) {
        AffineTransform rotationTransform = AffineTransform.getRotateInstance((double)angle.floatValue());
        Rectangle rect = this.getBorderAreaBBox();
        List<Point> rotatedPoints = this.transformPoints(this.rectangleToPointsList(rect), rotationTransform);
        float[] shift = this.calculateShiftToPositionBBoxOfPointsAt(rect.getX(), rect.getY() + rect.getHeight(), rotatedPoints);
        double[] matrix = new double[6];
        rotationTransform.getMatrix(matrix);
        drawContext.getCanvas().concatMatrix(matrix[0], matrix[1], matrix[2], matrix[3], (double)shift[0], (double)shift[1]);
    }

    private void applyRotationLayout(float angle) {
        double atan;
        float gip;
        float topBorderWidth;
        Border[] borders = this.getBorders();
        Rectangle rect = this.getBorderAreaBBox();
        float leftBorderWidth = borders[3] == null ? 0.0f : borders[3].getWidth();
        float rightBorderWidth = borders[1] == null ? 0.0f : borders[1].getWidth();
        float f = topBorderWidth = borders[0] == null ? 0.0f : borders[0].getWidth();
        if (leftBorderWidth != 0.0f) {
            gip = (float)Math.sqrt(Math.pow(topBorderWidth, 2.0) + Math.pow(leftBorderWidth, 2.0));
            atan = Math.atan(topBorderWidth / leftBorderWidth);
            if (angle < 0.0f) {
                atan = -atan;
            }
            this.rotatedDeltaX = Math.abs((float)((double)gip * Math.cos((double)angle - atan) - (double)leftBorderWidth));
        } else {
            this.rotatedDeltaX = 0.0f;
        }
        rect.moveRight(this.rotatedDeltaX);
        this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() + this.rotatedDeltaX);
        if (rightBorderWidth != 0.0f) {
            gip = (float)Math.sqrt(Math.pow(topBorderWidth, 2.0) + Math.pow(leftBorderWidth, 2.0));
            atan = Math.atan(rightBorderWidth / topBorderWidth);
            if (angle < 0.0f) {
                atan = -atan;
            }
            this.rotatedDeltaY = Math.abs((float)((double)gip * Math.cos((double)angle - atan) - (double)topBorderWidth));
        } else {
            this.rotatedDeltaY = 0.0f;
        }
        rect.moveDown(this.rotatedDeltaY);
        if (angle < 0.0f) {
            this.rotatedDeltaY += rightBorderWidth;
        }
        this.occupiedArea.getBBox().increaseHeight(this.rotatedDeltaY);
    }

    @Override
    public float getAscent() {
        return this.occupiedArea.getBBox().getHeight();
    }

    @Override
    public float getDescent() {
        return 0.0f;
    }
}

