/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.minmaxwidth;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.renderer.IRenderer;

public class MinMaxWidthUtils {
    private static final float eps = 0.01f;
    private static final float max = 32760.0f;

    public static float getEps() {
        return 0.01f;
    }

    public static float getMax() {
        return 32760.0f;
    }

    public static boolean isEqual(double x, double y) {
        return Math.abs(x - y) < (double)0.01f;
    }

    public static MinMaxWidth countDefaultMinMaxWidth(IRenderer renderer, float availableWidth) {
        LayoutResult result = renderer.layout(new LayoutContext(new LayoutArea(1, new Rectangle(availableWidth, 1000000.0f))));
        return result.getStatus() == 3 ? new MinMaxWidth(0.0f, availableWidth) : new MinMaxWidth(0.0f, availableWidth, 0.0f, result.getOccupiedArea().getBBox().getWidth());
    }

    public static float getBorderWidth(IPropertyContainer element) {
        Border border = (Border)element.getProperty(9);
        Border rightBorder = (Border)element.getProperty(12);
        Border leftBorder = (Border)element.getProperty(11);
        if (!element.hasOwnProperty(12)) {
            rightBorder = border;
        }
        if (!element.hasOwnProperty(11)) {
            leftBorder = border;
        }
        float rightBorderWidth = rightBorder != null ? rightBorder.getWidth() : 0.0f;
        float leftBorderWidth = leftBorder != null ? leftBorder.getWidth() : 0.0f;
        return rightBorderWidth + leftBorderWidth;
    }

    public static float getMarginsWidth(IPropertyContainer element) {
        Float rightMargin = (Float)element.getProperty(45);
        Float leftMargin = (Float)element.getProperty(44);
        float rightMarginWidth = rightMargin != null ? rightMargin.floatValue() : 0.0f;
        float leftMarginWidth = leftMargin != null ? leftMargin.floatValue() : 0.0f;
        return rightMarginWidth + leftMarginWidth;
    }

    public static float getPaddingWidth(IPropertyContainer element) {
        Float rightPadding = (Float)element.getProperty(49);
        Float leftPadding = (Float)element.getProperty(48);
        float rightPaddingWidth = rightPadding != null ? rightPadding.floatValue() : 0.0f;
        float leftPaddingWidth = leftPadding != null ? leftPadding.floatValue() : 0.0f;
        return rightPaddingWidth + leftPaddingWidth;
    }
}

