/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.VerticalAlignment;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockRenderer
extends AbstractRenderer {
    protected BlockRenderer(IElement modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        Float blockWidth;
        int pageNumber = layoutContext.getArea().getPageNumber();
        boolean isPositioned = this.isPositioned();
        Rectangle parentBBox = layoutContext.getArea().getBBox().clone();
        if (this.getProperty(55) != null || isPositioned) {
            parentBBox.moveDown(1000000.0f - parentBBox.getHeight()).setHeight(1000000.0f);
        }
        Float blockHeight = this.retrieveHeight();
        if (!this.isFixedLayout() && blockHeight != null && blockHeight.floatValue() > parentBBox.getHeight() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
            return new LayoutResult(3, null, null, this, this);
        }
        float[] margins = this.getMargins();
        this.applyMargins(parentBBox, margins, false);
        Border[] borders = this.getBorders();
        this.applyBorderBox(parentBBox, borders, false);
        if (isPositioned) {
            float x = this.getPropertyAsFloat(79).floatValue();
            float relativeX = this.isFixedLayout() ? 0.0f : parentBBox.getX();
            parentBBox.setX(relativeX + x);
        }
        if ((blockWidth = this.retrieveWidth(parentBBox.getWidth())) != null && (blockWidth.floatValue() < parentBBox.getWidth() || isPositioned)) {
            parentBBox.setWidth(blockWidth.floatValue());
        }
        float[] paddings = this.getPaddings();
        this.applyPaddings(parentBBox, paddings, false);
        List<Rectangle> areas = isPositioned ? Collections.singletonList(parentBBox) : this.initElementAreas(new LayoutArea(pageNumber, parentBBox));
        this.occupiedArea = new LayoutArea(pageNumber, new Rectangle(parentBBox.getX(), parentBBox.getY() + parentBBox.getHeight(), parentBBox.getWidth(), 0.0f));
        int currentAreaPos = 0;
        Rectangle layoutBox = areas.get(0).clone();
        IRenderer causeOfNothing = null;
        boolean anythingPlaced = false;
        for (int childPos = 0; childPos < this.childRenderers.size(); ++childPos) {
            LayoutResult result;
            IRenderer childRenderer = (IRenderer)this.childRenderers.get(childPos);
            childRenderer.setParent(this);
            while ((result = childRenderer.setParent(this).layout(new LayoutContext(new LayoutArea(pageNumber, layoutBox)))).getStatus() != 1) {
                if (result.getOccupiedArea() != null) {
                    this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), result.getOccupiedArea().getBBox()}));
                    layoutBox.setHeight(layoutBox.getHeight() - result.getOccupiedArea().getBBox().getHeight());
                }
                if (childRenderer.getOccupiedArea() != null) {
                    this.alignChildHorizontally(childRenderer, layoutBox.getWidth());
                }
                if (null == causeOfNothing && null != result.getCauseOfNothing()) {
                    causeOfNothing = result.getCauseOfNothing();
                }
                if (currentAreaPos + 1 < areas.size()) {
                    if (result.getStatus() == 2) {
                        this.childRenderers.set(childPos, result.getSplitRenderer());
                        this.childRenderers.add(childPos + 1, result.getOverflowRenderer());
                    } else {
                        this.childRenderers.set(childPos, result.getOverflowRenderer());
                        --childPos;
                    }
                    layoutBox = areas.get(++currentAreaPos).clone();
                    break;
                }
                if (result.getStatus() == 2) {
                    layoutBox.setHeight(layoutBox.getHeight() - result.getOccupiedArea().getBBox().getHeight());
                    if (currentAreaPos + 1 == areas.size()) {
                        AbstractRenderer splitRenderer = this.createSplitRenderer(2);
                        splitRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers.subList(0, childPos));
                        splitRenderer.childRenderers.add(result.getSplitRenderer());
                        splitRenderer.occupiedArea = this.occupiedArea;
                        AbstractRenderer overflowRenderer = this.createOverflowRenderer(2);
                        overflowRenderer.deleteOwnProperty(26);
                        ArrayList<IRenderer> overflowRendererChildren = new ArrayList<IRenderer>();
                        overflowRendererChildren.add(result.getOverflowRenderer());
                        overflowRendererChildren.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                        overflowRenderer.childRenderers = overflowRendererChildren;
                        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                        this.applyMargins(this.occupiedArea.getBBox(), margins, true);
                        return new LayoutResult(2, this.occupiedArea, splitRenderer, overflowRenderer, causeOfNothing);
                    }
                    this.childRenderers.set(childPos, result.getSplitRenderer());
                    this.childRenderers.add(childPos + 1, result.getOverflowRenderer());
                    layoutBox = areas.get(++currentAreaPos).clone();
                    break;
                }
                if (result.getStatus() != 3) continue;
                boolean keepTogether = this.isKeepTogether();
                int layoutResult = anythingPlaced && !keepTogether ? 2 : 3;
                AbstractRenderer splitRenderer = this.createSplitRenderer(layoutResult);
                splitRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers.subList(0, childPos));
                for (IRenderer renderer : splitRenderer.childRenderers) {
                    renderer.setParent(splitRenderer);
                }
                AbstractRenderer overflowRenderer = this.createOverflowRenderer(layoutResult);
                ArrayList<IRenderer> overflowRendererChildren = new ArrayList<IRenderer>();
                overflowRendererChildren.add(result.getOverflowRenderer());
                overflowRendererChildren.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                overflowRenderer.childRenderers = overflowRendererChildren;
                if (keepTogether) {
                    splitRenderer = null;
                    overflowRenderer.childRenderers.clear();
                    overflowRenderer.childRenderers = new ArrayList<IRenderer>(this.childRenderers);
                }
                this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
                this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
                this.applyMargins(this.occupiedArea.getBBox(), margins, true);
                if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                    return new LayoutResult(1, this.occupiedArea, null, null);
                }
                return new LayoutResult(layoutResult, this.occupiedArea, splitRenderer, overflowRenderer, 3 == layoutResult ? result.getCauseOfNothing() : null);
            }
            anythingPlaced = true;
            this.occupiedArea.setBBox(Rectangle.getCommonRectangle((Rectangle[])new Rectangle[]{this.occupiedArea.getBBox(), result.getOccupiedArea().getBBox()}));
            if (result.getStatus() == 1) {
                layoutBox.setHeight(layoutBox.getHeight() - result.getOccupiedArea().getBBox().getHeight());
                if (childRenderer.getOccupiedArea() != null) {
                    this.alignChildHorizontally(childRenderer, layoutBox.getWidth());
                }
            }
            if (null != causeOfNothing || null == result.getCauseOfNothing()) continue;
            causeOfNothing = result.getCauseOfNothing();
        }
        this.applyPaddings(this.occupiedArea.getBBox(), paddings, true);
        if (blockHeight != null && blockHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
            this.occupiedArea.getBBox().moveDown(blockHeight.floatValue() - this.occupiedArea.getBBox().getHeight()).setHeight(blockHeight.floatValue());
        }
        if (isPositioned) {
            float y = this.getPropertyAsFloat(80).floatValue();
            float relativeY = this.isFixedLayout() ? 0.0f : layoutBox.getY();
            this.move(0.0f, relativeY + y - this.occupiedArea.getBBox().getY());
        }
        this.applyBorderBox(this.occupiedArea.getBBox(), borders, true);
        this.applyMargins(this.occupiedArea.getBBox(), margins, true);
        if (this.getProperty(55) != null) {
            this.applyRotationLayout(layoutContext.getArea().getBBox().clone());
            if (this.isNotFittingLayoutArea(layoutContext.getArea()) && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                return new LayoutResult(3, this.occupiedArea, null, this, this);
            }
        }
        this.applyVerticalAlignment();
        return new LayoutResult(1, this.occupiedArea, null, null, causeOfNothing);
    }

    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        AbstractRenderer splitRenderer = (AbstractRenderer)this.getNextRenderer();
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        return splitRenderer;
    }

    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        AbstractRenderer overflowRenderer = (AbstractRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.properties = new HashMap<Integer, Object>(this.properties);
        return overflowRenderer;
    }

    @Override
    public void draw(DrawContext drawContext) {
        boolean isRelativePosition;
        PdfDocument document = drawContext.getDocument();
        this.applyDestination(document);
        this.applyAction(document);
        boolean isTagged = drawContext.isTaggingEnabled() && this.getModelElement() instanceof IAccessibleElement;
        TagTreePointer tagPointer = null;
        IAccessibleElement accessibleElement = null;
        if (isTagged) {
            accessibleElement = (IAccessibleElement)this.getModelElement();
            PdfName role = accessibleElement.getRole();
            if (role != null && !PdfName.Artifact.equals((Object)role)) {
                tagPointer = document.getTagStructureContext().getAutoTaggingPointer();
                if (!tagPointer.isElementConnectedToTag(accessibleElement)) {
                    AccessibleAttributesApplier.applyLayoutAttributes(role, this, document);
                    if (role.equals((Object)PdfName.TD)) {
                        AccessibleAttributesApplier.applyTableAttributes(this);
                    }
                    if (role.equals((Object)PdfName.List)) {
                        AccessibleAttributesApplier.applyListAttributes(this);
                    }
                }
                tagPointer.addTag(accessibleElement, true);
            } else {
                isTagged = false;
            }
        }
        if (isRelativePosition = this.isRelativePosition()) {
            this.applyAbsolutePositioningTranslation(false);
        }
        this.beginRotationIfApplied(drawContext.getCanvas());
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.drawChildren(drawContext);
        this.endRotationIfApplied(drawContext.getCanvas());
        if (isRelativePosition) {
            this.applyAbsolutePositioningTranslation(true);
        }
        if (isTagged) {
            tagPointer.moveToParent();
            if (this.isLastRendererForModelElement) {
                document.getTagStructureContext().removeElementConnectionToTag(accessibleElement);
            }
        }
        this.flushed = true;
    }

    @Override
    public Rectangle getOccupiedAreaBBox() {
        Rectangle bBox = this.occupiedArea.getBBox().clone();
        Float rotationAngle = (Float)this.getProperty(55);
        if (rotationAngle != null) {
            if (!this.hasOwnProperty(56) || !this.hasOwnProperty(56)) {
                Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
                logger.error(MessageFormat.format("Rotation was not correctly processed for {0}", this.getClass().getSimpleName()));
            } else {
                bBox.setWidth(this.getPropertyAsFloat(57).floatValue());
                bBox.setHeight(this.getPropertyAsFloat(56).floatValue());
            }
        }
        return bBox;
    }

    protected void applyVerticalAlignment() {
        VerticalAlignment verticalAlignment = (VerticalAlignment)((Object)this.getProperty(75));
        if (verticalAlignment != null && verticalAlignment != VerticalAlignment.TOP && this.childRenderers.size() > 0) {
            float deltaY = ((IRenderer)this.childRenderers.get(this.childRenderers.size() - 1)).getOccupiedArea().getBBox().getY() - this.getInnerAreaBBox().getY();
            switch (verticalAlignment) {
                case BOTTOM: {
                    for (IRenderer child : this.childRenderers) {
                        child.move(0.0f, -deltaY);
                    }
                    break;
                }
                case MIDDLE: {
                    for (IRenderer child : this.childRenderers) {
                        child.move(0.0f, -deltaY / 2.0f);
                    }
                    break;
                }
            }
        }
    }

    protected void applyRotationLayout(Rectangle layoutBox) {
        float angle = this.getPropertyAsFloat(55).floatValue();
        float x = this.occupiedArea.getBBox().getX();
        float y = this.occupiedArea.getBBox().getY();
        float height = this.occupiedArea.getBBox().getHeight();
        float width = this.occupiedArea.getBBox().getWidth();
        this.setProperty(57, Float.valueOf(width));
        this.setProperty(56, Float.valueOf(height));
        AffineTransform rotationTransform = new AffineTransform();
        if (this.isPositioned()) {
            Float rotationPointX = this.getPropertyAsFloat(58);
            Float rotationPointY = this.getPropertyAsFloat(59);
            if (rotationPointX == null || rotationPointY == null) {
                rotationPointX = Float.valueOf(x);
                rotationPointY = Float.valueOf(y);
            }
            rotationTransform.translate((double)rotationPointX.floatValue(), (double)rotationPointY.floatValue());
            rotationTransform.rotate((double)angle);
            rotationTransform.translate((double)(-rotationPointX.floatValue()), (double)(-rotationPointY.floatValue()));
            List<Point> rotatedPoints = this.transformPoints(this.rectangleToPointsList(this.occupiedArea.getBBox()), rotationTransform);
            Rectangle newBBox = this.calculateBBox(rotatedPoints);
            this.occupiedArea.getBBox().setWidth(newBBox.getWidth());
            this.occupiedArea.getBBox().setHeight(newBBox.getHeight());
            float occupiedAreaShiftX = newBBox.getX() - x;
            float occupiedAreaShiftY = newBBox.getY() - y;
            this.move(occupiedAreaShiftX, occupiedAreaShiftY);
        } else {
            rotationTransform = AffineTransform.getRotateInstance((double)angle);
            List<Point> rotatedPoints = this.transformPoints(this.rectangleToPointsList(this.occupiedArea.getBBox()), rotationTransform);
            float[] shift = this.calculateShiftToPositionBBoxOfPointsAt(x, y + height, rotatedPoints);
            for (Point point : rotatedPoints) {
                point.setLocation(point.getX() + (double)shift[0], point.getY() + (double)shift[1]);
            }
            Rectangle newBBox = this.calculateBBox(rotatedPoints);
            this.occupiedArea.getBBox().setWidth(newBBox.getWidth());
            this.occupiedArea.getBBox().setHeight(newBBox.getHeight());
            float heightDiff = height - newBBox.getHeight();
            this.move(0.0f, heightDiff);
        }
    }

    @Deprecated
    protected float[] applyRotation() {
        float[] ctm = new float[6];
        this.createRotationTransformInsideOccupiedArea().getMatrix(ctm);
        return ctm;
    }

    protected AffineTransform createRotationTransformInsideOccupiedArea() {
        Float angle = (Float)this.getProperty(55);
        AffineTransform rotationTransform = AffineTransform.getRotateInstance((double)angle.floatValue());
        Rectangle contentBox = this.getOccupiedAreaBBox();
        List<Point> rotatedContentBoxPoints = this.transformPoints(this.rectangleToPointsList(contentBox), rotationTransform);
        float[] shift = this.calculateShiftToPositionBBoxOfPointsAt(this.occupiedArea.getBBox().getLeft(), this.occupiedArea.getBBox().getTop(), rotatedContentBoxPoints);
        rotationTransform.preConcatenate(AffineTransform.getTranslateInstance((double)shift[0], (double)shift[1]));
        return rotationTransform;
    }

    protected void beginRotationIfApplied(PdfCanvas canvas) {
        Float angle = this.getPropertyAsFloat(55);
        if (angle != null) {
            if (!this.hasOwnProperty(56)) {
                Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
                logger.error(MessageFormat.format("Rotation was not correctly processed for {0}", this.getClass().getSimpleName()));
            } else {
                AffineTransform transform = this.createRotationTransformInsideOccupiedArea();
                canvas.saveState().concatMatrix(transform);
            }
        }
    }

    protected void endRotationIfApplied(PdfCanvas canvas) {
        Float angle = this.getPropertyAsFloat(55);
        if (angle != null) {
            canvas.restoreState();
        }
    }

    private float[] calculateShiftToPositionBBoxOfPointsAt(float left, float top, List<Point> points) {
        double minX = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (Point point : points) {
            minX = Math.min(point.getX(), minX);
            maxY = Math.max(point.getY(), maxY);
        }
        float dx = (float)((double)left - minX);
        float dy = (float)((double)top - maxY);
        return new float[]{dx, dy};
    }

    private List<Point> clipPolygon(List<Point> points, Point clipLineBeg, Point clipLineEnd) {
        ArrayList<Point> filteredPoints = new ArrayList<Point>();
        boolean prevOnRightSide = false;
        Point filteringPoint = points.get(0);
        if (this.checkPointSide(filteringPoint, clipLineBeg, clipLineEnd) >= 0) {
            filteredPoints.add(filteringPoint);
            prevOnRightSide = true;
        }
        Point prevPoint = filteringPoint;
        for (int i = 1; i < points.size() + 1; ++i) {
            filteringPoint = points.get(i % points.size());
            if (this.checkPointSide(filteringPoint, clipLineBeg, clipLineEnd) >= 0) {
                if (!prevOnRightSide) {
                    filteredPoints.add(this.getIntersectionPoint(prevPoint, filteringPoint, clipLineBeg, clipLineEnd));
                }
                filteredPoints.add(filteringPoint);
                prevOnRightSide = true;
            } else if (prevOnRightSide) {
                filteredPoints.add(this.getIntersectionPoint(prevPoint, filteringPoint, clipLineBeg, clipLineEnd));
            }
            prevPoint = filteringPoint;
        }
        return filteredPoints;
    }

    private int checkPointSide(Point filteredPoint, Point clipLineBeg, Point clipLineEnd) {
        double y1;
        double x2;
        double y2;
        double x1 = filteredPoint.getX() - clipLineBeg.getX();
        double sgn = x1 * (y2 = clipLineEnd.getY() - clipLineBeg.getY()) - (x2 = clipLineEnd.getX() - clipLineBeg.getX()) * (y1 = filteredPoint.getY() - clipLineBeg.getY());
        if (Math.abs(sgn) < 0.001) {
            return 0;
        }
        if (sgn > 0.0) {
            return 1;
        }
        if (sgn < 0.0) {
            return -1;
        }
        return 0;
    }

    private Point getIntersectionPoint(Point lineBeg, Point lineEnd, Point clipLineBeg, Point clipLineEnd) {
        double A1 = lineBeg.getY() - lineEnd.getY();
        double A2 = clipLineBeg.getY() - clipLineEnd.getY();
        double B1 = lineEnd.getX() - lineBeg.getX();
        double B2 = clipLineEnd.getX() - clipLineBeg.getX();
        double C1 = lineBeg.getX() * lineEnd.getY() - lineBeg.getY() * lineEnd.getX();
        double C2 = clipLineBeg.getX() * clipLineEnd.getY() - clipLineBeg.getY() * clipLineEnd.getX();
        double M = B1 * A2 - B2 * A1;
        return new Point((B2 * C1 - B1 * C2) / M, (C2 * A1 - C1 * A2) / M);
    }
}

