/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.ArrayUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.element.TabStop;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.LineLayoutResult;
import com.itextpdf.layout.layout.TextLayoutResult;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.Leading;
import com.itextpdf.layout.property.TabAlignment;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.TabRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import com.itextpdf.layout.renderer.TypographyUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;

public class LineRenderer
extends AbstractRenderer {
    protected float maxAscent;
    protected float maxDescent;
    protected byte[] levels;

    @Override
    public LineLayoutResult layout(LayoutContext layoutContext) {
        Rectangle layoutBox = layoutContext.getArea().getBBox().clone();
        this.occupiedArea = new LayoutArea(layoutContext.getArea().getPageNumber(), layoutBox.clone().moveDown(-layoutBox.getHeight()).setHeight(0.0f));
        float curWidth = 0.0f;
        this.maxAscent = 0.0f;
        this.maxDescent = 0.0f;
        int childPos = 0;
        BaseDirection baseDirection = (BaseDirection)((Object)this.getProperty(7));
        for (Object renderer : this.childRenderers) {
            if (!(renderer instanceof TextRenderer)) continue;
            ((TextRenderer)renderer).applyOtf();
            if (baseDirection != null && baseDirection != BaseDirection.NO_BIDI) continue;
            baseDirection = (BaseDirection)((Object)renderer.getOwnProperty(7));
        }
        if (this.levels == null && baseDirection != null && baseDirection != BaseDirection.NO_BIDI) {
            ArrayList<Integer> unicodeIdsLst = new ArrayList<Integer>();
            for (IRenderer child : this.childRenderers) {
                if (!(child instanceof TextRenderer)) continue;
                GlyphLine text = ((TextRenderer)child).getText();
                for (int i = text.start; i < text.end; ++i) {
                    assert (text.get(i).getChars().length > 0);
                    char unicode = text.get(i).getChars()[0];
                    unicodeIdsLst.add(Integer.valueOf(unicode));
                }
            }
            this.levels = TypographyUtils.getBidiLevels(baseDirection, ArrayUtil.toArray(unicodeIdsLst));
        }
        boolean anythingPlaced = false;
        TabStop nextTabStop = null;
        LayoutResult result = null;
        while (childPos < this.childRenderers.size()) {
            IRenderer childRenderer = (IRenderer)this.childRenderers.get(childPos);
            Rectangle bbox = new Rectangle(layoutBox.getX() + curWidth, layoutBox.getY(), layoutBox.getWidth() - curWidth, layoutBox.getHeight());
            if (childRenderer instanceof TextRenderer) {
                childRenderer.deleteOwnProperty(15);
                childRenderer.deleteOwnProperty(78);
            } else if (childRenderer instanceof TabRenderer) {
                if (nextTabStop != null) {
                    IRenderer tabRenderer = (IRenderer)this.childRenderers.get(childPos - 1);
                    tabRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox)));
                    curWidth += tabRenderer.getOccupiedArea().getBBox().getWidth();
                }
                nextTabStop = this.calculateTab(childRenderer, curWidth, layoutBox.getWidth());
                if (childPos == this.childRenderers.size() - 1) {
                    nextTabStop = null;
                }
                if (nextTabStop != null) {
                    ++childPos;
                    continue;
                }
            }
            if (!anythingPlaced && childRenderer instanceof TextRenderer) {
                ((TextRenderer)childRenderer).trimFirst();
            }
            if (nextTabStop != null && nextTabStop.getTabAlignment() == TabAlignment.ANCHOR && childRenderer instanceof TextRenderer) {
                childRenderer.setProperty(66, nextTabStop.getTabAnchor());
            }
            LayoutResult childResult = childRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox)));
            float childAscent = 0.0f;
            float childDescent = 0.0f;
            if (childRenderer instanceof TextRenderer) {
                childAscent = ((TextRenderer)childRenderer).getAscent();
                childDescent = ((TextRenderer)childRenderer).getDescent();
            } else if (childRenderer instanceof ImageRenderer) {
                childAscent = childRenderer.getOccupiedArea().getBBox().getHeight();
            }
            this.maxAscent = Math.max(this.maxAscent, childAscent);
            this.maxDescent = Math.min(this.maxDescent, childDescent);
            float maxHeight = this.maxAscent - this.maxDescent;
            if (nextTabStop != null) {
                IRenderer tabRenderer = (IRenderer)this.childRenderers.get(childPos - 1);
                float tabWidth = this.calculateTab(layoutBox, curWidth, nextTabStop, childRenderer, childResult, tabRenderer);
                tabRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox)));
                childResult.getOccupiedArea().getBBox().moveRight(tabWidth);
                if (childResult.getSplitRenderer() != null) {
                    childResult.getSplitRenderer().getOccupiedArea().getBBox().moveRight(tabWidth);
                }
                nextTabStop = null;
                curWidth += tabWidth;
            }
            this.occupiedArea.setBBox(new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight() - maxHeight, curWidth += childResult.getOccupiedArea().getBBox().getWidth(), maxHeight));
            if (childResult.getStatus() != 1) {
                LayoutResult newLayoutResult;
                LineRenderer[] split = this.split();
                split[0].childRenderers = new ArrayList(this.childRenderers.subList(0, childPos));
                boolean wordWasSplitAndItWillFitOntoNextLine = false;
                if (childResult instanceof TextLayoutResult && ((TextLayoutResult)childResult).isWordHasBeenSplit() && (newLayoutResult = childRenderer.layout(layoutContext)) instanceof TextLayoutResult && !((TextLayoutResult)newLayoutResult).isWordHasBeenSplit()) {
                    wordWasSplitAndItWillFitOntoNextLine = true;
                }
                if (wordWasSplitAndItWillFitOntoNextLine) {
                    split[1].childRenderers.add(childRenderer);
                    split[1].childRenderers.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                } else {
                    if (childResult.getStatus() == 2) {
                        split[0].addChild(childResult.getSplitRenderer());
                        anythingPlaced = true;
                    }
                    if (childResult.getStatus() == 2 && childResult.getOverflowRenderer() instanceof ImageRenderer) {
                        ((ImageRenderer)childResult.getOverflowRenderer()).autoScale(layoutContext.getArea());
                    }
                    if (null != childResult.getOverflowRenderer()) {
                        split[1].childRenderers.add(childResult.getOverflowRenderer());
                    }
                    split[1].childRenderers.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                    if (split[1].childRenderers.size() == 0) {
                        split[1] = null;
                    }
                }
                result = new LineLayoutResult(anythingPlaced ? 2 : 3, this.occupiedArea, split[0], split[1]);
                if (childResult.getStatus() != 2 || !(childResult instanceof TextLayoutResult) || !((TextLayoutResult)childResult).isSplitForcedByNewline()) break;
                ((LineLayoutResult)result).setSplitForcedByNewline(true);
                break;
            }
            anythingPlaced = true;
            ++childPos;
        }
        if (result == null) {
            result = anythingPlaced ? new LineLayoutResult(1, this.occupiedArea, null, null) : new LineLayoutResult(3, this.occupiedArea, null, this);
        }
        if (baseDirection != null && baseDirection != BaseDirection.NO_BIDI) {
            List<IRenderer> children = null;
            if (result.getStatus() == 2) {
                children = result.getSplitRenderer().getChildRenderers();
            } else if (result.getStatus() == 1) {
                children = this.getChildRenderers();
            }
            if (children != null) {
                int[] reorder;
                ArrayList<RendererGlyph> lineGlyphs = new ArrayList<RendererGlyph>();
                for (IRenderer child : children) {
                    if (!(child instanceof TextRenderer)) continue;
                    GlyphLine childLine = ((TextRenderer)child).line;
                    for (int i = childLine.start; i < childLine.end; ++i) {
                        lineGlyphs.add(new RendererGlyph(childLine.get(i), (TextRenderer)child));
                    }
                }
                byte[] lineLevels = new byte[lineGlyphs.size()];
                if (this.levels != null) {
                    System.arraycopy(this.levels, 0, lineLevels, 0, lineGlyphs.size());
                }
                if ((reorder = TypographyUtils.reorderLine(lineGlyphs, lineLevels, this.levels)) != null) {
                    children.clear();
                    int pos = 0;
                    ArrayList<int[]> reversedRanges = new ArrayList<int[]>();
                    int initialPos = 0;
                    boolean reversed = false;
                    int offset = 0;
                    while (pos < lineGlyphs.size()) {
                        ArrayList<int[]> reversedRange;
                        TextRenderer renderer = ((RendererGlyph)lineGlyphs.get((int)pos)).renderer;
                        TextRenderer newRenderer = new TextRenderer(renderer);
                        newRenderer.deleteOwnProperty(53);
                        children.add(newRenderer);
                        GlyphLine gl = ((TextRenderer)children.get((int)(children.size() - 1))).line = new GlyphLine(((TextRenderer)children.get((int)(children.size() - 1))).line);
                        ArrayList<Glyph> replacementGlyphs = new ArrayList<Glyph>();
                        while (pos < lineGlyphs.size() && ((RendererGlyph)lineGlyphs.get((int)pos)).renderer == renderer) {
                            if (pos < lineGlyphs.size() - 1) {
                                if (reorder[pos] == reorder[pos + 1] + 1) {
                                    reversed = true;
                                } else {
                                    if (reversed) {
                                        reversedRange = new ArrayList();
                                        reversedRange.add(new int[]{initialPos - offset, pos - offset});
                                        newRenderer.setProperty(53, reversedRange);
                                        reversedRanges.add(new int[]{initialPos - offset, pos - offset});
                                        reversed = false;
                                    }
                                    initialPos = pos + 1;
                                }
                            }
                            replacementGlyphs.add(((RendererGlyph)lineGlyphs.get((int)pos)).glyph);
                            ++pos;
                        }
                        if (reversed) {
                            reversedRange = new ArrayList<int[]>();
                            reversedRange.add(new int[]{initialPos - offset, pos - 1 - offset});
                            newRenderer.setProperty(53, reversedRange);
                            reversedRanges.add(new int[]{initialPos - offset, pos - 1 - offset});
                            reversed = false;
                            initialPos = pos;
                        }
                        offset = initialPos;
                        gl.setGlyphs(replacementGlyphs);
                    }
                    if (reversed) {
                        if (children.size() == 1) {
                            offset = 0;
                        }
                        ArrayList<int[]> reversedRange = new ArrayList<int[]>();
                        reversedRange.add(new int[]{initialPos - offset, pos - offset - 1});
                        ((RendererGlyph)lineGlyphs.get((int)(pos - 1))).renderer.setProperty(53, reversedRange);
                        reversedRanges.add(new int[]{initialPos - offset, pos - 1 - offset});
                    }
                    if (!reversedRanges.isEmpty() && children.size() == 1) {
                        ((RendererGlyph)lineGlyphs.get((int)0)).renderer.setProperty(53, reversedRanges);
                    }
                    float currentXPos = layoutContext.getArea().getBBox().getLeft();
                    for (IRenderer child : children) {
                        float currentWidth = ((TextRenderer)child).calculateLineWidth();
                        ((TextRenderer)child).occupiedArea.getBBox().setX(currentXPos).setWidth(currentWidth);
                        currentXPos += currentWidth;
                    }
                }
                if (result.getStatus() == 2) {
                    LineRenderer overflow = (LineRenderer)result.getOverflowRenderer();
                    if (this.levels != null) {
                        overflow.levels = new byte[this.levels.length - lineLevels.length];
                        System.arraycopy(this.levels, lineLevels.length, overflow.levels, 0, overflow.levels.length);
                    }
                }
            }
        }
        if (anythingPlaced) {
            LineRenderer processed = result.getStatus() == 1 ? this : (LineRenderer)result.getSplitRenderer();
            processed.adjustChildrenYLine().trimLast();
        }
        return result;
    }

    public float getMaxAscent() {
        return this.maxAscent;
    }

    public float getMaxDescent() {
        return this.maxDescent;
    }

    public float getYLine() {
        return this.occupiedArea.getBBox().getY() - this.maxDescent;
    }

    public float getLeadingValue(Leading leading) {
        switch (leading.getType()) {
            case 1: {
                return leading.getValue();
            }
            case 2: {
                return this.occupiedArea.getBBox().getHeight() * leading.getValue();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IRenderer getNextRenderer() {
        return new LineRenderer();
    }

    @Override
    protected Float getFirstYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    protected void justify(float width) {
        float ratio = this.getPropertyAsFloat(61).floatValue();
        float freeWidth = this.occupiedArea.getBBox().getX() + width - this.getLastChildRenderer().getOccupiedArea().getBBox().getX() - this.getLastChildRenderer().getOccupiedArea().getBBox().getWidth();
        int numberOfSpaces = this.getNumberOfSpaces();
        int baseCharsCount = this.baseCharactersCount();
        float baseFactor = freeWidth / (ratio * (float)numberOfSpaces + (1.0f - ratio) * (float)(baseCharsCount - 1));
        float wordSpacing = ratio * baseFactor;
        float characterSpacing = (1.0f - ratio) * baseFactor;
        float lastRightPos = this.occupiedArea.getBBox().getX();
        Iterator iterator = this.childRenderers.iterator();
        while (iterator.hasNext()) {
            IRenderer child = (IRenderer)iterator.next();
            float childX = child.getOccupiedArea().getBBox().getX();
            child.move(lastRightPos - childX, 0.0f);
            childX = lastRightPos;
            if (child instanceof TextRenderer) {
                float childHSCale = ((Float)child.getProperty(29)).floatValue();
                child.setProperty(15, Float.valueOf(characterSpacing / childHSCale));
                child.setProperty(78, Float.valueOf(wordSpacing / childHSCale));
                boolean isLastTextRenderer = !iterator.hasNext();
                float widthAddition = (float)(isLastTextRenderer ? ((TextRenderer)child).lineLength() - 1 : ((TextRenderer)child).lineLength()) * characterSpacing + wordSpacing * (float)((TextRenderer)child).getNumberOfSpaces();
                child.getOccupiedArea().getBBox().setWidth(child.getOccupiedArea().getBBox().getWidth() + widthAddition);
            }
            lastRightPos = childX + child.getOccupiedArea().getBBox().getWidth();
        }
        this.getOccupiedArea().getBBox().setWidth(width);
    }

    protected int getNumberOfSpaces() {
        int spaces = 0;
        for (IRenderer child : this.childRenderers) {
            if (!(child instanceof TextRenderer)) continue;
            spaces += ((TextRenderer)child).getNumberOfSpaces();
        }
        return spaces;
    }

    protected int length() {
        int length = 0;
        for (IRenderer child : this.childRenderers) {
            if (!(child instanceof TextRenderer)) continue;
            length += ((TextRenderer)child).lineLength();
        }
        return length;
    }

    protected int baseCharactersCount() {
        int count = 0;
        for (IRenderer child : this.childRenderers) {
            if (!(child instanceof TextRenderer)) continue;
            count += ((TextRenderer)child).baseCharactersCount();
        }
        return count;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.childRenderers) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    protected LineRenderer createSplitRenderer() {
        return (LineRenderer)this.getNextRenderer();
    }

    protected LineRenderer createOverflowRenderer() {
        return (LineRenderer)this.getNextRenderer();
    }

    protected LineRenderer[] split() {
        LineRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.parent = this.parent;
        splitRenderer.maxAscent = this.maxAscent;
        splitRenderer.maxDescent = this.maxDescent;
        splitRenderer.levels = this.levels;
        splitRenderer.addAllProperties(this.getOwnProperties());
        LineRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.levels = this.levels;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return new LineRenderer[]{splitRenderer, overflowRenderer};
    }

    protected LineRenderer adjustChildrenYLine() {
        float actualYLine = this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.maxAscent;
        for (IRenderer renderer : this.childRenderers) {
            if (renderer instanceof TextRenderer) {
                ((TextRenderer)renderer).moveYLineTo(actualYLine);
                continue;
            }
            if (renderer instanceof ImageRenderer) {
                renderer.getOccupiedArea().getBBox().setY(this.occupiedArea.getBBox().getY() - this.maxDescent);
                continue;
            }
            renderer.getOccupiedArea().getBBox().setY(this.occupiedArea.getBBox().getY());
        }
        return this;
    }

    protected LineRenderer trimLast() {
        IRenderer lastRenderer;
        IRenderer iRenderer = lastRenderer = this.childRenderers.size() > 0 ? (IRenderer)this.childRenderers.get(this.childRenderers.size() - 1) : null;
        if (lastRenderer instanceof TextRenderer) {
            float trimmedSpace = ((TextRenderer)lastRenderer).trimLast();
            this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() - trimmedSpace);
        }
        return this;
    }

    protected boolean containsImage() {
        for (IRenderer renderer : this.childRenderers) {
            if (!(renderer instanceof ImageRenderer)) continue;
            return true;
        }
        return false;
    }

    private IRenderer getLastChildRenderer() {
        return (IRenderer)this.childRenderers.get(this.childRenderers.size() - 1);
    }

    private TabStop getNextTabStop(float curWidth) {
        NavigableMap tabStops = (NavigableMap)this.getProperty(69);
        Map.Entry nextTabStopEntry = null;
        TabStop nextTabStop = null;
        if (tabStops != null) {
            nextTabStopEntry = tabStops.higherEntry(Float.valueOf(curWidth));
        }
        if (nextTabStopEntry != null) {
            nextTabStop = (TabStop)nextTabStopEntry.getValue();
        }
        return nextTabStop;
    }

    private TabStop calculateTab(IRenderer childRenderer, float curWidth, float lineWidth) {
        TabStop nextTabStop = this.getNextTabStop(curWidth);
        if (nextTabStop == null) {
            this.processDefaultTab(childRenderer, curWidth, lineWidth);
            return null;
        }
        childRenderer.setProperty(68, nextTabStop.getTabLeader());
        childRenderer.setProperty(77, UnitValue.createPointValue(nextTabStop.getTabPosition() - curWidth));
        childRenderer.setProperty(27, Float.valueOf(this.maxAscent - this.maxDescent));
        if (nextTabStop.getTabAlignment() == TabAlignment.LEFT) {
            return null;
        }
        return nextTabStop;
    }

    private float calculateTab(Rectangle layoutBox, float curWidth, TabStop tabStop, IRenderer nextElementRenderer, LayoutResult nextElementResult, IRenderer tabRenderer) {
        float childWidth = 0.0f;
        if (nextElementRenderer != null) {
            childWidth = nextElementRenderer.getOccupiedArea().getBBox().getWidth();
        }
        float tabWidth = 0.0f;
        switch (tabStop.getTabAlignment()) {
            case RIGHT: {
                tabWidth = tabStop.getTabPosition() - curWidth - childWidth;
                break;
            }
            case CENTER: {
                tabWidth = tabStop.getTabPosition() - curWidth - childWidth / 2.0f;
                break;
            }
            case ANCHOR: {
                float anchorPosition = -1.0f;
                if (nextElementRenderer instanceof TextRenderer) {
                    anchorPosition = ((TextRenderer)nextElementRenderer).getTabAnchorCharacterPosition();
                }
                if (anchorPosition == -1.0f) {
                    anchorPosition = childWidth;
                }
                tabWidth = tabStop.getTabPosition() - curWidth - anchorPosition;
            }
        }
        if (tabWidth < 0.0f) {
            tabWidth = 0.0f;
        }
        if (curWidth + tabWidth + childWidth > layoutBox.getWidth()) {
            tabWidth -= curWidth + childWidth + tabWidth - layoutBox.getWidth();
        }
        tabRenderer.setProperty(77, UnitValue.createPointValue(tabWidth));
        tabRenderer.setProperty(27, Float.valueOf(this.maxAscent - this.maxDescent));
        return tabWidth;
    }

    private void processDefaultTab(IRenderer tabRenderer, float curWidth, float lineWidth) {
        Float tabDefault = this.getPropertyAsFloat(67);
        Float tabWidth = Float.valueOf(tabDefault.floatValue() - curWidth % tabDefault.floatValue());
        if (curWidth + tabWidth.floatValue() > lineWidth) {
            tabWidth = Float.valueOf(lineWidth - curWidth);
        }
        tabRenderer.setProperty(77, UnitValue.createPointValue(tabWidth.floatValue()));
        tabRenderer.setProperty(27, Float.valueOf(this.maxAscent - this.maxDescent));
    }

    static class RendererGlyph {
        public Glyph glyph;
        public TextRenderer renderer;

        public RendererGlyph(Glyph glyph, TextRenderer textRenderer) {
            this.glyph = glyph;
            this.renderer = textRenderer;
        }
    }
}

