/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.filters;

import com.itextpdf.kernel.pdf.MemoryLimitsAwareFilter;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import java.io.ByteArrayOutputStream;

public class RunLengthDecodeFilter
extends MemoryLimitsAwareFilter {
    @Override
    public byte[] decode(byte[] b, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) {
        byte dupCount;
        ByteArrayOutputStream outputStream = this.enableMemoryLimitsAwareHandler(streamDictionary);
        for (int i = 0; i < b.length && (dupCount = b[i]) != -128; ++i) {
            if ((dupCount & 0x80) == 0) {
                int bytesToCopy = dupCount + 1;
                outputStream.write(b, i + 1, bytesToCopy);
                i += bytesToCopy;
                continue;
            }
            ++i;
            for (int j = 0; j < 257 - (dupCount & 0xFF); ++j) {
                outputStream.write(b[i]);
            }
        }
        return outputStream.toByteArray();
    }
}

