/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto;

import com.itextpdf.commons.utils.MessageFormatUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.bouncycastle.asn1.ASN1OutputStream;

public class CryptoUtil {
    private CryptoUtil() {
    }

    public static Certificate readPublicCertificate(InputStream is) throws CertificateException {
        return CertificateFactory.getInstance("X.509").generateCertificate(is);
    }

    public static PrivateKey readPrivateKeyFromPKCS12KeyStore(InputStream keyStore, String pkAlias, char[] pkPassword) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(keyStore, pkPassword);
        return (PrivateKey)keystore.getKey(pkAlias, pkPassword);
    }

    public static ASN1OutputStream createAsn1OutputStream(OutputStream outputStream, String asn1Encoding) {
        if (!"DER".equals(asn1Encoding) && !"BER".equals(asn1Encoding)) {
            throw new UnsupportedOperationException(MessageFormatUtil.format((String)"Unknown ASN1-encoding {0}. Only DER and BER encodings are supported!", (Object[])new Object[]{asn1Encoding}));
        }
        return ASN1OutputStream.create((OutputStream)outputStream, (String)asn1Encoding);
    }
}

