/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfEncryption;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPrimitiveObject;
import java.nio.charset.StandardCharsets;

public class PdfString
extends PdfPrimitiveObject {
    protected String value;
    protected String encoding;
    protected boolean hexWriting = false;
    private int decryptInfoNum;
    private int decryptInfoGen;
    private PdfEncryption decryption;

    public PdfString(String value, String encoding) {
        assert (value != null);
        this.value = value;
        this.encoding = encoding;
    }

    public PdfString(String value) {
        this(value, null);
    }

    public PdfString(byte[] content) {
        if (content != null && content.length > 0) {
            StringBuilder str = new StringBuilder(content.length);
            for (byte b : content) {
                str.append((char)(b & 0xFF));
            }
            this.value = str.toString();
        } else {
            this.value = "";
        }
    }

    protected PdfString(byte[] content, boolean hexWriting) {
        super(content);
        this.hexWriting = hexWriting;
    }

    private PdfString() {
    }

    @Override
    public byte getType() {
        return 10;
    }

    public boolean isHexWriting() {
        return this.hexWriting;
    }

    public PdfString setHexWriting(boolean hexWriting) {
        if (this.value == null) {
            this.generateValue();
        }
        this.content = null;
        this.hexWriting = hexWriting;
        return this;
    }

    public String getValue() {
        if (this.value == null) {
            this.generateValue();
        }
        return this.value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String toUnicodeString() {
        byte[] b;
        if (this.encoding != null && this.encoding.length() != 0) {
            return this.getValue();
        }
        if (this.content == null) {
            this.generateContent();
        }
        if ((b = this.decodeContent()).length >= 2 && b[0] == -2 && b[1] == -1) {
            return PdfEncodings.convertToString((byte[])b, (String)"UnicodeBig");
        }
        if (b.length >= 3 && b[0] == -17 && b[1] == -69 && b[2] == -65) {
            return PdfEncodings.convertToString((byte[])b, (String)"UTF-8");
        }
        return PdfEncodings.convertToString((byte[])b, (String)"PDF");
    }

    public byte[] getValueBytes() {
        if (this.value == null) {
            this.generateValue();
        }
        if (this.encoding != null && "UnicodeBig".equals(this.encoding) && PdfEncodings.isPdfDocEncoding((String)this.value)) {
            return PdfEncodings.convertToBytes((String)this.value, (String)"PDF");
        }
        return PdfEncodings.convertToBytes((String)this.value, (String)this.encoding);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfString that = (PdfString)o;
        String v1 = this.getValue();
        String v2 = that.getValue();
        if (v1 != null && v1.equals(v2)) {
            String e1 = this.getEncoding();
            String e2 = that.getEncoding();
            if (e1 == null && e2 == null || e1 != null && e1.equals(e2)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.value == null) {
            return new String(this.decodeContent(), StandardCharsets.ISO_8859_1);
        }
        return this.getValue();
    }

    public int hashCode() {
        String v = this.getValue();
        String e = this.getEncoding();
        int result = v != null ? v.hashCode() : 0;
        return 31 * result + (e != null ? e.hashCode() : 0);
    }

    public void markAsUnencryptedObject() {
        this.setState((short)512);
    }

    void setDecryption(int decryptInfoNum, int decryptInfoGen, PdfEncryption decryption) {
        this.decryptInfoNum = decryptInfoNum;
        this.decryptInfoGen = decryptInfoGen;
        this.decryption = decryption;
    }

    protected void generateValue() {
        assert (this.content != null) : "No byte[] content to generate value";
        this.value = PdfEncodings.convertToString((byte[])this.decodeContent(), null);
        if (this.decryption != null) {
            this.decryption = null;
            this.content = null;
        }
    }

    @Override
    protected void generateContent() {
        this.content = this.encodeBytes(this.getValueBytes());
    }

    protected boolean encrypt(PdfEncryption encrypt) {
        if (this.checkState((short)512)) {
            return false;
        }
        if (encrypt != this.decryption) {
            if (this.decryption != null) {
                this.generateValue();
            }
            if (encrypt != null && !encrypt.isEmbeddedFilesOnly()) {
                byte[] b = encrypt.encryptByteArray(this.getValueBytes());
                this.content = this.encodeBytes(b);
                return true;
            }
        }
        return false;
    }

    protected byte[] decodeContent() {
        byte[] decodedBytes = PdfTokenizer.decodeStringContent((byte[])this.content, (boolean)this.hexWriting);
        if (this.decryption != null && !this.checkState((short)512)) {
            this.decryption.setHashKeyForNextObject(this.decryptInfoNum, this.decryptInfoGen);
            decodedBytes = this.decryption.decryptByteArray(decodedBytes);
        }
        return decodedBytes;
    }

    protected byte[] encodeBytes(byte[] bytes) {
        if (this.hexWriting) {
            ByteBuffer buf = new ByteBuffer(bytes.length * 2);
            for (byte b : bytes) {
                buf.appendHex(b);
            }
            return buf.getInternalBuffer();
        }
        ByteBuffer buf = StreamUtil.createBufferedEscapedString((byte[])bytes);
        return buf.toByteArray(1, buf.size() - 2);
    }

    @Override
    protected PdfObject newInstance() {
        return new PdfString();
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        super.copyContent(from, document);
        PdfString string = (PdfString)from;
        this.value = string.value;
        this.hexWriting = string.hexWriting;
        this.decryption = string.decryption;
        this.decryptInfoNum = string.decryptInfoNum;
        this.decryptInfoGen = string.decryptInfoGen;
        this.encoding = string.encoding;
    }
}

