/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.listener;

import com.itextpdf.kernel.geom.LineSegment;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.parser.EventType;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.listener.DefaultTextChunkLocationComparator;
import com.itextpdf.kernel.pdf.canvas.parser.listener.ITextChunkLocation;
import com.itextpdf.kernel.pdf.canvas.parser.listener.ITextExtractionStrategy;
import com.itextpdf.kernel.pdf.canvas.parser.listener.TextChunk;
import com.itextpdf.kernel.pdf.canvas.parser.listener.TextChunkLocationBasedComparator;
import com.itextpdf.kernel.pdf.canvas.parser.listener.TextChunkLocationDefaultImp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class LocationTextExtractionStrategy
implements ITextExtractionStrategy {
    private static boolean DUMP_STATE = false;
    private final List<TextChunk> locationalResult = new ArrayList<TextChunk>();
    private final ITextChunkLocationStrategy tclStrat;
    private boolean useActualText = false;
    private boolean rightToLeftRunDirection = false;
    private TextRenderInfo lastTextRenderInfo;

    public LocationTextExtractionStrategy() {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
    }

    public LocationTextExtractionStrategy(ITextChunkLocationStrategy strat) {
        this.tclStrat = strat;
    }

    public LocationTextExtractionStrategy setUseActualText(boolean useActualText) {
        this.useActualText = useActualText;
        return this;
    }

    public LocationTextExtractionStrategy setRightToLeftRunDirection(boolean rightToLeftRunDirection) {
        this.rightToLeftRunDirection = rightToLeftRunDirection;
        return this;
    }

    public boolean isUseActualText() {
        return this.useActualText;
    }

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        if (type.equals((Object)EventType.RENDER_TEXT)) {
            TextRenderInfo renderInfo = (TextRenderInfo)data;
            LineSegment segment = renderInfo.getBaseline();
            if (renderInfo.getRise() != 0.0f) {
                Matrix riseOffsetTransform = new Matrix(0.0f, -renderInfo.getRise());
                segment = segment.transformBy(riseOffsetTransform);
            }
            if (this.useActualText) {
                CanvasTag lastTagWithActualText;
                CanvasTag canvasTag = lastTagWithActualText = this.lastTextRenderInfo != null ? this.findLastTagWithActualText(this.lastTextRenderInfo.getCanvasTagHierarchy()) : null;
                if (lastTagWithActualText != null && lastTagWithActualText == this.findLastTagWithActualText(renderInfo.getCanvasTagHierarchy())) {
                    TextChunk lastTextChunk = this.locationalResult.get(this.locationalResult.size() - 1);
                    Vector mergedStart = new Vector(Math.min(lastTextChunk.getLocation().getStartLocation().get(0), segment.getStartPoint().get(0)), Math.min(lastTextChunk.getLocation().getStartLocation().get(1), segment.getStartPoint().get(1)), Math.min(lastTextChunk.getLocation().getStartLocation().get(2), segment.getStartPoint().get(2)));
                    Vector mergedEnd = new Vector(Math.max(lastTextChunk.getLocation().getEndLocation().get(0), segment.getEndPoint().get(0)), Math.max(lastTextChunk.getLocation().getEndLocation().get(1), segment.getEndPoint().get(1)), Math.max(lastTextChunk.getLocation().getEndLocation().get(2), segment.getEndPoint().get(2)));
                    TextChunk merged = new TextChunk(lastTextChunk.getText(), this.tclStrat.createLocation(renderInfo, new LineSegment(mergedStart, mergedEnd)));
                    this.locationalResult.set(this.locationalResult.size() - 1, merged);
                } else {
                    String actualText = renderInfo.getActualText();
                    TextChunk tc = new TextChunk(actualText != null ? actualText : renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment));
                    this.locationalResult.add(tc);
                }
            } else {
                TextChunk tc = new TextChunk(renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment));
                this.locationalResult.add(tc);
            }
            this.lastTextRenderInfo = renderInfo;
        }
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return null;
    }

    @Override
    public String getResultantText() {
        if (DUMP_STATE) {
            this.dumpState();
        }
        ArrayList<TextChunk> textChunks = new ArrayList<TextChunk>(this.locationalResult);
        this.sortWithMarks(textChunks);
        StringBuilder sb = new StringBuilder();
        TextChunk lastChunk = null;
        for (TextChunk chunk : textChunks) {
            if (lastChunk == null) {
                sb.append(chunk.text);
            } else if (chunk.sameLine(lastChunk)) {
                if (this.isChunkAtWordBoundary(chunk, lastChunk) && !this.startsWithSpace(chunk.text) && !this.endsWithSpace(lastChunk.text)) {
                    sb.append(' ');
                }
                sb.append(chunk.text);
            } else {
                sb.append('\n');
                sb.append(chunk.text);
            }
            lastChunk = chunk;
        }
        return sb.toString();
    }

    protected boolean isChunkAtWordBoundary(TextChunk chunk, TextChunk previousChunk) {
        return chunk.getLocation().isAtWordBoundary(previousChunk.getLocation());
    }

    private boolean startsWithSpace(String str) {
        return str.length() != 0 && str.charAt(0) == ' ';
    }

    private boolean endsWithSpace(String str) {
        return str.length() != 0 && str.charAt(str.length() - 1) == ' ';
    }

    private void dumpState() {
        for (TextChunk location : this.locationalResult) {
            location.printDiagnostics();
            System.out.println();
        }
    }

    private CanvasTag findLastTagWithActualText(List<CanvasTag> canvasTagHierarchy) {
        CanvasTag lastActualText = null;
        for (CanvasTag tag : canvasTagHierarchy) {
            if (tag.getActualText() == null) continue;
            lastActualText = tag;
            break;
        }
        return lastActualText;
    }

    private void sortWithMarks(List<TextChunk> textChunks) {
        HashMap<TextChunk, TextChunkMarks> marks = new HashMap<TextChunk, TextChunkMarks>();
        ArrayList<TextChunk> toSort = new ArrayList<TextChunk>();
        for (int markInd = 0; markInd < textChunks.size(); ++markInd) {
            ITextChunkLocation location = textChunks.get(markInd).getLocation();
            if (location.getStartLocation().equals(location.getEndLocation())) {
                boolean foundBaseToAttachTo = false;
                for (int baseInd = 0; baseInd < textChunks.size(); ++baseInd) {
                    ITextChunkLocation baseLocation;
                    if (markInd == baseInd || (baseLocation = textChunks.get(baseInd).getLocation()).getStartLocation().equals(baseLocation.getEndLocation()) || !TextChunkLocationDefaultImp.containsMark(baseLocation, location)) continue;
                    TextChunkMarks currentMarks = (TextChunkMarks)marks.get(textChunks.get(baseInd));
                    if (currentMarks == null) {
                        currentMarks = new TextChunkMarks();
                        marks.put(textChunks.get(baseInd), currentMarks);
                    }
                    if (markInd < baseInd) {
                        currentMarks.preceding.add(textChunks.get(markInd));
                    } else {
                        currentMarks.succeeding.add(textChunks.get(markInd));
                    }
                    foundBaseToAttachTo = true;
                    break;
                }
                if (foundBaseToAttachTo) continue;
                toSort.add(textChunks.get(markInd));
                continue;
            }
            toSort.add(textChunks.get(markInd));
        }
        Collections.sort(toSort, new TextChunkLocationBasedComparator(new DefaultTextChunkLocationComparator(!this.rightToLeftRunDirection)));
        textChunks.clear();
        for (TextChunk current : toSort) {
            int j;
            TextChunkMarks currentMarks = (TextChunkMarks)marks.get(current);
            if (currentMarks != null) {
                if (!this.rightToLeftRunDirection) {
                    for (j = 0; j < currentMarks.preceding.size(); ++j) {
                        textChunks.add(currentMarks.preceding.get(j));
                    }
                } else {
                    for (j = currentMarks.succeeding.size() - 1; j >= 0; --j) {
                        textChunks.add(currentMarks.succeeding.get(j));
                    }
                }
            }
            textChunks.add(current);
            if (currentMarks == null) continue;
            if (!this.rightToLeftRunDirection) {
                for (j = 0; j < currentMarks.succeeding.size(); ++j) {
                    textChunks.add(currentMarks.succeeding.get(j));
                }
                continue;
            }
            for (j = currentMarks.preceding.size() - 1; j >= 0; --j) {
                textChunks.add(currentMarks.preceding.get(j));
            }
        }
    }

    private static class TextChunkMarks {
        List<TextChunk> preceding = new ArrayList<TextChunk>();
        List<TextChunk> succeeding = new ArrayList<TextChunk>();

        private TextChunkMarks() {
        }
    }

    public static interface ITextChunkLocationStrategy {
        public ITextChunkLocation createLocation(TextRenderInfo var1, LineSegment var2);
    }
}

