/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel;

import com.itextpdf.kernel.LicenseVersionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Version {
    private static String AGPL = " (AGPL-version)";
    private static Version version = null;
    private static String iTextProductName = "iText\u00ae";
    private static String release = "7.1.1";
    private String producerLine = iTextProductName + " " + release + " \u00a92000-2018 iText Group NV";
    private String key = null;
    private boolean expired;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getInstance() {
        if (version == null) {
            Version version = Version.version = new Version();
            synchronized (version) {
                try {
                    String coreVersion = release;
                    String[] info = Version.getLicenseeInfoFromLicenseKey(coreVersion);
                    if (info != null) {
                        if (info[3] != null && info[3].trim().length() > 0) {
                            Version.version.key = info[3];
                        } else {
                            Version.version.key = "Trial version ";
                            Version.version.key = info[5] == null ? Version.version.key + "unauthorised" : Version.version.key + info[5];
                        }
                        if (info.length > 6 && info[6] != null && info[6].trim().length() > 0) {
                            Version.checkLicenseVersion(coreVersion, info[6]);
                        }
                        if (info[4] != null && info[4].trim().length() > 0) {
                            Version.version.producerLine = info[4];
                        } else if (info[2] != null && info[2].trim().length() > 0) {
                            Version.version.addLicensedPostfix(info[2]);
                        } else if (info[0] != null && info[0].trim().length() > 0) {
                            Version.version.addLicensedPostfix(info[0]);
                        } else {
                            Version.version.addAGPLPostfix(null);
                        }
                    } else {
                        Version.version.addAGPLPostfix(null);
                    }
                }
                catch (LicenseVersionException lve) {
                    throw lve;
                }
                catch (ClassNotFoundException cnfe) {
                    Version.version.addAGPLPostfix(null);
                }
                catch (Exception e) {
                    if (e.getCause() != null && e.getCause().getMessage().equals("License file not loaded.") && Version.isiText5licenseLoaded()) {
                        throw new LicenseVersionException("No iText7 License is loaded but an iText5 license is loaded.");
                    }
                    Version.version.addAGPLPostfix(e.getCause());
                }
            }
        }
        return version;
    }

    public static boolean isAGPLVersion() {
        return Version.getInstance().getVersion().indexOf(AGPL) > 0;
    }

    public static boolean isExpired() {
        return Version.getInstance().expired;
    }

    public String getProduct() {
        return iTextProductName;
    }

    public String getRelease() {
        return release;
    }

    public String getVersion() {
        return this.producerLine;
    }

    public String getKey() {
        return this.key;
    }

    private void addLicensedPostfix(String ownerName) {
        this.producerLine = this.producerLine + " (" + ownerName;
        this.producerLine = !this.key.toLowerCase().startsWith("trial") ? this.producerLine + "; licensed version)" : this.producerLine + "; " + this.key + ")";
    }

    private void addAGPLPostfix(Throwable cause) {
        this.producerLine = this.producerLine + AGPL;
        if (cause != null && cause.getMessage() != null && cause.getMessage().contains("expired")) {
            this.expired = true;
        }
    }

    private static Class<?> getLicenseKeyClass() throws ClassNotFoundException {
        String licenseKeyClassFullName = "com.itextpdf.licensekey.LicenseKey";
        return Class.forName(licenseKeyClassFullName);
    }

    private static void checkLicenseVersion(String coreVersionString, String licenseVersionString) {
        String[] coreVersions = Version.parseVersionString(coreVersionString);
        String[] licenseVersions = Version.parseVersionString(licenseVersionString);
        int coreMajor = Integer.parseInt(coreVersions[0]);
        int coreMinor = Integer.parseInt(coreVersions[1]);
        int licenseMajor = Integer.parseInt(licenseVersions[0]);
        int licenseMinor = Integer.parseInt(licenseVersions[1]);
        if (licenseMajor < coreMajor) {
            throw new LicenseVersionException("The major version of the license ({0}) is lower than the major version ({1}) of the Core library.").setMessageParams(licenseMajor, coreMajor);
        }
        if (licenseMajor > coreMajor) {
            throw new LicenseVersionException("The major version of the license ({0}) is higher than the major version ({1}) of the Core library.").setMessageParams(licenseMajor, coreMajor);
        }
        if (licenseMinor < coreMinor) {
            throw new LicenseVersionException("The minor version of the license ({0}) is lower than the minor version ({1}) of the Core library.").setMessageParams(licenseMinor, coreMinor);
        }
    }

    private static String[] parseVersionString(String version) {
        String splitRegex = "\\.";
        String[] split = version.split(splitRegex);
        if (split.length == 0) {
            throw new LicenseVersionException("Version string is empty and cannot be parsed.");
        }
        String major = split[0];
        String minor = "0";
        if (split.length > 1) {
            minor = split[1].substring(0);
        }
        if (!Version.isVersionNumeric(major)) {
            throw new LicenseVersionException("Major version is not numeric");
        }
        if (!Version.isVersionNumeric(minor)) {
            throw new LicenseVersionException("Minor version is not numeric");
        }
        return new String[]{major, minor};
    }

    private static String[] getLicenseeInfoFromLicenseKey(String validatorKey) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        String licenseeInfoMethodName = "getLicenseeInfoForVersion";
        Class<?> klass = Version.getLicenseKeyClass();
        if (klass != null) {
            Class[] cArg = new Class[]{String.class};
            Method m = klass.getMethod(licenseeInfoMethodName, cArg);
            Object[] args = new Object[]{validatorKey};
            String[] info = (String[])m.invoke(klass.newInstance(), args);
            return info;
        }
        return null;
    }

    private static boolean isiText5licenseLoaded() {
        String validatorKey5 = "5";
        boolean result = false;
        try {
            String[] info = Version.getLicenseeInfoFromLicenseKey(validatorKey5);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static boolean isVersionNumeric(String version) {
        try {
            Double.parseDouble(version);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

