/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfNumTree;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParentTreeHandler
implements Serializable {
    private static final long serialVersionUID = 1593883864288316473L;
    private PdfStructTreeRoot structTreeRoot;
    private PdfNumTree parentTree;
    private Map<PdfIndirectReference, TreeMap<Integer, PdfMcr>> pageToPageMcrs;

    ParentTreeHandler(PdfStructTreeRoot structTreeRoot) {
        this.structTreeRoot = structTreeRoot;
        this.parentTree = new PdfNumTree(structTreeRoot.getDocument().getCatalog(), PdfName.ParentTree);
        this.registerAllMcrs();
    }

    public Map<Integer, PdfMcr> getPageMarkedContentReferences(PdfPage page) {
        return this.pageToPageMcrs.get(((PdfDictionary)page.getPdfObject()).getIndirectReference());
    }

    public PdfMcr findMcrByMcid(PdfDictionary pageDict, int mcid) {
        Map pageMcrs = this.pageToPageMcrs.get(pageDict.getIndirectReference());
        return pageMcrs != null ? (PdfMcr)pageMcrs.get(mcid) : null;
    }

    public PdfObjRef findObjRefByStructParentIndex(PdfDictionary pageDict, int structParentIndex) {
        Map pageMcrs = this.pageToPageMcrs.get(pageDict.getIndirectReference());
        return pageMcrs != null ? (PdfObjRef)pageMcrs.get(ParentTreeHandler.structParentIndexIntoKey(structParentIndex)) : null;
    }

    public int getNextMcidForPage(PdfPage page) {
        TreeMap pageMcrs = (TreeMap)this.getPageMarkedContentReferences(page);
        if (pageMcrs == null || pageMcrs.size() == 0) {
            return 0;
        }
        int lastKey = (Integer)pageMcrs.lastEntry().getKey();
        if (lastKey < 0) {
            return 0;
        }
        return lastKey + 1;
    }

    public void createParentTreeEntryForPage(PdfPage page) {
        Map<Integer, PdfMcr> mcrs = this.getPageMarkedContentReferences(page);
        if (mcrs == null) {
            return;
        }
        this.pageToPageMcrs.remove(((PdfDictionary)page.getPdfObject()).getIndirectReference());
        this.updateStructParentTreeEntries(page, mcrs);
        this.structTreeRoot.setModified();
    }

    public PdfDictionary buildParentTree() {
        return (PdfDictionary)this.parentTree.buildTree().makeIndirect(this.structTreeRoot.getDocument());
    }

    public void registerMcr(PdfMcr mcr) {
        this.registerMcr(mcr, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerMcr(PdfMcr mcr, boolean registeringOnInit) {
        PdfDictionary mcrPageObject = mcr.getPageObject();
        if (mcrPageObject == null || !(mcr instanceof PdfObjRef) && mcr.getMcid() < 0) {
            Logger logger = LoggerFactory.getLogger(ParentTreeHandler.class);
            logger.error("Corrupted tag structure: encountered invalid marked content reference - it doesn't refer to any page or any mcid. This content reference will be ignored.");
            return;
        }
        TreeMap<Integer, PdfMcr> pageMcrs = this.pageToPageMcrs.get(mcrPageObject.getIndirectReference());
        if (pageMcrs == null) {
            pageMcrs = new TreeMap();
            this.pageToPageMcrs.put(mcrPageObject.getIndirectReference(), pageMcrs);
        }
        if (mcr instanceof PdfObjRef) {
            PdfDictionary obj = ((PdfDictionary)mcr.getPdfObject()).getAsDictionary(PdfName.Obj);
            if (obj == null || obj.isFlushed()) {
                throw new PdfException("When adding object reference to the tag tree, it must be connected to not flushed object.");
            }
            PdfNumber n = obj.getAsNumber(PdfName.StructParent);
            if (n == null) throw new PdfException("StructParent index not found in tagged object.");
            pageMcrs.put(ParentTreeHandler.structParentIndexIntoKey(n.intValue()), mcr);
        } else {
            pageMcrs.put(mcr.getMcid(), mcr);
        }
        if (registeringOnInit) return;
        this.structTreeRoot.setModified();
    }

    public void unregisterMcr(PdfMcr mcrToUnregister) {
        PdfDictionary pageDict = mcrToUnregister.getPageObject();
        if (pageDict == null) {
            return;
        }
        if (pageDict.isFlushed()) {
            throw new PdfException("Cannot remove marked content reference, because its page has been already flushed.");
        }
        Map pageMcrs = this.pageToPageMcrs.get(pageDict.getIndirectReference());
        if (pageMcrs != null) {
            if (mcrToUnregister instanceof PdfObjRef) {
                PdfNumber n;
                PdfDictionary obj = ((PdfDictionary)mcrToUnregister.getPdfObject()).getAsDictionary(PdfName.Obj);
                if (obj != null && !obj.isFlushed() && (n = obj.getAsNumber(PdfName.StructParent)) != null) {
                    pageMcrs.remove(ParentTreeHandler.structParentIndexIntoKey(n.intValue()));
                    this.structTreeRoot.setModified();
                    return;
                }
                for (Map.Entry entry : pageMcrs.entrySet()) {
                    if (((PdfMcr)entry.getValue()).getPdfObject() != mcrToUnregister.getPdfObject()) continue;
                    pageMcrs.remove(entry.getKey());
                    this.structTreeRoot.setModified();
                    break;
                }
            } else {
                pageMcrs.remove(mcrToUnregister.getMcid());
                this.structTreeRoot.setModified();
            }
        }
    }

    private static int structParentIndexIntoKey(int structParentIndex) {
        return -structParentIndex - 1;
    }

    private static int keyIntoStructParentIndex(int key) {
        return -key - 1;
    }

    private void registerAllMcrs() {
        this.pageToPageMcrs = new HashMap<PdfIndirectReference, TreeMap<Integer, PdfMcr>>();
        Map<Integer, PdfObject> parentTreeEntries = new PdfNumTree(this.structTreeRoot.getDocument().getCatalog(), PdfName.ParentTree).getNumbers();
        HashSet<PdfStructElem> mcrParents = new HashSet<PdfStructElem>();
        int maxStructParentIndex = -1;
        for (Map.Entry<Integer, PdfObject> entry : parentTreeEntries.entrySet()) {
            PdfObject entryValue;
            if (entry.getKey() > maxStructParentIndex) {
                maxStructParentIndex = entry.getKey();
            }
            if ((entryValue = entry.getValue()).isDictionary()) {
                mcrParents.add(new PdfStructElem((PdfDictionary)entryValue));
                continue;
            }
            if (!entryValue.isArray()) continue;
            PdfArray parentsArray = (PdfArray)entryValue;
            for (int i = 0; i < parentsArray.size(); ++i) {
                PdfDictionary parent = parentsArray.getAsDictionary(i);
                if (parent == null) continue;
                mcrParents.add(new PdfStructElem(parent));
            }
        }
        ((PdfDictionary)this.structTreeRoot.getPdfObject()).put(PdfName.ParentTreeNextKey, new PdfNumber(maxStructParentIndex + 1));
        for (PdfStructElem mcrParent : mcrParents) {
            for (IStructureNode kid : mcrParent.getKids()) {
                if (!(kid instanceof PdfMcr)) continue;
                this.registerMcr((PdfMcr)kid, true);
            }
        }
    }

    private void updateStructParentTreeEntries(PdfPage page, Map<Integer, PdfMcr> mcrs) {
        PdfArray parentsOfPageMcrs = new PdfArray();
        int currentMcid = 0;
        for (Map.Entry<Integer, PdfMcr> entry : mcrs.entrySet()) {
            PdfMcr mcr = entry.getValue();
            PdfDictionary parentObj = (PdfDictionary)((PdfStructElem)mcr.getParent()).getPdfObject();
            if (!parentObj.isIndirect()) continue;
            if (mcr instanceof PdfObjRef) {
                int structParent = ParentTreeHandler.keyIntoStructParentIndex(entry.getKey());
                this.parentTree.addEntry(structParent, parentObj);
                continue;
            }
            while (currentMcid++ < mcr.getMcid()) {
                parentsOfPageMcrs.add(PdfNull.PDF_NULL);
            }
            parentsOfPageMcrs.add(parentObj);
        }
        if (parentsOfPageMcrs.size() > 0) {
            parentsOfPageMcrs.makeIndirect(this.structTreeRoot.getDocument());
            int structParents = page.getStructParentIndex() != -1 ? page.getStructParentIndex() : page.getDocument().getNextStructParentIndex();
            ((PdfDictionary)page.getPdfObject()).put(PdfName.StructParents, new PdfNumber(structParents));
            this.parentTree.addEntry(structParents, parentsOfPageMcrs);
            this.structTreeRoot.getDocument().checkIsoConformance(parentsOfPageMcrs, IsoKey.TAG_STRUCTURE_ELEMENT);
            parentsOfPageMcrs.flush();
        }
    }
}

