/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.util;

import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.parser.util.InlineImageParsingUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PdfCanvasParser {
    private PdfTokenizer tokeniser;
    private PdfResources currentResources;

    public PdfCanvasParser(PdfTokenizer tokeniser) {
        this.tokeniser = tokeniser;
    }

    public PdfCanvasParser(PdfTokenizer tokeniser, PdfResources currentResources) {
        this.tokeniser = tokeniser;
        this.currentResources = currentResources;
    }

    public List<PdfObject> parse(List<PdfObject> ls) throws IOException {
        if (ls == null) {
            ls = new ArrayList<PdfObject>();
        } else {
            ls.clear();
        }
        PdfObject ob = null;
        while ((ob = this.readObject()) != null) {
            ls.add(ob);
            if (this.tokeniser.getTokenType() != PdfTokenizer.TokenType.Other) continue;
            if (!ob.toString().equals("BI")) break;
            PdfStream inlineImageAsStream = InlineImageParsingUtils.parse(this, this.currentResources.getResource(PdfName.ColorSpace));
            ls.clear();
            ls.add(inlineImageAsStream);
            ls.add(new PdfLiteral("EI"));
            break;
        }
        return ls;
    }

    public PdfTokenizer getTokeniser() {
        return this.tokeniser;
    }

    public void setTokeniser(PdfTokenizer tokeniser) {
        this.tokeniser = tokeniser;
    }

    public PdfDictionary readDictionary() throws IOException {
        PdfDictionary dic = new PdfDictionary();
        while (true) {
            if (!this.nextValidToken()) {
                throw new PdfException("Unexpected end of file.");
            }
            if (this.tokeniser.getTokenType() == PdfTokenizer.TokenType.EndDic) break;
            if (this.tokeniser.getTokenType() != PdfTokenizer.TokenType.Name) {
                this.tokeniser.throwError("Dictionary key {0} is not a name.", new Object[]{this.tokeniser.getStringValue()});
            }
            PdfName name = new PdfName(this.tokeniser.getStringValue());
            PdfObject obj = this.readObject();
            dic.put(name, obj);
        }
        return dic;
    }

    public PdfArray readArray() throws IOException {
        PdfArray array = new PdfArray();
        while (true) {
            PdfObject obj = this.readObject();
            if (this.tokeniser.getTokenType() == PdfTokenizer.TokenType.EndArray) break;
            if (this.tokeniser.getTokenType() == PdfTokenizer.TokenType.EndDic && obj.getType() != 3) {
                this.tokeniser.throwError("unexpected >>.", new Object[0]);
            }
            array.add(obj);
        }
        return array;
    }

    public PdfObject readObject() throws IOException {
        if (!this.nextValidToken()) {
            return null;
        }
        PdfTokenizer.TokenType type = this.tokeniser.getTokenType();
        switch (type) {
            case StartDic: {
                PdfDictionary dic = this.readDictionary();
                return dic;
            }
            case StartArray: {
                return this.readArray();
            }
            case String: {
                PdfString str = new PdfString(this.tokeniser.getDecodedStringContent()).setHexWriting(this.tokeniser.isHexString());
                return str;
            }
            case Name: {
                return new PdfName(this.tokeniser.getByteContent());
            }
            case Number: {
                return new PdfNumber(this.tokeniser.getByteContent());
            }
        }
        return new PdfLiteral(this.tokeniser.getByteContent());
    }

    public boolean nextValidToken() throws IOException {
        while (this.tokeniser.nextToken()) {
            if (this.tokeniser.getTokenType() == PdfTokenizer.TokenType.Comment) continue;
            return true;
        }
        return false;
    }
}

