/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.tagging.IPdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfMcrDictionary;
import com.itextpdf.kernel.pdf.tagging.PdfMcrNumber;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PdfStructElem
extends PdfObjectWrapper<PdfDictionary>
implements IPdfStructElem {
    private static final long serialVersionUID = 7204356181229674005L;
    public static int Unknown = 0;
    public static int Grouping = 1;
    public static int BlockLevel = 2;
    public static int InlineLevel = 3;
    public static int Illustration = 4;
    public static Set<PdfName> groupingRoles = new HashSet<PdfName>();
    public static Set<PdfName> blockLevelRoles = new HashSet<PdfName>();
    public static Set<PdfName> inlineLevelRoles = new HashSet<PdfName>();
    public static Set<PdfName> illustrationRoles = new HashSet<PdfName>();
    protected int type = Unknown;

    public PdfStructElem(PdfDictionary pdfObject) {
        super(pdfObject);
        PdfStructElem.ensureObjectIsAddedToDocument(pdfObject);
        this.setForbidRelease();
    }

    public PdfStructElem(PdfDocument document, PdfName role, PdfPage page) {
        this(document, role);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Pg, (PdfObject)page.getPdfObject());
    }

    public PdfStructElem(PdfDocument document, PdfName role, PdfAnnotation annot) {
        this(document, role);
        if (annot.getPage() == null) {
            throw new PdfException("Annotation shall have reference to page.");
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Pg, (PdfObject)annot.getPage().getPdfObject());
    }

    public PdfStructElem(PdfDocument document, PdfName role) {
        this(new PdfDictionary().makeIndirect(document));
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.StructElem);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.S, role);
    }

    public static boolean isStructElem(PdfDictionary dictionary) {
        return PdfName.StructElem.equals(dictionary.getAsName(PdfName.Type)) || dictionary.containsKey(PdfName.S);
    }

    public PdfObject getAttributes(boolean createNewIfNull) {
        PdfObject attributes = ((PdfDictionary)this.getPdfObject()).get(PdfName.A);
        if (attributes == null && createNewIfNull) {
            attributes = new PdfDictionary();
            this.setAttributes(attributes);
        }
        return attributes;
    }

    public void setAttributes(PdfObject attributes) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.A, attributes);
    }

    public PdfString getLang() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Lang);
    }

    public void setLang(PdfString lang) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Lang, lang);
    }

    public PdfString getAlt() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Alt);
    }

    public void setAlt(PdfString alt) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Alt, alt);
    }

    public PdfString getActualText() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.ActualText);
    }

    public void setActualText(PdfString actualText) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ActualText, actualText);
    }

    public PdfString getE() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.E);
    }

    public void setE(PdfString e) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.E, e);
    }

    @Override
    public PdfName getRole() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.S);
    }

    public void setRole(PdfName role) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.S, role);
    }

    public PdfStructElem addKid(PdfStructElem kid) {
        return this.addKid(-1, kid);
    }

    public PdfStructElem addKid(int index, PdfStructElem kid) {
        if (this.getType() == InlineLevel || this.getType() == Illustration) {
            throw new PdfException("Inline level or illustration element cannot contain kids.", this.getPdfObject());
        }
        PdfStructElem.addKidObject((PdfDictionary)this.getPdfObject(), index, kid.getPdfObject());
        return kid;
    }

    public PdfMcr addKid(PdfMcr kid) {
        return this.addKid(-1, kid);
    }

    public PdfMcr addKid(int index, PdfMcr kid) {
        this.getDocument().getStructTreeRoot().getParentTreeHandler().registerMcr(kid);
        PdfStructElem.addKidObject((PdfDictionary)this.getPdfObject(), index, kid.getPdfObject());
        return kid;
    }

    public IPdfStructElem removeKid(int index) {
        PdfObject k = this.getK();
        if (k == null || !k.isArray() && index != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (k.isArray()) {
            PdfArray kidsArray = (PdfArray)k;
            k = kidsArray.get(index);
            kidsArray.remove(index);
            if (kidsArray.isEmpty()) {
                ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
            }
        } else {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
        }
        IPdfStructElem removedKid = this.convertPdfObjectToIPdfStructElem(k);
        if (removedKid instanceof PdfMcr) {
            this.getDocument().getStructTreeRoot().getParentTreeHandler().unregisterMcr((PdfMcr)removedKid);
        }
        return removedKid;
    }

    public int removeKid(IPdfStructElem kid) {
        if (kid instanceof PdfMcr) {
            PdfMcr mcr = (PdfMcr)kid;
            this.getDocument().getStructTreeRoot().getParentTreeHandler().unregisterMcr(mcr);
            return this.removeKidObject((PdfObject)mcr.getPdfObject());
        }
        if (kid instanceof PdfStructElem) {
            return this.removeKidObject((PdfObject)((PdfStructElem)kid).getPdfObject());
        }
        return -1;
    }

    @Override
    public IPdfStructElem getParent() {
        PdfDictionary parent = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.P);
        if (parent == null || parent.isFlushed()) {
            return null;
        }
        if (PdfStructElem.isStructElem(parent)) {
            return new PdfStructElem(parent);
        }
        PdfName type = parent.getAsName(PdfName.Type);
        if (PdfName.StructTreeRoot.equals(type)) {
            return this.getDocument().getStructTreeRoot();
        }
        return null;
    }

    @Override
    public List<IPdfStructElem> getKids() {
        PdfObject k = this.getK();
        ArrayList<IPdfStructElem> kids = new ArrayList<IPdfStructElem>();
        if (k != null) {
            if (k.isArray()) {
                PdfArray a = (PdfArray)k;
                for (int i = 0; i < a.size(); ++i) {
                    this.addKidObjectToStructElemList(a.get(i), kids);
                }
            } else {
                this.addKidObjectToStructElemList(k, kids);
            }
        }
        return kids;
    }

    public PdfObject getK() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.K);
    }

    public static int identifyType(PdfDocument doc, PdfName role) {
        PdfDictionary roleMap = doc.getStructTreeRoot().getRoleMap();
        if (roleMap.containsKey(role)) {
            role = roleMap.getAsName(role);
        }
        if (groupingRoles.contains(role)) {
            return Grouping;
        }
        if (blockLevelRoles.contains(role)) {
            return BlockLevel;
        }
        if (inlineLevelRoles.contains(role)) {
            return InlineLevel;
        }
        if (illustrationRoles.contains(role)) {
            return Illustration;
        }
        return Unknown;
    }

    public PdfStructElem put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        return this;
    }

    @Override
    public void flush() {
        this.getDocument().checkIsoConformance(this.getPdfObject(), IsoKey.TAG_STRUCTURE_ELEMENT);
        super.flush();
    }

    protected int getType() {
        if (this.type == Unknown) {
            PdfName role = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.S);
            this.type = PdfStructElem.identifyType(this.getDocument(), role);
        }
        return this.type;
    }

    static void addKidObject(PdfDictionary parent, int index, PdfObject kid) {
        if (parent.isFlushed()) {
            throw new PdfException("Cannot add kid to the flushed element.");
        }
        if (!parent.containsKey(PdfName.P)) {
            throw new PdfException("StructureElement shall contain parent object.", parent);
        }
        PdfObject k = parent.get(PdfName.K);
        if (k == null) {
            parent.put(PdfName.K, kid);
        } else {
            PdfArray a;
            if (k instanceof PdfArray) {
                a = (PdfArray)k;
            } else {
                a = new PdfArray();
                a.add(k);
                parent.put(PdfName.K, a);
            }
            if (index == -1) {
                a.add(kid);
            } else {
                a.add(index, kid);
            }
        }
        if (kid instanceof PdfDictionary && PdfStructElem.isStructElem((PdfDictionary)kid)) {
            ((PdfDictionary)kid).put(PdfName.P, parent);
        }
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    private void addKidObjectToStructElemList(PdfObject k, List<IPdfStructElem> list) {
        if (k.isFlushed()) {
            list.add(null);
            return;
        }
        list.add(this.convertPdfObjectToIPdfStructElem(k));
    }

    private IPdfStructElem convertPdfObjectToIPdfStructElem(PdfObject obj) {
        PdfObjectWrapper elem = null;
        switch (obj.getType()) {
            case 3: {
                PdfDictionary d = (PdfDictionary)obj;
                if (PdfStructElem.isStructElem(d)) {
                    elem = new PdfStructElem(d);
                    break;
                }
                if (PdfName.MCR.equals(d.getAsName(PdfName.Type))) {
                    elem = new PdfMcrDictionary(d, this);
                    break;
                }
                if (!PdfName.OBJR.equals(d.getAsName(PdfName.Type))) break;
                elem = new PdfObjRef(d, this);
                break;
            }
            case 8: {
                elem = new PdfMcrNumber((PdfNumber)obj, this);
                break;
            }
        }
        return elem;
    }

    private int removeKidObject(PdfObject kid) {
        PdfObject k = this.getK();
        if (k == null || !k.isArray() && k != kid && k != kid.getIndirectReference()) {
            return -1;
        }
        int removedIndex = -1;
        if (k.isArray()) {
            PdfArray kidsArray = (PdfArray)k;
            removedIndex = PdfStructElem.removeObjectFromArray(kidsArray, kid);
            if (kidsArray.isEmpty()) {
                ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
            }
        }
        if (!k.isArray() || k.isArray() && ((PdfArray)k).isEmpty()) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.K);
            removedIndex = 0;
        }
        return removedIndex;
    }

    static int removeObjectFromArray(PdfArray array, PdfObject toRemove) {
        int i;
        for (i = 0; i < array.size(); ++i) {
            PdfObject obj = array.get(i);
            if (obj != toRemove && obj != toRemove.getIndirectReference()) continue;
            array.remove(i);
            break;
        }
        return i;
    }

    static {
        groupingRoles.add(PdfName.Document);
        groupingRoles.add(PdfName.Part);
        groupingRoles.add(PdfName.Art);
        groupingRoles.add(PdfName.Sect);
        groupingRoles.add(PdfName.Div);
        groupingRoles.add(PdfName.BlockQuote);
        groupingRoles.add(PdfName.Caption);
        groupingRoles.add(PdfName.Caption);
        groupingRoles.add(PdfName.TOC);
        groupingRoles.add(PdfName.TOCI);
        groupingRoles.add(PdfName.Index);
        groupingRoles.add(PdfName.NonStruct);
        groupingRoles.add(PdfName.Private);
        blockLevelRoles.add(PdfName.P);
        blockLevelRoles.add(PdfName.H);
        blockLevelRoles.add(PdfName.H1);
        blockLevelRoles.add(PdfName.H2);
        blockLevelRoles.add(PdfName.H3);
        blockLevelRoles.add(PdfName.H4);
        blockLevelRoles.add(PdfName.H5);
        blockLevelRoles.add(PdfName.H6);
        blockLevelRoles.add(PdfName.L);
        blockLevelRoles.add(PdfName.Lbl);
        blockLevelRoles.add(PdfName.LI);
        blockLevelRoles.add(PdfName.LBody);
        blockLevelRoles.add(PdfName.Table);
        blockLevelRoles.add(PdfName.TR);
        blockLevelRoles.add(PdfName.TH);
        blockLevelRoles.add(PdfName.TD);
        blockLevelRoles.add(PdfName.THead);
        blockLevelRoles.add(PdfName.TBody);
        blockLevelRoles.add(PdfName.TFoot);
        inlineLevelRoles.add(PdfName.Span);
        inlineLevelRoles.add(PdfName.Quote);
        inlineLevelRoles.add(PdfName.Note);
        inlineLevelRoles.add(PdfName.Reference);
        inlineLevelRoles.add(PdfName.BibEntry);
        inlineLevelRoles.add(PdfName.Code);
        inlineLevelRoles.add(PdfName.Link);
        inlineLevelRoles.add(PdfName.Annot);
        inlineLevelRoles.add(PdfName.Ruby);
        inlineLevelRoles.add(PdfName.Warichu);
        inlineLevelRoles.add(PdfName.RB);
        inlineLevelRoles.add(PdfName.RT);
        inlineLevelRoles.add(PdfName.RP);
        inlineLevelRoles.add(PdfName.WT);
        inlineLevelRoles.add(PdfName.WP);
        illustrationRoles.add(PdfName.Figure);
        illustrationRoles.add(PdfName.Formula);
        illustrationRoles.add(PdfName.Form);
    }
}

