/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.DocWriter;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImage;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.parser.BezierCurve;
import com.itextpdf.text.pdf.parser.ContentOperator;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.Line;
import com.itextpdf.text.pdf.parser.Path;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.Shape;
import com.itextpdf.text.pdf.parser.Subpath;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContentChunk;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpRenderListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PdfCleanUpContentOperator
implements ContentOperator {
    private static final byte[] TStar = DocWriter.getISOBytes((String)"T*\n");
    private static final byte[] Tw = DocWriter.getISOBytes((String)" Tw ");
    private static final byte[] TcTStar = DocWriter.getISOBytes((String)" Tc T*\n");
    private static final byte[] TJ = DocWriter.getISOBytes((String)"] TJ\n");
    private static final byte[] Tc = DocWriter.getISOBytes((String)" Tc\n");
    private static final byte[] m = DocWriter.getISOBytes((String)" m\n");
    private static final byte[] l = DocWriter.getISOBytes((String)" l\n");
    private static final byte[] c = DocWriter.getISOBytes((String)" c\n");
    private static final byte[] h = DocWriter.getISOBytes((String)"h\n");
    private static final byte[] S = DocWriter.getISOBytes((String)"S\n");
    private static final byte[] f = DocWriter.getISOBytes((String)"f\n");
    private static final byte[] eoF = DocWriter.getISOBytes((String)"f*\n");
    private static final byte[] n = DocWriter.getISOBytes((String)"n\n");
    private static final byte[] W = DocWriter.getISOBytes((String)"W\n");
    private static final byte[] eoW = DocWriter.getISOBytes((String)"W*\n");
    private static final byte[] q = DocWriter.getISOBytes((String)"q\n");
    private static final byte[] Q = DocWriter.getISOBytes((String)"Q\n");
    private static final byte[] cs = DocWriter.getISOBytes((String)"cs\n");
    private static final Set<String> textShowingOperators = new HashSet<String>(Arrays.asList("TJ", "Tj", "'", "\""));
    private static final Set<String> pathConstructionOperators = new HashSet<String>(Arrays.asList("m", "l", "c", "v", "y", "h", "re"));
    private static final Set<String> strokeOperators = new HashSet<String>(Arrays.asList("S", "s", "B", "B*", "b", "b*"));
    private static final Set<String> nwFillOperators = new HashSet<String>(Arrays.asList("f", "F", "B", "b"));
    private static final Set<String> eoFillOperators = new HashSet<String>(Arrays.asList("f*", "B*", "b*"));
    private static final Set<String> pathPaintingOperators = new HashSet<String>(){
        {
            this.addAll(strokeOperators);
            this.addAll(nwFillOperators);
            this.addAll(eoFillOperators);
            this.add("n");
        }
    };
    private static final Set<String> clippingPathOperators = new HashSet<String>(Arrays.asList("W", "W*"));
    private static final Set<String> lineStyleOperators = new HashSet<String>(Arrays.asList("w", "J", "j", "M", "d"));
    private static final Set<String> strokeColorOperators = new HashSet<String>(Arrays.asList("CS", "SC", "SCN", "G", "RG", "K"));
    protected PdfCleanUpRenderListener cleanUpStrategy;
    protected ContentOperator originalContentOperator;

    public PdfCleanUpContentOperator(PdfCleanUpRenderListener cleanUpStrategy) {
        this.cleanUpStrategy = cleanUpStrategy;
    }

    public static void populateOperators(PdfContentStreamProcessor contentProcessor, PdfCleanUpRenderListener pdfCleanUpRenderListener) {
        for (String operator : contentProcessor.getRegisteredOperatorStrings()) {
            PdfCleanUpContentOperator contentOperator = new PdfCleanUpContentOperator(pdfCleanUpRenderListener);
            contentOperator.originalContentOperator = contentProcessor.registerContentOperator(operator, (ContentOperator)contentOperator);
        }
    }

    public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
        PdfStream xObj;
        PdfDictionary xObjResources;
        String operatorStr = operator.toString();
        PdfContentByte canvas = this.cleanUpStrategy.getContext().getCanvas();
        PRStream xFormStream = null;
        boolean disableOutput = pathConstructionOperators.contains(operatorStr) || pathPaintingOperators.contains(operatorStr) || clippingPathOperators.contains(operatorStr);
        GraphicsState gs = pdfContentStreamProcessor.gs();
        Map<Integer, Float> structuredTJoperands = null;
        if ("Do".equals(operatorStr) && operands.size() == 2 && operands.get(0).isName() && (xObjResources = this.cleanUpStrategy.getContext().getResources().getAsDict(PdfName.XOBJECT)) != null && (xObj = xObjResources.getAsStream((PdfName)operands.get(0))) instanceof PRStream && xObj.getAsName(PdfName.SUBTYPE) != null && xObj.getAsName(PdfName.SUBTYPE).compareTo(PdfName.FORM) == 0) {
            xFormStream = (PRStream)xObj;
            this.cleanUpStrategy.registerNewContext(xObj.getAsDict(PdfName.RESOURCES), null);
        }
        this.originalContentOperator.invoke(pdfContentStreamProcessor, operator, operands);
        List<PdfCleanUpContentChunk> chunks = this.cleanUpStrategy.getChunks();
        if (xFormStream != null) {
            xFormStream.setData(this.cleanUpStrategy.getContext().getCanvas().toPdf(this.cleanUpStrategy.getContext().getCanvas().getPdfWriter()));
            this.cleanUpStrategy.popContext();
            canvas = this.cleanUpStrategy.getContext().getCanvas();
        }
        if ("Do".equals(operatorStr)) {
            if (chunks.size() > 0 && chunks.get(0) instanceof PdfCleanUpContentChunk.Image) {
                PdfCleanUpContentChunk.Image chunk = (PdfCleanUpContentChunk.Image)chunks.get(0);
                if (chunk.isVisible()) {
                    PdfDictionary xObjResources2 = this.cleanUpStrategy.getContext().getResources().getAsDict(PdfName.XOBJECT);
                    PRStream imageStream = (PRStream)xObjResources2.getAsStream((PdfName)operands.get(0));
                    this.updateImageStream(imageStream, chunk.getNewImageData());
                } else {
                    disableOutput = true;
                }
            }
        } else if (lineStyleOperators.contains(operatorStr)) {
            disableOutput = true;
        } else if (textShowingOperators.contains(operatorStr) && !this.allChunksAreVisible(this.cleanUpStrategy.getChunks())) {
            disableOutput = true;
            if ("'".equals(operatorStr)) {
                canvas.getInternalBuffer().append(TStar);
            } else if ("\"".equals(operatorStr)) {
                operands.get(0).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(Tw);
                operands.get(1).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(TcTStar);
            } else if ("TJ".equals(operatorStr)) {
                structuredTJoperands = this.structureTJarray((PdfArray)operands.get(0));
            }
            this.writeTextChunks(structuredTJoperands, chunks, canvas, gs.getCharacterSpacing(), gs.getWordSpacing(), gs.getFontSize(), gs.getHorizontalScaling());
        } else if (pathPaintingOperators.contains(operatorStr)) {
            this.writePath(operatorStr, canvas, gs.getColorSpaceStroke());
        } else if (strokeColorOperators.contains(operatorStr)) {
            this.cleanUpStrategy.getContext().popStrokeColor();
            this.cleanUpStrategy.getContext().pushStrokeColor(operands);
        } else if ("q".equals(operatorStr)) {
            this.cleanUpStrategy.getContext().pushStrokeColor(this.cleanUpStrategy.getContext().peekStrokeColor());
        } else if ("Q".equals(operatorStr)) {
            this.cleanUpStrategy.getContext().popStrokeColor();
        }
        if (!disableOutput) {
            this.writeOperands(canvas, operands);
        }
        this.cleanUpStrategy.clearChunks();
    }

    private void writeOperands(PdfContentByte canvas, List<PdfObject> operands) throws IOException {
        int index = 0;
        for (PdfObject o : operands) {
            PdfCleanUpContentOperator.toPdf(o, canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
            canvas.getInternalBuffer().append(operands.size() > ++index ? (byte)32 : 10);
        }
    }

    private boolean allChunksAreVisible(List<PdfCleanUpContentChunk> chunks) {
        for (PdfCleanUpContentChunk chunk : chunks) {
            if (chunk.isVisible()) continue;
            return false;
        }
        return true;
    }

    private static void toPdf(PdfObject object, PdfWriter writer, OutputStream os) throws IOException {
        if (object instanceof PdfDictionary) {
            os.write(60);
            os.write(60);
            ArrayList keys = new ArrayList(((PdfDictionary)object).getKeys());
            Collections.sort(keys);
            for (PdfName key : keys) {
                PdfCleanUpContentOperator.toPdf((PdfObject)key, writer, os);
                PdfObject value = ((PdfDictionary)object).get(key);
                int type = value.type();
                if (type != 5 && type != 6 && type != 4 && type != 3) {
                    os.write(32);
                }
                PdfCleanUpContentOperator.toPdf(value, writer, os);
            }
            os.write(62);
            os.write(62);
        } else {
            object.toPdf(writer, os);
        }
    }

    private Map<Integer, Float> structureTJarray(PdfArray array) {
        HashMap<Integer, Float> structuredTJoperands = new HashMap<Integer, Float>();
        if (array.size() == 0) {
            return structuredTJoperands;
        }
        Integer previousStrNum = 0;
        structuredTJoperands.put(previousStrNum, Float.valueOf(0.0f));
        for (int i = 0; i < array.size(); ++i) {
            PdfObject currentObj = array.getPdfObject(i);
            if (currentObj instanceof PdfString && ((PdfString)currentObj).toUnicodeString().length() > 0) {
                previousStrNum = previousStrNum + 1;
                structuredTJoperands.put(previousStrNum, Float.valueOf(0.0f));
                continue;
            }
            Float oldOffset = (Float)structuredTJoperands.get(previousStrNum);
            structuredTJoperands.put(previousStrNum, Float.valueOf(oldOffset.floatValue() + ((PdfNumber)currentObj).floatValue()));
        }
        return structuredTJoperands;
    }

    private void writeTextChunks(Map<Integer, Float> structuredTJoperands, List<PdfCleanUpContentChunk> chunks, PdfContentByte canvas, float characterSpacing, float wordSpacing, float fontSize, float horizontalScaling) throws IOException {
        canvas.setCharacterSpacing(0.0f);
        canvas.setWordSpacing(0.0f);
        canvas.getInternalBuffer().append((byte)91);
        float convertedCharacterSpacing = -characterSpacing * 1000.0f / fontSize;
        float convertedWordSpacing = -wordSpacing * 1000.0f / fontSize;
        float shift = structuredTJoperands != null ? structuredTJoperands.get(0).floatValue() : 0.0f;
        PdfCleanUpContentChunk.Text prevChunk = null;
        for (PdfCleanUpContentChunk chunk : chunks) {
            PdfCleanUpContentChunk.Text textChunk = (PdfCleanUpContentChunk.Text)chunk;
            if (prevChunk != null && prevChunk.getNumOfStrTextBelongsTo() != textChunk.getNumOfStrTextBelongsTo() && structuredTJoperands != null) {
                shift += structuredTJoperands.get(prevChunk.getNumOfStrTextBelongsTo()).floatValue();
            }
            if (textChunk.isVisible()) {
                if (Float.compare(shift, 0.0f) != 0 && Float.compare(shift, -0.0f) != 0) {
                    canvas.getInternalBuffer().append(shift).append(' ');
                }
                textChunk.getText().toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(' ');
                shift = convertedCharacterSpacing + (this.isSpace(textChunk) ? convertedWordSpacing : 0.0f);
            } else {
                shift += this.getUnscaledTextChunkWidth(textChunk, characterSpacing, wordSpacing, fontSize, horizontalScaling);
            }
            prevChunk = textChunk;
        }
        if (Float.compare(shift, 0.0f) != 0 && Float.compare(shift, -0.0f) != 0) {
            canvas.getInternalBuffer().append(shift);
        }
        canvas.getInternalBuffer().append(TJ);
        if (Float.compare(characterSpacing, 0.0f) != 0 && Float.compare(characterSpacing, -0.0f) != 0) {
            new PdfNumber(characterSpacing).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
            canvas.getInternalBuffer().append(Tc);
        }
        if (Float.compare(wordSpacing, 0.0f) != 0 && Float.compare(wordSpacing, -0.0f) != 0) {
            new PdfNumber(wordSpacing).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
            canvas.getInternalBuffer().append(Tw);
        }
    }

    private float getUnscaledTextChunkWidth(PdfCleanUpContentChunk.Text chunk, float characterSpacing, float wordSpacing, float fontSize, float horizontalScaling) {
        float scaledChunkWidth = chunk.getEndX() - chunk.getStartX() + (characterSpacing + (this.isSpace(chunk) ? wordSpacing : 0.0f)) * horizontalScaling;
        return -scaledChunkWidth * 1000.0f / (horizontalScaling * fontSize);
    }

    private boolean isSpace(PdfCleanUpContentChunk.Text chunk) {
        return chunk.getText().toUnicodeString().equals(" ");
    }

    private void updateImageStream(PRStream imageStream, byte[] newData) throws BadElementException, IOException, BadPdfFormatException {
        PdfImage image = new PdfImage(Image.getInstance((byte[])newData), "", null);
        if (imageStream.contains(PdfName.SMASK)) {
            image.put(PdfName.SMASK, imageStream.get(PdfName.SMASK));
        }
        if (imageStream.contains(PdfName.MASK)) {
            image.put(PdfName.MASK, imageStream.get(PdfName.MASK));
        }
        if (imageStream.contains(PdfName.SMASKINDATA)) {
            image.put(PdfName.SMASKINDATA, imageStream.get(PdfName.SMASKINDATA));
        }
        imageStream.clear();
        imageStream.putAll((PdfDictionary)image);
        imageStream.setDataRaw(image.getBytes());
    }

    private void writePath(String operatorStr, PdfContentByte canvas, PdfName strokeColorSpace) throws IOException {
        if (nwFillOperators.contains(operatorStr)) {
            this.writePath(this.cleanUpStrategy.getCurrentFillPath(), f, canvas);
        } else if (eoFillOperators.contains(operatorStr)) {
            this.writePath(this.cleanUpStrategy.getCurrentFillPath(), eoF, canvas);
        }
        if (strokeOperators.contains(operatorStr)) {
            this.writeStroke(canvas, this.cleanUpStrategy.getCurrentStrokePath(), strokeColorSpace);
        }
        if (this.cleanUpStrategy.isClipped()) {
            if (!this.cleanUpStrategy.getNewClipPath().isEmpty()) {
                byte[] clippingOperator = this.cleanUpStrategy.getClippingRule() == 1 ? W : eoW;
                this.writePath(this.cleanUpStrategy.getNewClipPath(), clippingOperator, canvas);
            } else {
                Path degeneratePath = new Path();
                degeneratePath.moveTo(0.0f, 0.0f);
                this.writePath(degeneratePath, W, canvas);
            }
            canvas.getInternalBuffer().append(n);
            this.cleanUpStrategy.setClipped(false);
        }
    }

    private void writePath(Path path, byte[] pathPaintingOperator, PdfContentByte canvas) throws IOException {
        if (path.isEmpty()) {
            return;
        }
        for (Subpath subpath : path.getSubpaths()) {
            this.writeMoveTo(subpath.getStartPoint(), canvas);
            for (Shape segment : subpath.getSegments()) {
                if (segment instanceof BezierCurve) {
                    this.writeBezierCurve((BezierCurve)segment, canvas);
                    continue;
                }
                this.writeLine((Line)segment, canvas);
            }
            if (!subpath.isClosed()) continue;
            canvas.getInternalBuffer().append(h);
        }
        if (pathPaintingOperator != null) {
            canvas.getInternalBuffer().append(pathPaintingOperator);
        }
    }

    private void writeMoveTo(Point2D destinationPoint, PdfContentByte canvas) throws IOException {
        new PdfNumber(destinationPoint.getX()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(' ');
        new PdfNumber(destinationPoint.getY()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(m);
    }

    private void writeBezierCurve(BezierCurve curve, PdfContentByte canvas) throws IOException {
        List basePoints = curve.getBasePoints();
        Point2D p2 = (Point2D)basePoints.get(1);
        Point2D p3 = (Point2D)basePoints.get(2);
        Point2D p4 = (Point2D)basePoints.get(3);
        new PdfNumber(p2.getX()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(' ');
        new PdfNumber(p2.getY()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(' ');
        new PdfNumber(p3.getX()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(' ');
        new PdfNumber(p3.getY()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(' ');
        new PdfNumber(p4.getX()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(' ');
        new PdfNumber(p4.getY()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(c);
    }

    private void writeLine(Line line, PdfContentByte canvas) throws IOException {
        Point2D destination = (Point2D)line.getBasePoints().get(1);
        new PdfNumber(destination.getX()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(' ');
        new PdfNumber(destination.getY()).toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
        canvas.getInternalBuffer().append(l);
    }

    private void writeStroke(PdfContentByte canvas, Path path, PdfName strokeColorSpace) throws IOException {
        canvas.getInternalBuffer().append(q);
        if (strokeColorSpace != null) {
            strokeColorSpace.toPdf(canvas.getPdfWriter(), (OutputStream)canvas.getInternalBuffer());
            canvas.getInternalBuffer().append(' ').append(cs);
        }
        List<PdfObject> strokeColorOperands = this.cleanUpStrategy.getContext().peekStrokeColor();
        String strokeOperatorStr = strokeColorOperands.get(strokeColorOperands.size() - 1).toString();
        strokeColorOperands.set(strokeColorOperands.size() - 1, (PdfObject)new PdfLiteral(strokeOperatorStr.toLowerCase()));
        this.writeOperands(canvas, strokeColorOperands);
        this.writePath(path, f, canvas);
        canvas.getInternalBuffer().append(Q);
    }
}

