/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocListener;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Counter;
import com.itextpdf.text.log.CounterFactory;
import com.itextpdf.text.pdf.AFRelationshipValue;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfATtfUnicodeWriter;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfIndirectObject;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.PdfXConformanceException;
import com.itextpdf.text.pdf.TtfUnicodeWriter;
import com.itextpdf.text.pdf.interfaces.PdfAConformance;
import com.itextpdf.text.pdf.interfaces.PdfIsoConformance;
import com.itextpdf.text.pdf.internal.PdfAChecker;
import com.itextpdf.text.pdf.internal.PdfAConformanceImp;
import com.itextpdf.text.xml.xmp.PdfAXmpWriter;
import com.itextpdf.text.xml.xmp.XmpWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfAWriter
extends PdfWriter {
    public static String MimeTypePdf = "application/pdf";
    public static String MimeTypeOctetStream = "application/octet-stream";
    protected Counter COUNTER = CounterFactory.getCounter(PdfAWriter.class);

    public static PdfAWriter getInstance(Document document, OutputStream os, PdfAConformanceLevel conformanceLevel) throws DocumentException {
        PdfDocument pdf = new PdfDocument();
        document.addDocListener((DocListener)pdf);
        PdfAWriter writer = new PdfAWriter(pdf, os, conformanceLevel);
        pdf.addWriter((PdfWriter)writer);
        return writer;
    }

    public static PdfAWriter getInstance(Document document, OutputStream os, DocListener listener, PdfAConformanceLevel conformanceLevel) throws DocumentException {
        PdfDocument pdf = new PdfDocument();
        pdf.addDocListener(listener);
        document.addDocListener((DocListener)pdf);
        PdfAWriter writer = new PdfAWriter(pdf, os, conformanceLevel);
        pdf.addWriter((PdfWriter)writer);
        return writer;
    }

    public static void setPdfVersion(PdfWriter writer, PdfAConformanceLevel conformanceLevel) {
        switch (conformanceLevel) {
            case PDF_A_1A: 
            case PDF_A_1B: {
                writer.setPdfVersion('4');
                break;
            }
            case PDF_A_2A: 
            case PDF_A_2B: 
            case PDF_A_2U: {
                writer.setPdfVersion('7');
                break;
            }
            case PDF_A_3A: 
            case PDF_A_3B: 
            case PDF_A_3U: {
                writer.setPdfVersion('7');
                break;
            }
            default: {
                writer.setPdfVersion('4');
            }
        }
    }

    public void setOutputIntents(String outputConditionIdentifier, String outputCondition, String registryName, String info, ICC_Profile colorProfile) throws IOException {
        PdfDictionary d;
        super.setOutputIntents(outputConditionIdentifier, outputCondition, registryName, info, colorProfile);
        PdfArray a = this.extraCatalog.getAsArray(PdfName.OUTPUTINTENTS);
        if (a != null && (d = a.getAsDict(0)) != null) {
            d.put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
        }
    }

    public void setPDFXConformance(int pdfx) {
        throw new PdfXConformanceException(MessageLocalization.getComposedMessage((String)"pdfx.conformance.cannot.be.set.for.PdfAWriter.instance", (Object[])new Object[0]));
    }

    protected PdfAWriter(PdfAConformanceLevel conformanceLevel) {
        ((PdfAConformance)this.pdfIsoConformance).setConformanceLevel(conformanceLevel);
        PdfAWriter.setPdfVersion(this, conformanceLevel);
    }

    protected PdfAWriter(PdfDocument document, OutputStream os, PdfAConformanceLevel conformanceLevel) {
        super(document, os);
        ((PdfAConformance)this.pdfIsoConformance).setConformanceLevel(conformanceLevel);
        PdfAWriter.setPdfVersion(this, conformanceLevel);
    }

    protected TtfUnicodeWriter getTtfUnicodeWriter() {
        if (this.ttfUnicodeWriter == null) {
            this.ttfUnicodeWriter = new PdfATtfUnicodeWriter(this, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel());
        }
        return this.ttfUnicodeWriter;
    }

    protected XmpWriter createXmpWriter(ByteArrayOutputStream baos, PdfDictionary info) throws IOException {
        this.xmpWriter = new PdfAXmpWriter((OutputStream)baos, info, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel(), (PdfWriter)this);
        return this.xmpWriter;
    }

    protected XmpWriter createXmpWriter(ByteArrayOutputStream baos, HashMap<String, String> info) throws IOException {
        this.xmpWriter = new PdfAXmpWriter((OutputStream)baos, info, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel(), (PdfWriter)this);
        return this.xmpWriter;
    }

    protected PdfIsoConformance initPdfIsoConformance() {
        return new PdfAConformanceImp(this);
    }

    protected Counter getCounter() {
        return this.COUNTER;
    }

    protected void cacheObject(PdfIndirectObject iobj) {
        this.getPdfAChecker().cacheObject(iobj.getIndirectReference(), iobj.object);
    }

    private PdfAChecker getPdfAChecker() {
        return ((PdfAConformanceImp)this.pdfIsoConformance).getPdfAChecker();
    }

    public PdfFileSpecification addFileAttachment(String description, byte[] fileStore, String file, String fileDisplay, String mimeType, PdfName afRelationshipValue, PdfDictionary fileParameter) throws IOException {
        PdfFileSpecification pdfFileSpecification = PdfFileSpecification.fileEmbedded((PdfWriter)this, (String)file, (String)fileDisplay, (byte[])fileStore, (String)mimeType, (PdfDictionary)fileParameter, (int)9);
        if (afRelationshipValue != null) {
            pdfFileSpecification.put(PdfName.AFRELATIONSHIP, (PdfObject)afRelationshipValue);
        } else {
            pdfFileSpecification.put(PdfName.AFRELATIONSHIP, (PdfObject)AFRelationshipValue.Unspecified);
        }
        this.addFileAttachment(description, pdfFileSpecification);
        return pdfFileSpecification;
    }

    public PdfFileSpecification addFileAttachment(String description, byte[] fileStore, String file, String fileDisplay, String mimeType, PdfName afRelationshipValue) throws IOException {
        return this.addFileAttachment(description, fileStore, file, fileDisplay, mimeType, afRelationshipValue, null);
    }

    public void addFileAttachment(String description, byte[] fileStore, String file, String fileDisplay, PdfName afRelationshipValue) throws IOException {
        this.addFileAttachment(description, fileStore, file, fileDisplay, MimeTypeOctetStream, afRelationshipValue);
    }

    public void addFileAttachment(String description, byte[] fileStore, String file, String fileDisplay) throws IOException {
        this.addFileAttachment(description, fileStore, file, fileDisplay, AFRelationshipValue.Unspecified);
    }

    public void addPdfAttachment(String description, byte[] fileStore, String file, String fileDisplay) throws IOException {
        this.addPdfAttachment(description, fileStore, file, fileDisplay, AFRelationshipValue.Unspecified);
    }

    public void addPdfAttachment(String description, byte[] fileStore, String file, String fileDisplay, PdfName afRelationshipValue) throws IOException {
        this.addFileAttachment(description, fileStore, file, fileDisplay, MimeTypePdf, afRelationshipValue);
    }

    public void close() {
        super.close();
        this.getPdfAChecker().close(this);
    }

    public PdfAnnotation createAnnotation(Rectangle rect, PdfName subtype) {
        PdfAnnotation a = super.createAnnotation(rect, subtype);
        if (!PdfName.POPUP.equals((Object)subtype)) {
            a.put(PdfName.F, (PdfObject)new PdfNumber(4));
        }
        return a;
    }

    public PdfAnnotation createAnnotation(float llx, float lly, float urx, float ury, PdfString title, PdfString content, PdfName subtype) {
        PdfAnnotation a = super.createAnnotation(llx, lly, urx, ury, title, content, subtype);
        if (!PdfName.POPUP.equals((Object)subtype)) {
            a.put(PdfName.F, (PdfObject)new PdfNumber(4));
        }
        return a;
    }

    public PdfAnnotation createAnnotation(float llx, float lly, float urx, float ury, PdfAction action, PdfName subtype) {
        PdfAnnotation a = super.createAnnotation(llx, lly, urx, ury, action, subtype);
        if (!PdfName.POPUP.equals((Object)subtype)) {
            a.put(PdfName.F, (PdfObject)new PdfNumber(4));
        }
        return a;
    }
}

