/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.xml.xmp;

import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.xml.xmp.XmpWriter;
import com.itextpdf.xmp.XMPException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfAXmpWriter
extends XmpWriter {
    public PdfAXmpWriter(OutputStream os, PdfAConformanceLevel conformanceLevel) throws IOException {
        super(os);
        try {
            this.addRdfDescription(conformanceLevel);
        }
        catch (XMPException xmpExc) {
            throw new IOException(xmpExc.getMessage());
        }
    }

    public PdfAXmpWriter(OutputStream os, PdfDictionary info, PdfAConformanceLevel conformanceLevel) throws IOException {
        super(os, info);
        try {
            this.addRdfDescription(conformanceLevel);
        }
        catch (XMPException xmpExc) {
            throw new IOException(xmpExc.getMessage());
        }
    }

    public PdfAXmpWriter(OutputStream os, Map<String, String> info, PdfAConformanceLevel conformanceLevel) throws IOException {
        super(os, info);
        try {
            this.addRdfDescription(conformanceLevel);
        }
        catch (XMPException xmpExc) {
            throw new IOException(xmpExc.getMessage());
        }
    }

    private void addRdfDescription(PdfAConformanceLevel conformanceLevel) throws XMPException {
        switch (conformanceLevel) {
            case PDF_A_1A: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", (Object)"1");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", (Object)"A");
                break;
            }
            case PDF_A_1B: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", (Object)"1");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", (Object)"B");
                break;
            }
            case PDF_A_2A: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", (Object)"2");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", (Object)"A");
                break;
            }
            case PDF_A_2B: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", (Object)"2");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", (Object)"B");
                break;
            }
            case PDF_A_2U: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", (Object)"2");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", (Object)"U");
                break;
            }
            case PDF_A_3A: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", (Object)"3");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", (Object)"A");
                break;
            }
            case PDF_A_3B: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", (Object)"3");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", (Object)"B");
                break;
            }
            case PDF_A_3U: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", (Object)"3");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", (Object)"U");
                break;
            }
        }
    }
}

