/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.codec.brotli.dec;

import com.itextpdf.io.codec.brotli.dec.BrotliRuntimeException;
import com.itextpdf.io.codec.brotli.dec.State;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

final class Utils {
    private static final byte[] BYTE_ZEROES = new byte[1024];
    private static final int[] INT_ZEROES = new int[1024];

    Utils() {
    }

    static void fillBytesWithZeroes(byte[] dest, int start, int end) {
        int step;
        for (int cursor = start; cursor < end; cursor += step) {
            step = Math.min(cursor + 1024, end) - cursor;
            System.arraycopy(BYTE_ZEROES, 0, dest, cursor, step);
        }
    }

    static void fillIntsWithZeroes(int[] dest, int start, int end) {
        int step;
        for (int cursor = start; cursor < end; cursor += step) {
            step = Math.min(cursor + 1024, end) - cursor;
            System.arraycopy(INT_ZEROES, 0, dest, cursor, step);
        }
    }

    static void copyBytes(byte[] dst, int target, byte[] src, int start, int end) {
        System.arraycopy(src, start, dst, target, end - start);
    }

    static void copyBytesWithin(byte[] bytes, int target, int start, int end) {
        System.arraycopy(bytes, start, bytes, target, end - start);
    }

    static int readInput(State s, byte[] dst, int offset, int length) {
        try {
            return s.input.read(dst, offset, length);
        }
        catch (IOException e) {
            return Utils.makeError(s, -14);
        }
    }

    static InputStream makeEmptyInput() {
        return new ByteArrayInputStream(new byte[0]);
    }

    static void closeInput(State s) throws IOException {
        s.input.close();
        s.input = Utils.makeEmptyInput();
    }

    static byte[] toUsAsciiBytes(String src) {
        try {
            return src.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static int[] toUtf8Runes(String src) {
        int[] result = new int[src.length()];
        for (int i = 0; i < src.length(); ++i) {
            result[i] = src.charAt(i);
        }
        return result;
    }

    static ByteBuffer asReadOnlyBuffer(ByteBuffer src) {
        return src.asReadOnlyBuffer();
    }

    static int isReadOnly(ByteBuffer src) {
        return src.isReadOnly() ? 1 : 0;
    }

    static int isDirect(ByteBuffer src) {
        return src.isDirect() ? 1 : 0;
    }

    static void flipBuffer(Buffer buffer) {
        buffer.flip();
    }

    static int isDebugMode() {
        boolean assertsEnabled = Boolean.parseBoolean(System.getProperty("BROTLI_ENABLE_ASSERTS"));
        return assertsEnabled ? 1 : 0;
    }

    static int getLogBintness() {
        boolean isLongExpensive = Boolean.parseBoolean(System.getProperty("BROTLI_32_BIT_CPU"));
        return isLongExpensive ? 5 : 6;
    }

    static int shr32(int x, int y) {
        return x >>> y;
    }

    static long shr64(long x, int y) {
        return x >>> y;
    }

    static int min(int a, int b) {
        return Math.min(a, b);
    }

    static int makeError(State s, int code) {
        if (code >= 0) {
            return code;
        }
        if (s.runningState >= 0) {
            s.runningState = code;
        }
        if (code <= -21) {
            throw new IllegalStateException("Brotli error code: " + code);
        }
        throw new BrotliRuntimeException("Error code: " + code);
    }
}

