/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.codec.brotli.dec;

import com.itextpdf.io.codec.brotli.dec.State;
import com.itextpdf.io.codec.brotli.dec.Utils;

final class BitReader {
    private static final int LOG_BITNESS = Utils.getLogBintness();
    private static final int BIT_READER_DEBUG = Utils.isDebugMode();
    static final int BITNESS = 1 << LOG_BITNESS;
    private static final int BYTENESS = BITNESS / 8;
    private static final int CAPACITY = 4096;
    private static final int SLACK = 64;
    private static final int BUFFER_SIZE = 4160;
    private static final int SAFEGUARD = 36;
    private static final int WATERLINE = 4060;
    private static final int HALF_BITNESS = BITNESS / 2;
    private static final int HALF_SIZE = BYTENESS / 2;
    private static final int HALVES_CAPACITY = 4096 / HALF_SIZE;
    private static final int HALF_BUFFER_SIZE = 4160 / HALF_SIZE;
    private static final int LOG_HALF_SIZE = LOG_BITNESS - 4;
    static final int HALF_WATERLINE = 4060 / HALF_SIZE;

    BitReader() {
    }

    static int readMoreInput(State s) {
        int bytesInBuffer;
        int len;
        if (s.endOfStreamReached != 0) {
            if (BitReader.halfAvailable(s) >= -2) {
                return 0;
            }
            return Utils.makeError(s, -16);
        }
        int readOffset = s.halfOffset << LOG_HALF_SIZE;
        Utils.copyBytesWithin(s.byteBuffer, 0, readOffset, 4096);
        s.halfOffset = 0;
        for (bytesInBuffer = 4096 - readOffset; bytesInBuffer < 4096; bytesInBuffer += len) {
            int spaceLeft = 4096 - bytesInBuffer;
            len = Utils.readInput(s, s.byteBuffer, bytesInBuffer, spaceLeft);
            if (len < -1) {
                return len;
            }
            if (len > 0) continue;
            s.endOfStreamReached = 1;
            s.tailBytes = bytesInBuffer;
            bytesInBuffer += HALF_SIZE - 1;
            break;
        }
        BitReader.bytesToNibbles(s, bytesInBuffer);
        return 0;
    }

    static int checkHealth(State s, int endOfStream) {
        if (s.endOfStreamReached == 0) {
            return 0;
        }
        int byteOffset = (s.halfOffset << LOG_HALF_SIZE) + (s.bitOffset + 7 >> 3) - BYTENESS;
        if (byteOffset > s.tailBytes) {
            return Utils.makeError(s, -13);
        }
        if (endOfStream != 0 && byteOffset != s.tailBytes) {
            return Utils.makeError(s, -17);
        }
        return 0;
    }

    static void assertAccumulatorHealthy(State s) {
        if (s.bitOffset > BITNESS) {
            throw new IllegalStateException("Accumulator underloaded: " + s.bitOffset);
        }
    }

    static void fillBitWindow(State s) {
        if (BIT_READER_DEBUG != 0) {
            BitReader.assertAccumulatorHealthy(s);
        }
        if (s.bitOffset >= HALF_BITNESS) {
            if (BITNESS == 64) {
                s.accumulator64 = (long)s.intBuffer[s.halfOffset++] << HALF_BITNESS | Utils.shr64(s.accumulator64, HALF_BITNESS);
            } else {
                s.accumulator32 = s.shortBuffer[s.halfOffset++] << HALF_BITNESS | Utils.shr32(s.accumulator32, HALF_BITNESS);
            }
            s.bitOffset -= HALF_BITNESS;
        }
    }

    static void doFillBitWindow(State s) {
        if (BIT_READER_DEBUG != 0) {
            BitReader.assertAccumulatorHealthy(s);
        }
        if (BITNESS == 64) {
            s.accumulator64 = (long)s.intBuffer[s.halfOffset++] << HALF_BITNESS | Utils.shr64(s.accumulator64, HALF_BITNESS);
        } else {
            s.accumulator32 = s.shortBuffer[s.halfOffset++] << HALF_BITNESS | Utils.shr32(s.accumulator32, HALF_BITNESS);
        }
        s.bitOffset -= HALF_BITNESS;
    }

    static int peekBits(State s) {
        if (BITNESS == 64) {
            return (int)Utils.shr64(s.accumulator64, s.bitOffset);
        }
        return Utils.shr32(s.accumulator32, s.bitOffset);
    }

    static int readFewBits(State s, int n) {
        int v = BitReader.peekBits(s) & (1 << n) - 1;
        s.bitOffset += n;
        return v;
    }

    static int readBits(State s, int n) {
        if (HALF_BITNESS >= 24) {
            return BitReader.readFewBits(s, n);
        }
        return n <= 16 ? BitReader.readFewBits(s, n) : BitReader.readManyBits(s, n);
    }

    private static int readManyBits(State s, int n) {
        int low = BitReader.readFewBits(s, 16);
        BitReader.doFillBitWindow(s);
        return low | BitReader.readFewBits(s, n - 16) << 16;
    }

    static int initBitReader(State s) {
        s.byteBuffer = new byte[4160];
        if (BITNESS == 64) {
            s.accumulator64 = 0L;
            s.intBuffer = new int[HALF_BUFFER_SIZE];
        } else {
            s.accumulator32 = 0;
            s.shortBuffer = new short[HALF_BUFFER_SIZE];
        }
        s.bitOffset = BITNESS;
        s.halfOffset = HALVES_CAPACITY;
        s.endOfStreamReached = 0;
        return BitReader.prepare(s);
    }

    private static int prepare(State s) {
        int result;
        if (s.halfOffset > HALF_WATERLINE && (result = BitReader.readMoreInput(s)) != 0) {
            return result;
        }
        int health = BitReader.checkHealth(s, 0);
        if (health != 0) {
            return health;
        }
        BitReader.doFillBitWindow(s);
        BitReader.doFillBitWindow(s);
        return 0;
    }

    static int reload(State s) {
        if (s.bitOffset == BITNESS) {
            return BitReader.prepare(s);
        }
        return 0;
    }

    static int jumpToByteBoundary(State s) {
        int paddingBits;
        int padding = BITNESS - s.bitOffset & 7;
        if (padding != 0 && (paddingBits = BitReader.readFewBits(s, padding)) != 0) {
            return Utils.makeError(s, -5);
        }
        return 0;
    }

    static int halfAvailable(State s) {
        int limit = HALVES_CAPACITY;
        if (s.endOfStreamReached != 0) {
            limit = s.tailBytes + (HALF_SIZE - 1) >> LOG_HALF_SIZE;
        }
        return limit - s.halfOffset;
    }

    static int copyRawBytes(State s, byte[] data, int offset, int length) {
        int len;
        int pos = offset;
        if ((s.bitOffset & 7) != 0) {
            return Utils.makeError(s, -30);
        }
        for (len = length; s.bitOffset != BITNESS && len != 0; --len) {
            data[pos++] = (byte)BitReader.peekBits(s);
            s.bitOffset += 8;
        }
        if (len == 0) {
            return 0;
        }
        int copyNibbles = Utils.min(BitReader.halfAvailable(s), len >> LOG_HALF_SIZE);
        if (copyNibbles > 0) {
            int readOffset = s.halfOffset << LOG_HALF_SIZE;
            int delta = copyNibbles << LOG_HALF_SIZE;
            Utils.copyBytes(data, pos, s.byteBuffer, readOffset, readOffset + delta);
            pos += delta;
            len -= delta;
            s.halfOffset += copyNibbles;
        }
        if (len == 0) {
            return 0;
        }
        if (BitReader.halfAvailable(s) > 0) {
            BitReader.fillBitWindow(s);
            while (len != 0) {
                data[pos++] = (byte)BitReader.peekBits(s);
                s.bitOffset += 8;
                --len;
            }
            return BitReader.checkHealth(s, 0);
        }
        while (len > 0) {
            int chunkLen = Utils.readInput(s, data, pos, len);
            if (chunkLen < -1) {
                return chunkLen;
            }
            if (chunkLen <= 0) {
                return Utils.makeError(s, -16);
            }
            pos += chunkLen;
            len -= chunkLen;
        }
        return 0;
    }

    static void bytesToNibbles(State s, int byteLen) {
        byte[] byteBuffer = s.byteBuffer;
        int halfLen = byteLen >> LOG_HALF_SIZE;
        if (BITNESS == 64) {
            int[] intBuffer = s.intBuffer;
            for (int i = 0; i < halfLen; ++i) {
                intBuffer[i] = byteBuffer[i * 4] & 0xFF | (byteBuffer[i * 4 + 1] & 0xFF) << 8 | (byteBuffer[i * 4 + 2] & 0xFF) << 16 | (byteBuffer[i * 4 + 3] & 0xFF) << 24;
            }
        } else {
            short[] shortBuffer = s.shortBuffer;
            for (int i = 0; i < halfLen; ++i) {
                shortBuffer[i] = (short)(byteBuffer[i * 2] & 0xFF | (byteBuffer[i * 2 + 1] & 0xFF) << 8);
            }
        }
    }
}

