/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.io.font.cmap.CMapCharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class StandardCMapCharsets {
    private static final Map<String, CMapCharsetEncoder> encoders = new HashMap<String, CMapCharsetEncoder>();
    private static final CMapCharsetEncoder UTF16_ENCODER = new CMapCharsetEncoder(StandardCharsets.UTF_16BE);
    private static final CMapCharsetEncoder UCS2_ENCODER = new CMapCharsetEncoder(StandardCharsets.UTF_16BE, true);

    private StandardCMapCharsets() {
    }

    private static void registerHV(String cmapPrefix, CMapCharsetEncoder encoder) {
        encoders.put(cmapPrefix + "-H", encoder);
        encoders.put(cmapPrefix + "-V", encoder);
    }

    private static void registerEncoder() {
        StandardCMapCharsets.registerHV("UniGB-UCS2", UCS2_ENCODER);
        StandardCMapCharsets.registerHV("UniGB-UTF16", UTF16_ENCODER);
        StandardCMapCharsets.registerHV("UniCNS-UCS2", UCS2_ENCODER);
        StandardCMapCharsets.registerHV("UniCNS-UTF16", UTF16_ENCODER);
        StandardCMapCharsets.registerHV("UniJIS-UCS2", UCS2_ENCODER);
        StandardCMapCharsets.registerHV("UniJIS-UTF16", UTF16_ENCODER);
        StandardCMapCharsets.registerHV("UniKS-UCS2", UCS2_ENCODER);
        StandardCMapCharsets.registerHV("UniKS-UTF16", UTF16_ENCODER);
    }

    public static CMapCharsetEncoder getEncoder(String stdCmapName) {
        return encoders.get(stdCmapName);
    }

    public static void disableCharsetEncoders() {
        encoders.clear();
    }

    public static void enableCharsetEncoders() {
        if (encoders.size() == 0) {
            StandardCMapCharsets.registerEncoder();
        }
    }

    static {
        StandardCMapCharsets.registerEncoder();
    }
}

